/*
 * Decompiled with CFR 0.152.
 */
package uk.org.okapibarcode.output;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Locale;

class ExtendedOutputStreamWriter
extends OutputStreamWriter {
    private final String doubleFormat;

    public ExtendedOutputStreamWriter(OutputStream out, String doubleFormat) {
        super(out, StandardCharsets.UTF_8);
        this.doubleFormat = doubleFormat;
    }

    @Override
    public ExtendedOutputStreamWriter append(CharSequence cs) throws IOException {
        super.append(cs);
        return this;
    }

    @Override
    public ExtendedOutputStreamWriter append(CharSequence cs, int start, int end) throws IOException {
        super.append(cs, start, end);
        return this;
    }

    public ExtendedOutputStreamWriter append(double d) throws IOException {
        super.append(String.format(Locale.ROOT, this.doubleFormat, d));
        return this;
    }

    public ExtendedOutputStreamWriter appendInt(int i) throws IOException {
        super.append(String.valueOf(i));
        return this;
    }
}

