/*
 * Decompiled with CFR 0.152.
 */
package uk.org.okapibarcode.output;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.util.Collections;
import java.util.List;
import uk.org.okapibarcode.backend.Hexagon;
import uk.org.okapibarcode.backend.HumanReadableAlignment;
import uk.org.okapibarcode.backend.Symbol;
import uk.org.okapibarcode.backend.TextBox;
import uk.org.okapibarcode.output.SymbolRenderer;

public class Java2DRenderer
implements SymbolRenderer {
    private final Graphics2D g2d;
    private final double magnification;
    private final Color paper;
    private final Color ink;

    public Java2DRenderer(Graphics2D g2d, double magnification, Color paper, Color ink) {
        this.g2d = g2d;
        this.magnification = magnification;
        this.paper = paper;
        this.ink = ink;
    }

    @Override
    public void render(Symbol symbol) {
        int marginX = (int)((double)symbol.getQuietZoneHorizontal() * this.magnification);
        int marginY = (int)((double)symbol.getQuietZoneVertical() * this.magnification);
        Font f = symbol.getFont();
        if (f != null) {
            f = f.deriveFont((float)((double)f.getSize2D() * this.magnification));
        } else {
            f = new Font(symbol.getFontName(), 0, (int)((double)symbol.getFontSize() * this.magnification));
            f = f.deriveFont(Collections.singletonMap(TextAttribute.TRACKING, 0));
        }
        Font oldFont = this.g2d.getFont();
        Color oldColor = this.g2d.getColor();
        if (this.paper != null) {
            int w = (int)((double)symbol.getWidth() * this.magnification);
            int h = (int)((double)symbol.getHeight() * this.magnification);
            this.g2d.setColor(this.paper);
            this.g2d.fillRect(0, 0, w, h);
        }
        this.g2d.setColor(this.ink);
        for (Rectangle2D.Double rect : symbol.getRectangles()) {
            double x = rect.x * this.magnification + (double)marginX;
            double y = rect.y * this.magnification + (double)marginY;
            double w = rect.width * this.magnification;
            double h = rect.height * this.magnification;
            this.g2d.fillRect((int)x, (int)y, (int)w, (int)h);
        }
        for (TextBox text : symbol.getTexts()) {
            float x;
            HumanReadableAlignment alignment = text.alignment == HumanReadableAlignment.JUSTIFY && text.text.length() == 1 ? HumanReadableAlignment.CENTER : text.alignment;
            Font font = alignment != HumanReadableAlignment.JUSTIFY ? f : Java2DRenderer.addTracking(f, text.width * this.magnification, text.text, this.g2d);
            this.g2d.setFont(font);
            FontMetrics fm = this.g2d.getFontMetrics();
            Rectangle2D bounds = fm.getStringBounds(text.text, this.g2d);
            float y = (float)(text.y * this.magnification) + (float)marginY;
            switch (alignment) {
                case LEFT: 
                case JUSTIFY: {
                    x = (float)(this.magnification * text.x + (double)marginX);
                    break;
                }
                case RIGHT: {
                    x = (float)(this.magnification * text.x + this.magnification * text.width - bounds.getWidth() + (double)marginX);
                    break;
                }
                case CENTER: {
                    x = (float)(this.magnification * text.x + this.magnification * text.width / 2.0 - bounds.getWidth() / 2.0 + (double)marginX);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown alignment: " + (Object)((Object)alignment));
                }
            }
            this.g2d.drawString(text.text, x, y);
        }
        for (Hexagon hexagon : symbol.getHexagons()) {
            Polygon polygon = new Polygon();
            for (int j = 0; j < 6; ++j) {
                polygon.addPoint((int)(hexagon.pointX[j] * this.magnification + (double)marginX), (int)(hexagon.pointY[j] * this.magnification + (double)marginY));
            }
            this.g2d.fill(polygon);
        }
        List<Ellipse2D.Double> target = symbol.getTarget();
        int i = 0;
        while (i + 1 < target.size()) {
            Ellipse2D.Double outer = Java2DRenderer.adjust(target.get(i), this.magnification, marginX, marginY);
            Ellipse2D.Double inner = Java2DRenderer.adjust(target.get(i + 1), this.magnification, marginX, marginY);
            Area area = new Area(outer);
            area.subtract(new Area(inner));
            this.g2d.fill(area);
            i += 2;
        }
        this.g2d.setFont(oldFont);
        this.g2d.setColor(oldColor);
    }

    private static Ellipse2D.Double adjust(Ellipse2D.Double ellipse, double magnification, int marginX, int marginY) {
        double x = ellipse.x * magnification + (double)marginX;
        double y = ellipse.y * magnification + (double)marginY;
        double w = ellipse.width * magnification + (double)marginX;
        double h = ellipse.height * magnification + (double)marginY;
        return new Ellipse2D.Double(x, y, w, h);
    }

    private static Font addTracking(Font baseFont, double maxTextWidth, String text, Graphics2D g2d) {
        FontRenderContext frc = g2d.getFontRenderContext();
        double originalWidth = baseFont.getStringBounds(text, frc).getWidth();
        double extraSpace = maxTextWidth - originalWidth;
        double extraSpacePerGap = extraSpace / (double)(text.length() - 1);
        double scaleX = baseFont.isTransformed() ? baseFont.getTransform().getScaleX() : 1.0;
        double tracking = extraSpacePerGap / ((double)baseFont.getSize2D() * scaleX);
        return baseFont.deriveFont(Collections.singletonMap(TextAttribute.TRACKING, tracking));
    }
}

