/*
 * Decompiled with CFR 0.152.
 */
package uk.org.okapibarcode.output;

import java.awt.Color;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.OutputStream;
import uk.org.okapibarcode.backend.Hexagon;
import uk.org.okapibarcode.backend.HumanReadableAlignment;
import uk.org.okapibarcode.backend.Symbol;
import uk.org.okapibarcode.backend.TextBox;
import uk.org.okapibarcode.output.ExtendedOutputStreamWriter;
import uk.org.okapibarcode.output.SymbolRenderer;
import uk.org.okapibarcode.util.Doubles;

public class PostScriptRenderer
implements SymbolRenderer {
    private final OutputStream out;
    private final double magnification;
    private final Color paper;
    private final Color ink;

    public PostScriptRenderer(OutputStream out, double magnification, Color paper, Color ink) {
        this.out = out;
        this.magnification = magnification;
        this.paper = paper;
        this.ink = ink;
    }

    @Override
    public void render(Symbol symbol) throws IOException {
        String content = symbol.getContent();
        int width = (int)((double)symbol.getWidth() * this.magnification);
        int height = (int)((double)symbol.getHeight() * this.magnification);
        int marginX = (int)((double)symbol.getQuietZoneHorizontal() * this.magnification);
        int marginY = (int)((double)symbol.getQuietZoneVertical() * this.magnification);
        String title = content == null || content.isEmpty() ? "OkapiBarcode Generated Symbol" : content;
        try (ExtendedOutputStreamWriter writer = new ExtendedOutputStreamWriter(this.out, "%.2f");){
            int i;
            writer.append("%!PS-Adobe-3.0 EPSF-3.0\n");
            writer.append("%%Creator: OkapiBarcode\n");
            writer.append("%%Title: ").append(title).append('\n');
            writer.append("%%Pages: 0\n");
            writer.append("%%BoundingBox: 0 0 ").appendInt(width).append(" ").appendInt(height).append("\n");
            writer.append("%%EndComments\n");
            writer.append("/TL { setlinewidth moveto lineto stroke } bind def\n");
            writer.append("/TC { moveto 0 360 arc 360 0 arcn fill } bind def\n");
            writer.append("/TH { 0 setlinewidth moveto lineto lineto lineto lineto lineto closepath fill } bind def\n");
            writer.append("/TB { 2 copy } bind def\n");
            writer.append("/TR { newpath 4 1 roll exch moveto 1 index 0 rlineto 0 exch rlineto neg 0 rlineto closepath fill } bind def\n");
            writer.append("/TE { pop pop } bind def\n");
            writer.append("newpath\n");
            writer.append((double)this.ink.getRed() / 255.0).append(" ").append((double)this.ink.getGreen() / 255.0).append(" ").append((double)this.ink.getBlue() / 255.0).append(" setrgbcolor\n");
            writer.append((double)this.paper.getRed() / 255.0).append(" ").append((double)this.paper.getGreen() / 255.0).append(" ").append((double)this.paper.getBlue() / 255.0).append(" setrgbcolor\n");
            writer.append(height).append(" 0.00 TB 0.00 ").append(width).append(" TR\n");
            for (i = 0; i < symbol.getRectangles().size(); ++i) {
                Rectangle2D.Double rect = symbol.getRectangles().get(i);
                if (i == 0) {
                    writer.append("TE\n");
                    writer.append((double)this.ink.getRed() / 255.0).append(" ").append((double)this.ink.getGreen() / 255.0).append(" ").append((double)this.ink.getBlue() / 255.0).append(" setrgbcolor\n");
                    writer.append(rect.height * this.magnification).append(" ").append((double)height - (rect.y + rect.height) * this.magnification - (double)marginY).append(" TB ").append(rect.x * this.magnification + (double)marginX).append(" ").append(rect.width * this.magnification).append(" TR\n");
                    continue;
                }
                Rectangle2D.Double prev = symbol.getRectangles().get(i - 1);
                if (!Doubles.roughlyEqual(rect.height, prev.height) || !Doubles.roughlyEqual(rect.y, prev.y)) {
                    writer.append("TE\n");
                    writer.append((double)this.ink.getRed() / 255.0).append(" ").append((double)this.ink.getGreen() / 255.0).append(" ").append((double)this.ink.getBlue() / 255.0).append(" setrgbcolor\n");
                    writer.append(rect.height * this.magnification).append(" ").append((double)height - (rect.y + rect.height) * this.magnification - (double)marginY).append(" ");
                }
                writer.append("TB ").append(rect.x * this.magnification + (double)marginX).append(" ").append(rect.width * this.magnification).append(" TR\n");
            }
            for (i = 0; i < symbol.getTexts().size(); ++i) {
                HumanReadableAlignment alignment;
                TextBox text = symbol.getTexts().get(i);
                HumanReadableAlignment humanReadableAlignment = alignment = text.alignment == HumanReadableAlignment.JUSTIFY && text.text.length() == 1 ? HumanReadableAlignment.CENTER : text.alignment;
                if (i == 0) {
                    writer.append("TE\n");
                    writer.append((double)this.ink.getRed() / 255.0).append(" ").append((double)this.ink.getGreen() / 255.0).append(" ").append((double)this.ink.getBlue() / 255.0).append(" setrgbcolor\n");
                }
                writer.append("matrix currentmatrix\n");
                writer.append("/").append(symbol.getFontName()).append(" findfont\n");
                writer.append((double)symbol.getFontSize() * this.magnification).append(" scalefont setfont\n");
                double y = (double)height - text.y * this.magnification - (double)marginY;
                switch (alignment) {
                    case LEFT: {
                        double leftX = this.magnification * text.x + (double)marginX;
                        writer.append(" 0 0 moveto ").append(leftX).append(" ").append(y).append(" translate 0.00 rotate 0 0 moveto\n");
                        writer.append(" (").append(text.text).append(") show\n");
                        break;
                    }
                    case JUSTIFY: {
                        double textX = this.magnification * text.x + (double)marginX;
                        double textW = this.magnification * text.width;
                        writer.append(" 0 0 moveto ").append(textX).append(" ").append(y).append(" translate 0.00 rotate 0 0 moveto\n");
                        writer.append(" (").append(text.text).append(") dup stringwidth pop ").append(textW).append(" sub neg 1 index length 1 sub div 0").append(" 3 -1 roll ashow\n");
                        break;
                    }
                    case RIGHT: {
                        double rightX = this.magnification * text.x + this.magnification * text.width + (double)marginX;
                        writer.append(" 0 0 moveto ").append(rightX).append(" ").append(y).append(" translate 0.00 rotate 0 0 moveto\n");
                        writer.append(" (").append(text.text).append(") stringwidth\n");
                        writer.append("pop\n");
                        writer.append("-1 mul 0 rmoveto\n");
                        writer.append(" (").append(text.text).append(") show\n");
                        break;
                    }
                    case CENTER: {
                        double centerX = this.magnification * text.x + this.magnification * text.width / 2.0 + (double)marginX;
                        writer.append(" 0 0 moveto ").append(centerX).append(" ").append(y).append(" translate 0.00 rotate 0 0 moveto\n");
                        writer.append(" (").append(text.text).append(") stringwidth\n");
                        writer.append("pop\n");
                        writer.append("-2 div 0 rmoveto\n");
                        writer.append(" (").append(text.text).append(") show\n");
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown alignment: " + (Object)((Object)alignment));
                    }
                }
                writer.append("setmatrix\n");
            }
            for (i = 0; i < symbol.getTarget().size(); i += 2) {
                Ellipse2D.Double ellipse1 = symbol.getTarget().get(i);
                Ellipse2D.Double ellipse2 = symbol.getTarget().get(i + 1);
                if (i == 0) {
                    writer.append("TE\n");
                    writer.append((double)this.ink.getRed() / 255.0).append(" ").append((double)this.ink.getGreen() / 255.0).append(" ").append((double)this.ink.getBlue() / 255.0).append(" setrgbcolor\n");
                    writer.append((double)this.ink.getRed() / 255.0).append(" ").append((double)this.ink.getGreen() / 255.0).append(" ").append((double)this.ink.getBlue() / 255.0).append(" setrgbcolor\n");
                }
                double x1 = ellipse1.x + ellipse1.width / 2.0;
                double x2 = ellipse2.x + ellipse2.width / 2.0;
                double y1 = (double)height - ellipse1.y - ellipse1.width / 2.0;
                double y2 = (double)height - ellipse2.y - ellipse2.width / 2.0;
                double r1 = ellipse1.width / 2.0;
                double r2 = ellipse2.width / 2.0;
                writer.append(x1 + (double)marginX).append(" ").append(y1 - (double)marginY).append(" ").append(r1).append(" ").append(x2 + (double)marginX).append(" ").append(y2 - (double)marginY).append(" ").append(r2).append(" ").append(x2 + r2 + (double)marginX).append(" ").append(y2 - (double)marginY).append(" TC\n");
            }
            for (i = 0; i < symbol.getHexagons().size(); ++i) {
                Hexagon hexagon = symbol.getHexagons().get(i);
                for (int j = 0; j < 6; ++j) {
                    writer.append(hexagon.pointX[j] + (double)marginX).append(" ").append((double)height - hexagon.pointY[j] - (double)marginY).append(" ");
                }
                writer.append(" TH\n");
            }
            writer.append("\nshowpage\n");
        }
    }
}

