/*
 * Decompiled with CFR 0.152.
 */
package uk.org.okapibarcode.output;

import java.awt.Color;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Text;
import uk.org.okapibarcode.backend.Hexagon;
import uk.org.okapibarcode.backend.HumanReadableAlignment;
import uk.org.okapibarcode.backend.Symbol;
import uk.org.okapibarcode.backend.TextBox;
import uk.org.okapibarcode.output.ExtendedOutputStreamWriter;
import uk.org.okapibarcode.output.SymbolRenderer;

public class SvgRenderer
implements SymbolRenderer {
    private final OutputStream out;
    private final double magnification;
    private final Color paper;
    private final Color ink;
    private final boolean xmlProlog;

    public SvgRenderer(OutputStream out, double magnification, Color paper, Color ink, boolean xmlProlog) {
        this.out = out;
        this.magnification = magnification;
        this.paper = paper;
        this.ink = ink;
        this.xmlProlog = xmlProlog;
    }

    @Override
    public void render(Symbol symbol) throws IOException {
        String content = symbol.getContent();
        int width = (int)((double)symbol.getWidth() * this.magnification);
        int height = (int)((double)symbol.getHeight() * this.magnification);
        int marginX = (int)((double)symbol.getQuietZoneHorizontal() * this.magnification);
        int marginY = (int)((double)symbol.getQuietZoneVertical() * this.magnification);
        String title = content == null || content.isEmpty() ? "OkapiBarcode Generated Symbol" : content;
        String fgColour = String.format("%02X", this.ink.getRed()) + String.format("%02X", this.ink.getGreen()) + String.format("%02X", this.ink.getBlue());
        String bgColour = String.format("%02X", this.paper.getRed()) + String.format("%02X", this.paper.getGreen()) + String.format("%02X", this.paper.getBlue());
        try (ExtendedOutputStreamWriter writer = new ExtendedOutputStreamWriter(this.out, "%.2f");){
            int i;
            if (this.xmlProlog) {
                writer.append("<?xml version=\"1.0\" standalone=\"no\"?>\n");
                writer.append("<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1//EN\"\n");
                writer.append("   \"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\">\n");
            }
            writer.append("<svg width=\"").appendInt(width).append("\" height=\"").appendInt(height).append("\" version=\"1.1").append("\" xmlns=\"http://www.w3.org/2000/svg\">\n");
            writer.append("   <desc>").append(this.clean(title)).append("</desc>\n");
            writer.append("   <g id=\"barcode\" fill=\"#").append(fgColour).append("\">\n");
            writer.append("      <rect x=\"0\" y=\"0\" width=\"").appendInt(width).append("\" height=\"").appendInt(height).append("\" fill=\"#").append(bgColour).append("\" />\n");
            for (i = 0; i < symbol.getRectangles().size(); ++i) {
                Rectangle2D.Double rect = symbol.getRectangles().get(i);
                writer.append("      <rect x=\"").append(rect.x * this.magnification + (double)marginX).append("\" y=\"").append(rect.y * this.magnification + (double)marginY).append("\" width=\"").append(rect.width * this.magnification).append("\" height=\"").append(rect.height * this.magnification).append("\" />\n");
            }
            for (i = 0; i < symbol.getTexts().size(); ++i) {
                String anchor;
                double x;
                TextBox text = symbol.getTexts().get(i);
                HumanReadableAlignment alignment = text.alignment == HumanReadableAlignment.JUSTIFY && text.text.length() == 1 ? HumanReadableAlignment.CENTER : text.alignment;
                switch (alignment) {
                    case LEFT: 
                    case JUSTIFY: {
                        x = this.magnification * text.x + (double)marginX;
                        anchor = "start";
                        break;
                    }
                    case RIGHT: {
                        x = this.magnification * text.x + this.magnification * text.width + (double)marginX;
                        anchor = "end";
                        break;
                    }
                    case CENTER: {
                        x = this.magnification * text.x + this.magnification * text.width / 2.0 + (double)marginX;
                        anchor = "middle";
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown alignment: " + (Object)((Object)alignment));
                    }
                }
                writer.append("      <text x=\"").append(x).append("\" y=\"").append(text.y * this.magnification + (double)marginY).append("\" text-anchor=\"").append(anchor).append("\"\n");
                if (alignment == HumanReadableAlignment.JUSTIFY) {
                    writer.append("         textLength=\"").append(text.width * this.magnification).append("\" lengthAdjust=\"spacing\"\n");
                }
                writer.append("         font-family=\"").append(this.clean(symbol.getFontName())).append("\" font-size=\"").append((double)symbol.getFontSize() * this.magnification).append("\" fill=\"#").append(fgColour).append("\">\n");
                writer.append("         ").append(this.clean(text.text)).append("\n");
                writer.append("      </text>\n");
            }
            for (i = 0; i < symbol.getTarget().size(); ++i) {
                Ellipse2D.Double ellipse = symbol.getTarget().get(i);
                String color = (i & 1) == 0 ? fgColour : bgColour;
                writer.append("      <circle cx=\"").append((ellipse.x + ellipse.width / 2.0) * this.magnification + (double)marginX).append("\" cy=\"").append((ellipse.y + ellipse.width / 2.0) * this.magnification + (double)marginY).append("\" r=\"").append(ellipse.width / 2.0 * this.magnification).append("\" fill=\"#").append(color).append("\" />\n");
            }
            for (i = 0; i < symbol.getHexagons().size(); ++i) {
                Hexagon hexagon = symbol.getHexagons().get(i);
                writer.append("      <path d=\"");
                for (int j = 0; j < 6; ++j) {
                    if (j == 0) {
                        writer.append("M ");
                    } else {
                        writer.append("L ");
                    }
                    writer.append(hexagon.pointX[j] * this.magnification + (double)marginX).append(" ").append(hexagon.pointY[j] * this.magnification + (double)marginY).append(" ");
                }
                writer.append("Z\" />\n");
            }
            writer.append("   </g>\n");
            writer.append("</svg>\n");
        }
    }

    protected String clean(String s) {
        s = s.replaceAll("[\u0000-\u001f]", "");
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Text text = document.createTextNode(s);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            DOMSource source = new DOMSource(text);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.transform(source, result);
            return writer.toString();
        }
        catch (ParserConfigurationException | TransformerException | TransformerFactoryConfigurationError e) {
            return s;
        }
    }
}

