/*
 * Decompiled with CFR 0.152.
 */
package uy.klutter.conversion;

import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import uy.klutter.conversion.ConverterSet;
import uy.klutter.conversion.TypeConversionConfig;
import uy.klutter.reflect.TypeErasureKt;
import uy.klutter.reflect.TypesKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0004H\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a8\u0006\u000b"}, d2={"Luy/klutter/conversion/PrimitiveConverters;", "Luy/klutter/conversion/ConverterSet;", "()V", "convert", "", "fromType", "Ljava/lang/reflect/Type;", "toType", "value", "predicate", "", "klutter-conversion"})
public final class PrimitiveConverters
implements ConverterSet {
    @Override
    public boolean predicate(@NotNull Type fromType, @NotNull Type toType) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)fromType, (String)"fromType");
        Intrinsics.checkParameterIsNotNull((Object)toType, (String)"toType");
        Class fromErased = TypeErasureKt.erasedType((Type)fromType);
        if (TypesKt.isAssignableFrom((KClass)Reflection.getOrCreateKotlinClass(String.class), (Type)fromType)) {
            Type type = toType;
            if (Intrinsics.areEqual((Object)type, String.class) || Intrinsics.areEqual((Object)type, Short.TYPE) || Intrinsics.areEqual((Object)type, Short.class) || Intrinsics.areEqual((Object)type, Byte.TYPE) || Intrinsics.areEqual((Object)type, Byte.class) || Intrinsics.areEqual((Object)type, Integer.TYPE) || Intrinsics.areEqual((Object)type, Integer.class) || Intrinsics.areEqual((Object)type, Long.TYPE) || Intrinsics.areEqual((Object)type, Long.class) || Intrinsics.areEqual((Object)type, Double.TYPE) || Intrinsics.areEqual((Object)type, Double.class) || Intrinsics.areEqual((Object)type, Float.TYPE) || Intrinsics.areEqual((Object)type, Float.class) || Intrinsics.areEqual((Object)type, BigDecimal.class) || Intrinsics.areEqual((Object)type, BigInteger.class) || Intrinsics.areEqual((Object)type, CharSequence.class) || Intrinsics.areEqual((Object)type, byte[].class) || Intrinsics.areEqual((Object)type, Boolean.TYPE) || Intrinsics.areEqual((Object)type, Boolean.class) || Intrinsics.areEqual((Object)type, File.class) || Intrinsics.areEqual((Object)type, URL.class) || Intrinsics.areEqual((Object)type, URI.class)) {
                bl = true;
            } else {
                Class toErased = TypeErasureKt.erasedType((Type)toType);
                bl = toErased.isEnum();
            }
        } else if (TypesKt.isAssignableFrom((KClass)Reflection.getOrCreateKotlinClass(CharSequence.class), (Type)fromType)) {
            Type type = toType;
            bl = Intrinsics.areEqual((Object)type, CharSequence.class) || Intrinsics.areEqual((Object)type, String.class) || Intrinsics.areEqual((Object)type, byte[].class);
        } else if (TypesKt.isAssignableFrom((KClass)Reflection.getOrCreateKotlinClass(Number.class), (Type)fromType)) {
            Type type = toType;
            if (Intrinsics.areEqual((Object)type, Short.TYPE) || Intrinsics.areEqual((Object)type, Short.class) || Intrinsics.areEqual((Object)type, Byte.TYPE) || Intrinsics.areEqual((Object)type, Byte.class) || Intrinsics.areEqual((Object)type, Integer.TYPE) || Intrinsics.areEqual((Object)type, Integer.class) || Intrinsics.areEqual((Object)type, Long.TYPE) || Intrinsics.areEqual((Object)type, Long.class) || Intrinsics.areEqual((Object)type, Double.TYPE) || Intrinsics.areEqual((Object)type, Double.class) || Intrinsics.areEqual((Object)type, Float.TYPE) || Intrinsics.areEqual((Object)type, Float.class) || Intrinsics.areEqual((Object)type, BigDecimal.class) || Intrinsics.areEqual((Object)type, BigInteger.class) || Intrinsics.areEqual((Object)type, String.class) || Intrinsics.areEqual((Object)type, Character.TYPE) || Intrinsics.areEqual((Object)type, Character.class) || Intrinsics.areEqual((Object)type, Boolean.TYPE) || Intrinsics.areEqual((Object)type, Boolean.class) || Intrinsics.areEqual((Object)type, Date.class)) {
                bl = true;
            } else {
                Class toErased = TypeErasureKt.erasedType((Type)toType);
                bl = toErased.isEnum();
            }
        } else {
            Type type;
            Type type2;
            Type type3;
            Class toErased;
            Type type4;
            Type type5;
            Type type6;
            Type type7;
            Type type8;
            bl = TypesKt.isAssignableFrom((KClass)Reflection.getOrCreateKotlinClass(Character.TYPE), (Type)fromType) || TypesKt.isAssignableFrom((KClass)Reflection.getOrCreateKotlinClass(Character.class), (Type)fromType) ? Intrinsics.areEqual((Object)(type8 = toType), Character.TYPE) || Intrinsics.areEqual((Object)type8, Character.class) || Intrinsics.areEqual((Object)type8, Short.TYPE) || Intrinsics.areEqual((Object)type8, Short.class) || Intrinsics.areEqual((Object)type8, Byte.TYPE) || Intrinsics.areEqual((Object)type8, Byte.class) || Intrinsics.areEqual((Object)type8, Integer.TYPE) || Intrinsics.areEqual((Object)type8, Integer.class) || Intrinsics.areEqual((Object)type8, Long.TYPE) || Intrinsics.areEqual((Object)type8, Long.class) || Intrinsics.areEqual((Object)type8, Double.TYPE) || Intrinsics.areEqual((Object)type8, Double.class) || Intrinsics.areEqual((Object)type8, Float.TYPE) || Intrinsics.areEqual((Object)type8, Float.class) || Intrinsics.areEqual((Object)type8, BigDecimal.class) || Intrinsics.areEqual((Object)type8, BigInteger.class) || Intrinsics.areEqual((Object)type8, String.class) || Intrinsics.areEqual((Object)type8, Boolean.TYPE) || Intrinsics.areEqual((Object)type8, Boolean.class) : (TypesKt.isAssignableFrom((KClass)Reflection.getOrCreateKotlinClass(Boolean.TYPE), (Type)fromType) || TypesKt.isAssignableFrom((KClass)Reflection.getOrCreateKotlinClass(Boolean.class), (Type)fromType) ? Intrinsics.areEqual((Object)(type7 = toType), Boolean.TYPE) || Intrinsics.areEqual((Object)type7, Boolean.class) || Intrinsics.areEqual((Object)type7, Character.TYPE) || Intrinsics.areEqual((Object)type7, Character.class) || Intrinsics.areEqual((Object)type7, Short.TYPE) || Intrinsics.areEqual((Object)type7, Short.class) || Intrinsics.areEqual((Object)type7, Byte.TYPE) || Intrinsics.areEqual((Object)type7, Byte.class) || Intrinsics.areEqual((Object)type7, Integer.TYPE) || Intrinsics.areEqual((Object)type7, Integer.class) || Intrinsics.areEqual((Object)type7, Long.TYPE) || Intrinsics.areEqual((Object)type7, Long.class) || Intrinsics.areEqual((Object)type7, Double.TYPE) || Intrinsics.areEqual((Object)type7, Double.class) || Intrinsics.areEqual((Object)type7, Float.TYPE) || Intrinsics.areEqual((Object)type7, Float.class) || Intrinsics.areEqual((Object)type7, BigDecimal.class) || Intrinsics.areEqual((Object)type7, BigInteger.class) || Intrinsics.areEqual((Object)type7, String.class) : (TypesKt.isAssignableFrom((KClass)Reflection.getOrCreateKotlinClass(Date.class), (Type)fromType) ? Intrinsics.areEqual((Object)(type6 = toType), Date.class) || Intrinsics.areEqual((Object)type6, Long.TYPE) || Intrinsics.areEqual((Object)type6, Long.class) : (Intrinsics.areEqual((Object)fromType, byte[].class) ? Intrinsics.areEqual((Object)(type5 = toType), byte[].class) || Intrinsics.areEqual((Object)type5, String.class) : (TypesKt.isAssignableFrom((KClass)Reflection.getOrCreateKotlinClass(Enum.class), (Type)fromType) ? (Intrinsics.areEqual((Object)(type4 = toType), String.class) || Intrinsics.areEqual((Object)type4, Byte.TYPE) || Intrinsics.areEqual((Object)type4, Byte.class) || Intrinsics.areEqual((Object)type4, Short.TYPE) || Intrinsics.areEqual((Object)type4, Short.class) || Intrinsics.areEqual((Object)type4, Integer.TYPE) || Intrinsics.areEqual((Object)type4, Integer.class) || Intrinsics.areEqual((Object)type4, Long.TYPE) || Intrinsics.areEqual((Object)type4, Long.class) ? true : (toErased = TypeErasureKt.erasedType((Type)toType)).isEnum() && TypeConversionConfig.INSTANCE.getPermiteEnumToEnum()) : (Intrinsics.areEqual((Object)fromType, File.class) ? Intrinsics.areEqual((Object)(type3 = toType), File.class) || Intrinsics.areEqual((Object)type3, String.class) : (Intrinsics.areEqual((Object)fromType, URI.class) ? Intrinsics.areEqual((Object)(type2 = toType), URI.class) || Intrinsics.areEqual((Object)type2, String.class) || Intrinsics.areEqual((Object)type2, URL.class) : (Intrinsics.areEqual((Object)fromType, URL.class) ? Intrinsics.areEqual((Object)(type = toType), URL.class) || Intrinsics.areEqual((Object)type, String.class) || Intrinsics.areEqual((Object)type, URI.class) : false)))))));
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public Object convert(@NotNull Type fromType, @NotNull Type toType, @NotNull Object value) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)fromType, (String)"fromType");
        Intrinsics.checkParameterIsNotNull((Object)toType, (String)"toType");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Object object2 = value;
        if (object2 instanceof String) {
            Type type = toType;
            if (Intrinsics.areEqual((Object)type, String.class)) {
                object = (Serializable)value;
            } else if (Intrinsics.areEqual((Object)type, Short.TYPE) || Intrinsics.areEqual((Object)type, Short.class)) {
                String string = (String)value;
                object = Short.parseShort(string);
            } else if (Intrinsics.areEqual((Object)type, Byte.TYPE) || Intrinsics.areEqual((Object)type, Byte.class)) {
                String string = (String)value;
                object = (byte)Short.parseShort(string);
            } else if (Intrinsics.areEqual((Object)type, Integer.TYPE) || Intrinsics.areEqual((Object)type, Integer.class)) {
                String string = (String)value;
                object = Integer.parseInt(string);
            } else if (Intrinsics.areEqual((Object)type, Long.TYPE) || Intrinsics.areEqual((Object)type, Long.class)) {
                String string = (String)value;
                object = Long.parseLong(string);
            } else if (Intrinsics.areEqual((Object)type, Double.TYPE) || Intrinsics.areEqual((Object)type, Double.class)) {
                String string = (String)value;
                object = Double.parseDouble(string);
            } else if (Intrinsics.areEqual((Object)type, Float.TYPE) || Intrinsics.areEqual((Object)type, Float.class)) {
                String string = (String)value;
                object = Float.valueOf(Float.parseFloat(string));
            } else if (Intrinsics.areEqual((Object)type, BigDecimal.class)) {
                object = new BigDecimal((String)value);
            } else if (Intrinsics.areEqual((Object)type, BigInteger.class)) {
                object = new BigDecimal((String)value);
            } else if (Intrinsics.areEqual((Object)type, CharSequence.class)) {
                object = (Serializable)value;
            } else if (Intrinsics.areEqual((Object)type, Boolean.TYPE) || Intrinsics.areEqual((Object)type, Boolean.class)) {
                String string = (String)value;
                object = Boolean.parseBoolean(string);
            } else if (Intrinsics.areEqual((Object)type, byte[].class)) {
                String string = (String)value;
                Charset charset = Charsets.UTF_8;
                byte[] byArray = string.getBytes(charset);
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                object = (Serializable)byArray;
            } else if (Intrinsics.areEqual((Object)type, File.class)) {
                object = new File((String)value);
            } else if (Intrinsics.areEqual((Object)type, URL.class)) {
                object = new URL((String)value);
            } else if (Intrinsics.areEqual((Object)type, URI.class)) {
                object = new URI((String)value);
            } else {
                void $receiver$iv$iv;
                T[] $receiver$iv;
                Class toErased = TypeErasureKt.erasedType((Type)toType);
                if (!toErased.isEnum()) throw (Throwable)new IllegalStateException("Unknown String conversion from " + fromType + " to " + toType);
                Class clazz = toErased;
                if (clazz == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.Class<kotlin.Enum<*>>");
                }
                Class ecls = clazz;
                T[] TArray = ecls.getEnumConstants();
                Intrinsics.checkExpressionValueIsNotNull(TArray, (String)"ecls.getEnumConstants()");
                T[] TArray2 = $receiver$iv = TArray;
                Collection destination$iv$iv = new ArrayList();
                for (void element$iv$iv : $receiver$iv$iv) {
                    Enum it = (Enum)element$iv$iv;
                    if (!Intrinsics.areEqual((Object)it.name(), (Object)value)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Enum enum_ = (Enum)CollectionsKt.first((List)((List)destination$iv$iv));
                object = enum_ != null ? (Serializable)((Object)enum_) : (Serializable)new IllegalStateException("Unknown Enum conversion from " + fromType + " to " + toType + ", no matching value " + value);
            }
        } else if (object2 instanceof CharSequence) {
            Type type = toType;
            if (Intrinsics.areEqual((Object)type, CharSequence.class)) {
                object = value;
            } else if (Intrinsics.areEqual((Object)type, String.class)) {
                object = value.toString();
            } else {
                if (!Intrinsics.areEqual((Object)type, byte[].class)) throw (Throwable)new IllegalStateException("Unknown CharSequence conversion from " + fromType + " to " + toType);
                String toErased = value.toString();
                Charset ecls = Charsets.UTF_8;
                String string = toErased;
                if (string == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                byte[] byArray = string.getBytes(ecls);
                object = byArray;
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            }
        } else if (object2 instanceof Number) {
            Type type = toType;
            if (Intrinsics.areEqual((Object)type, Short.TYPE) || Intrinsics.areEqual((Object)type, Short.class)) {
                object = ((Number)value).shortValue();
            } else if (Intrinsics.areEqual((Object)type, Byte.TYPE) || Intrinsics.areEqual((Object)type, Byte.class)) {
                object = ((Number)value).byteValue();
            } else if (Intrinsics.areEqual((Object)type, Integer.TYPE) || Intrinsics.areEqual((Object)type, Integer.class)) {
                object = ((Number)value).intValue();
            } else if (Intrinsics.areEqual((Object)type, Long.TYPE) || Intrinsics.areEqual((Object)type, Long.class)) {
                object = ((Number)value).longValue();
            } else if (Intrinsics.areEqual((Object)type, Double.TYPE) || Intrinsics.areEqual((Object)type, Double.class)) {
                object = ((Number)value).doubleValue();
            } else if (Intrinsics.areEqual((Object)type, Float.TYPE) || Intrinsics.areEqual((Object)type, Float.class)) {
                object = Float.valueOf(((Number)value).floatValue());
            } else if (Intrinsics.areEqual((Object)type, BigDecimal.class)) {
                object = new BigDecimal(((Number)value).doubleValue());
            } else if (Intrinsics.areEqual((Object)type, BigInteger.class)) {
                object = new BigDecimal(((Number)value).doubleValue());
            } else if (Intrinsics.areEqual((Object)type, String.class)) {
                object = value.toString();
            } else if (Intrinsics.areEqual((Object)type, Character.TYPE) || Intrinsics.areEqual((Object)type, Character.class)) {
                object = Character.valueOf((char)((Number)value).intValue());
            } else if (Intrinsics.areEqual((Object)type, Boolean.TYPE) || Intrinsics.areEqual((Object)type, Boolean.class)) {
                object = Intrinsics.areEqual((Object)value, (Object)0) ^ true;
            } else if (Intrinsics.areEqual((Object)type, Date.class)) {
                object = new Date(((Number)value).longValue());
            } else {
                Class toErased = TypeErasureKt.erasedType((Type)toType);
                if (!toErased.isEnum()) throw (Throwable)new IllegalStateException("Unknown number conversion from " + fromType + " to " + toType);
                Class clazz = toErased;
                if (clazz == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.Class<kotlin.Enum<*>>");
                }
                Class ecls = clazz;
                object = (Enum)ecls.getEnumConstants()[((Number)value).intValue()];
            }
        } else if (object2 instanceof Character) {
            Type type = toType;
            if (Intrinsics.areEqual((Object)type, Character.TYPE) || Intrinsics.areEqual((Object)type, Character.class)) {
                object = value;
            } else if (Intrinsics.areEqual((Object)type, Short.TYPE) || Intrinsics.areEqual((Object)type, Short.class)) {
                object = (short)((Character)value).charValue();
            } else if (Intrinsics.areEqual((Object)type, Byte.TYPE) || Intrinsics.areEqual((Object)type, Byte.class)) {
                object = (byte)((Character)value).charValue();
            } else if (Intrinsics.areEqual((Object)type, Integer.TYPE) || Intrinsics.areEqual((Object)type, Integer.class)) {
                object = (int)((Character)value).charValue();
            } else if (Intrinsics.areEqual((Object)type, Long.TYPE) || Intrinsics.areEqual((Object)type, Long.class)) {
                object = (long)((Character)value).charValue();
            } else if (Intrinsics.areEqual((Object)type, Double.TYPE) || Intrinsics.areEqual((Object)type, Double.class)) {
                object = (double)((Character)value).charValue();
            } else if (Intrinsics.areEqual((Object)type, Float.TYPE) || Intrinsics.areEqual((Object)type, Float.class)) {
                object = Float.valueOf(((Character)value).charValue());
            } else if (Intrinsics.areEqual((Object)type, BigDecimal.class)) {
                object = new BigDecimal(((Character)value).charValue());
            } else if (Intrinsics.areEqual((Object)type, BigInteger.class)) {
                object = new BigDecimal(((Character)value).charValue());
            } else if (Intrinsics.areEqual((Object)type, String.class)) {
                object = value.toString();
            } else {
                if (!Intrinsics.areEqual((Object)type, Boolean.TYPE) && !Intrinsics.areEqual((Object)type, Boolean.class)) throw (Throwable)new IllegalStateException("Unknown char conversion from " + fromType + " to " + toType);
                object = Intrinsics.areEqual((Object)value, (Object)Character.valueOf('1')) || Intrinsics.areEqual((Object)value, (Object)Character.valueOf('T')) || Intrinsics.areEqual((Object)value, (Object)Character.valueOf('t'));
            }
        } else if (object2 instanceof Boolean) {
            Type type = toType;
            if (Intrinsics.areEqual((Object)type, Boolean.TYPE) || Intrinsics.areEqual((Object)type, Boolean.class)) {
                object = value;
            } else if (Intrinsics.areEqual((Object)type, Character.TYPE) || Intrinsics.areEqual((Object)type, Character.class)) {
                object = Character.valueOf((Boolean)value != false ? (char)'T' : 'F');
            } else if (Intrinsics.areEqual((Object)type, Short.TYPE) || Intrinsics.areEqual((Object)type, Short.class)) {
                object = (short)((Boolean)value != false ? 1 : 0);
            } else if (Intrinsics.areEqual((Object)type, Byte.TYPE) || Intrinsics.areEqual((Object)type, Byte.class)) {
                object = (byte)((Boolean)value != false ? 1 : 0);
            } else if (Intrinsics.areEqual((Object)type, Integer.TYPE) || Intrinsics.areEqual((Object)type, Integer.class)) {
                object = (Boolean)value != false ? 1 : 0;
            } else if (Intrinsics.areEqual((Object)type, Long.TYPE) || Intrinsics.areEqual((Object)type, Long.class)) {
                object = (long)((Boolean)value != false ? 1 : 0);
            } else if (Intrinsics.areEqual((Object)type, Double.TYPE) || Intrinsics.areEqual((Object)type, Double.class)) {
                object = (double)((Boolean)value != false ? 1 : 0);
            } else if (Intrinsics.areEqual((Object)type, Float.TYPE) || Intrinsics.areEqual((Object)type, Float.class)) {
                object = Float.valueOf((Boolean)value != false ? 1 : 0);
            } else if (Intrinsics.areEqual((Object)type, BigDecimal.class)) {
                object = new BigDecimal((Boolean)value != false ? 1 : 0);
            } else if (Intrinsics.areEqual((Object)type, BigInteger.class)) {
                object = new BigDecimal((Boolean)value != false ? 1 : 0);
            } else {
                if (!Intrinsics.areEqual((Object)type, String.class)) throw (Throwable)new IllegalStateException("Unknown boolean conversion from " + fromType + " to " + toType);
                object = value.toString();
            }
        } else if (object2 instanceof Date) {
            Type type = toType;
            if (Intrinsics.areEqual((Object)type, Date.class)) {
                object = value;
            } else {
                if (!Intrinsics.areEqual((Object)type, Long.TYPE) && !Intrinsics.areEqual((Object)type, Long.class)) throw (Throwable)new IllegalStateException("Unknown date conversion from " + fromType + " to " + toType);
                object = ((Date)value).getTime();
            }
        } else if (object2 instanceof byte[]) {
            Type type = toType;
            if (Intrinsics.areEqual((Object)type, byte[].class)) {
                object = (Serializable)value;
            } else {
                if (!Intrinsics.areEqual((Object)type, String.class)) throw (Throwable)new IllegalStateException("Unknown ByteArray conversion from " + fromType + " to " + toType);
                byte[] toErased = (byte[])value;
                Charset ecls = Charsets.UTF_8;
                object = (Serializable)((Object)new String(toErased, ecls));
            }
        } else if (object2 instanceof Enum) {
            Type type = toType;
            if (Intrinsics.areEqual((Object)type, String.class)) {
                object = (Serializable)((Object)((Enum)value).name());
            } else if (Intrinsics.areEqual((Object)type, Byte.TYPE) || Intrinsics.areEqual((Object)type, Byte.class)) {
                object = (byte)((Enum)value).ordinal();
            } else if (Intrinsics.areEqual((Object)type, Short.TYPE) || Intrinsics.areEqual((Object)type, Short.class)) {
                object = (short)((Enum)value).ordinal();
            } else if (Intrinsics.areEqual((Object)type, Integer.TYPE) || Intrinsics.areEqual((Object)type, Integer.class)) {
                object = ((Enum)value).ordinal();
            } else if (Intrinsics.areEqual((Object)type, Long.TYPE) || Intrinsics.areEqual((Object)type, Long.class)) {
                object = (long)((Enum)value).ordinal();
            } else {
                T[] $receiver$iv;
                Class toErased = TypeErasureKt.erasedType((Type)toType);
                if (!toErased.isEnum() || !TypeConversionConfig.INSTANCE.getPermiteEnumToEnum()) throw (Throwable)new IllegalStateException("Unknown Enum conversion from " + fromType + " to " + toType);
                Class clazz = toErased;
                if (clazz == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.Class<kotlin.Enum<*>>");
                }
                Class ecls = clazz;
                T[] TArray = ecls.getEnumConstants();
                Intrinsics.checkExpressionValueIsNotNull(TArray, (String)"ecls.getEnumConstants()");
                T[] $receiver$iv$iv = $receiver$iv = TArray;
                Collection destination$iv$iv = new ArrayList();
                for (Object element$iv$iv : $receiver$iv$iv) {
                    Enum it = (Enum)element$iv$iv;
                    if (!Intrinsics.areEqual((Object)it.name(), (Object)((Enum)value).name())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Enum enum_ = (Enum)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
                object = enum_ != null ? (Serializable)((Object)enum_) : (Serializable)new IllegalStateException("Unknown Enum conversion from " + fromType + " to " + toType + ", no matching value " + value);
            }
        } else if (object2 instanceof File) {
            Type type = toType;
            if (Intrinsics.areEqual((Object)type, File.class)) {
                object = value;
            } else {
                if (!Intrinsics.areEqual((Object)type, String.class)) throw (Throwable)new IllegalStateException("Unknown File conversion from " + fromType + " to " + toType);
                object = ((File)value).getAbsolutePath();
            }
        } else if (object2 instanceof URL) {
            Type type = toType;
            if (Intrinsics.areEqual((Object)type, URL.class)) {
                object = (Serializable)value;
            } else if (Intrinsics.areEqual((Object)type, String.class)) {
                object = (Serializable)((Object)value.toString());
            } else {
                if (!Intrinsics.areEqual((Object)type, URI.class)) throw (Throwable)new IllegalStateException("Unknown URL conversion from " + fromType + " to " + toType);
                object = ((URL)value).toURI();
            }
        } else {
            if (!(object2 instanceof URI)) throw (Throwable)new IllegalArgumentException("No primitive conversion for " + fromType + " to " + toType + " for value " + value);
            Type type = toType;
            if (Intrinsics.areEqual((Object)type, URI.class)) {
                object = (Serializable)value;
            } else if (Intrinsics.areEqual((Object)type, String.class)) {
                object = (Serializable)((Object)value.toString());
            } else {
                if (!Intrinsics.areEqual((Object)type, URL.class)) throw (Throwable)new IllegalStateException("Unknown URI conversion from " + fromType + " to " + toType);
                object = ((URI)value).toURL();
            }
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"when (value) {\n         \u2026alue ${value}\")\n        }");
        return object;
    }
}

