/*
 * Decompiled with CFR 0.152.
 */
package uy.klutter.core.collections;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.collections.AbstractIterator;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import uy.klutter.core.collections.LazyBatchingSequence;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010(\n\u0002\b\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00020\u0002:\u0001\u000eB\u001b\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0015\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00020\rH\u0096\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000f"}, d2={"Luy/klutter/core/collections/LazyBatchingSequence;", "T", "Lkotlin/sequences/Sequence;", "stream", "", "groupSize", "", "(Ljava/lang/Iterable;I)V", "getGroupSize", "()I", "getStream", "()Ljava/lang/Iterable;", "iterator", "", "LimitIteratorByCountStream", "klutter-core"})
final class LazyBatchingSequence<T>
implements Sequence<Sequence<? extends T>> {
    @NotNull
    private final Iterable<T> stream;
    private final int groupSize;

    @NotNull
    public Iterator<Sequence<T>> iterator() {
        return (Iterator)new AbstractIterator<Sequence<? extends T>>(this){
            private final Iterator<T> iterate;
            private LimitIteratorByCountStream<T> previousBatch;
            final /* synthetic */ LazyBatchingSequence this$0;

            protected void computeNext() {
                LimitIteratorByCountStream<T> limitIteratorByCountStream = this.previousBatch;
                if (limitIteratorByCountStream != null) {
                    limitIteratorByCountStream.consumeToLimit();
                }
                if (this.iterate.hasNext()) {
                    LimitIteratorByCountStream<T> newBatch = new LimitIteratorByCountStream<T>(this.iterate, this.this$0.getGroupSize());
                    this.setNext(newBatch);
                    this.previousBatch = newBatch;
                } else {
                    this.done();
                }
            }
            {
                this.this$0 = $outer;
                this.iterate = $outer.getGroupSize() > 0 ? $outer.getStream().iterator() : CollectionsKt.emptyList().iterator();
            }
        };
    }

    @NotNull
    public final Iterable<T> getStream() {
        return this.stream;
    }

    public final int getGroupSize() {
        return this.groupSize;
    }

    public LazyBatchingSequence(@NotNull Iterable<? extends T> stream, int groupSize) {
        Intrinsics.checkParameterIsNotNull(stream, (String)"stream");
        this.stream = stream;
        this.groupSize = groupSize;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000+\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000*\u0001\r\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u001b\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u0011\u001a\u00020\u0012J\u000f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004H\u0096\u0002R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR(\u0010\u000b\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00028\u0001 \u000e*\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\r0\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0013"}, d2={"Luy/klutter/core/collections/LazyBatchingSequence$LimitIteratorByCountStream;", "T", "Lkotlin/sequences/Sequence;", "iterator", "", "limit", "", "(Ljava/util/Iterator;I)V", "count", "getIterator", "()Ljava/util/Iterator;", "iteratorRef", "Ljava/util/concurrent/atomic/AtomicReference;", "uy/klutter/core/collections/LazyBatchingSequence$LimitIteratorByCountStream$iteratorRef$1", "kotlin.jvm.PlatformType", "getLimit", "()I", "consumeToLimit", "", "klutter-core"})
    public static final class LimitIteratorByCountStream<T>
    implements Sequence<T> {
        private int count;
        private final AtomicReference<iteratorRef.1> iteratorRef;
        @NotNull
        private final Iterator<T> iterator;
        private final int limit;

        @NotNull
        public Iterator<T> iterator() {
            iteratorRef.1 v0 = this.iteratorRef.getAndSet(null);
            if (v0 == null) {
                throw (Throwable)new IllegalStateException("This sequence can be consumed only once.");
            }
            return (Iterator)((Object)v0);
        }

        public final void consumeToLimit() {
            while (this.iterator.hasNext() && this.count < this.limit) {
                int n = this.count;
                this.count = n + 1;
                this.iterator.next();
            }
        }

        @NotNull
        public final Iterator<T> getIterator() {
            return this.iterator;
        }

        public final int getLimit() {
            return this.limit;
        }

        public LimitIteratorByCountStream(@NotNull Iterator<? extends T> iterator2, int limit) {
            Intrinsics.checkParameterIsNotNull(iterator2, (String)"iterator");
            this.iterator = iterator2;
            this.limit = limit;
            this.iteratorRef = new AtomicReference<iteratorRef.1>(new AbstractIterator<T>(this){
                final /* synthetic */ LimitIteratorByCountStream this$0;

                protected void computeNext() {
                    if (!this.this$0.getIterator().hasNext() || LimitIteratorByCountStream.access$getCount$p(this.this$0) >= this.this$0.getLimit()) {
                        this.done();
                    } else {
                        LimitIteratorByCountStream limitIteratorByCountStream = this.this$0;
                        int n = LimitIteratorByCountStream.access$getCount$p(limitIteratorByCountStream);
                        LimitIteratorByCountStream.access$setCount$p(limitIteratorByCountStream, n + 1);
                        this.setNext(this.this$0.getIterator().next());
                    }
                }
                {
                    this.this$0 = $outer;
                }
            });
        }

        public static final /* synthetic */ int access$getCount$p(LimitIteratorByCountStream $this) {
            return $this.count;
        }

        public static final /* synthetic */ void access$setCount$p(LimitIteratorByCountStream $this, int n) {
            $this.count = n;
        }
    }
}

