/*
 * Decompiled with CFR 0.152.
 */
package uy.klutter.core.uri;

import java.net.URI;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import uy.klutter.core.uri.UrlEncoding;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0011\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\"\u001a\u00020\u0003H\u0016J\u0010\u0010#\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0007H\u0016J\u001c\u0010$\u001a\u0016\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0007\u0018\u00010\u000bH\u0016J\u0016\u0010%\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000bH\u0016J\b\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020'H\u0016J\b\u0010)\u001a\u00020'H\u0016J\b\u0010*\u001a\u00020'H\u0016J\b\u0010+\u001a\u00020'H\u0016J\b\u0010,\u001a\u00020'H\u0016J\b\u0010-\u001a\u00020'H\u0016J\b\u0010.\u001a\u00020/H\u0016R\u0014\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u001a\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR&\u0010\n\u001a\u0016\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0007\u0018\u00010\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR \u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR\u0014\u0010\u0010\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0005R\u0014\u0010\u0012\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0005R\u0014\u0010\u0014\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0005R\u0014\u0010\u0016\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0005R\u0014\u0010\u0018\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0005R\u0014\u0010\u001a\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0005R\u0014\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0005\u00a8\u00060"}, d2={"Luy/klutter/core/uri/ImmutableUri;", "", "decodedFragment", "", "getDecodedFragment", "()Ljava/lang/String;", "decodedPath", "", "getDecodedPath", "()Ljava/util/List;", "decodedQuery", "", "getDecodedQuery", "()Ljava/util/Map;", "decodedQueryDeduped", "getDecodedQueryDeduped", "decodedUserInfo", "getDecodedUserInfo", "encodedFragment", "getEncodedFragment", "encodedPath", "getEncodedPath", "encodedQuery", "getEncodedQuery", "encodedUserInfo", "getEncodedUserInfo", "host", "getHost", "port", "", "getPort", "()Ljava/lang/Integer;", "scheme", "getScheme", "asString", "fragmentAsDecodedPath", "fragmentAsDecodedQuery", "fragmentAsDecodedQueryDeduped", "hasFragment", "", "hasHost", "hasPath", "hasPort", "hasQuery", "hasScheme", "hasUserInfo", "toURI", "Ljava/net/URI;", "klutter-core"})
public interface ImmutableUri {
    @Nullable
    public String getScheme();

    @Nullable
    public String getEncodedUserInfo();

    @Nullable
    public String getDecodedUserInfo();

    @Nullable
    public String getHost();

    @Nullable
    public Integer getPort();

    @Nullable
    public String getEncodedPath();

    @Nullable
    public String getEncodedQuery();

    @Nullable
    public String getEncodedFragment();

    @Nullable
    public String getDecodedFragment();

    @Nullable
    public List<String> getDecodedPath();

    @Nullable
    public Map<String, List<String>> getDecodedQuery();

    @Nullable
    public Map<String, String> getDecodedQueryDeduped();

    public boolean hasScheme();

    public boolean hasPath();

    public boolean hasQuery();

    public boolean hasFragment();

    public boolean hasHost();

    public boolean hasPort();

    public boolean hasUserInfo();

    @NotNull
    public URI toURI();

    @NotNull
    public String asString();

    @Nullable
    public List<String> fragmentAsDecodedPath();

    @Nullable
    public Map<String, List<String>> fragmentAsDecodedQuery();

    @Nullable
    public Map<String, String> fragmentAsDecodedQueryDeduped();

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        public static boolean hasScheme(ImmutableUri $this) {
            CharSequence charSequence;
            String string = $this.getScheme();
            return string != null ? !StringsKt.isBlank((CharSequence)(charSequence = (CharSequence)string)) : false;
        }

        public static boolean hasPath(ImmutableUri $this) {
            CharSequence charSequence;
            String string = $this.getEncodedPath();
            return string != null ? !StringsKt.isBlank((CharSequence)(charSequence = (CharSequence)string)) : false;
        }

        public static boolean hasQuery(ImmutableUri $this) {
            CharSequence charSequence;
            String string = $this.getEncodedQuery();
            return string != null ? !StringsKt.isBlank((CharSequence)(charSequence = (CharSequence)string)) : false;
        }

        public static boolean hasFragment(ImmutableUri $this) {
            CharSequence charSequence;
            String string = $this.getEncodedFragment();
            return string != null ? !StringsKt.isBlank((CharSequence)(charSequence = (CharSequence)string)) : false;
        }

        public static boolean hasHost(ImmutableUri $this) {
            CharSequence charSequence;
            String string = $this.getHost();
            return string != null ? !StringsKt.isBlank((CharSequence)(charSequence = (CharSequence)string)) : false;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static boolean hasPort(ImmutableUri $this) {
            if ($this.getPort() == null) return false;
            Integer n = $this.getPort();
            if (n == null) {
                Intrinsics.throwNpe();
            }
            if (n <= 0) return false;
            return true;
        }

        public static boolean hasUserInfo(ImmutableUri $this) {
            CharSequence charSequence;
            String string = $this.getEncodedUserInfo();
            return string != null ? !StringsKt.isBlank((CharSequence)(charSequence = (CharSequence)string)) : false;
        }

        @NotNull
        public static URI toURI(ImmutableUri $this) {
            return new URI($this.asString());
        }

        @NotNull
        public static String asString(ImmutableUri $this) {
            StringBuffer sb = new StringBuffer();
            if ($this.hasScheme()) {
                sb.append($this.getScheme() + ':');
            }
            if ($this.hasUserInfo() || $this.hasHost() || $this.hasPort()) {
                sb.append("//");
            }
            if ($this.hasUserInfo()) {
                sb.append($this.getEncodedUserInfo() + '@');
            }
            if ($this.hasHost()) {
                sb.append(String.valueOf($this.getHost()));
            }
            if ($this.hasPort()) {
                sb.append("" + ':' + $this.getPort());
            }
            if ($this.hasPath()) {
                sb.append(String.valueOf($this.getEncodedPath()));
            }
            if ($this.hasQuery()) {
                sb.append('?' + $this.getEncodedQuery());
            }
            if ($this.hasFragment()) {
                sb.append('#' + $this.getEncodedFragment());
            }
            String string = sb.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
            return string;
        }

        @Nullable
        public static List<String> fragmentAsDecodedPath(ImmutableUri $this) {
            List<String> list;
            if ($this.getEncodedFragment() == null) {
                list = null;
            } else {
                String string = $this.getEncodedFragment();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                list = UrlEncoding.INSTANCE.decodePathToSegments(string);
            }
            return list;
        }

        @Nullable
        public static Map<String, List<String>> fragmentAsDecodedQuery(ImmutableUri $this) {
            Map<String, List<String>> map;
            if ($this.getEncodedFragment() == null) {
                map = null;
            } else {
                String string = $this.getEncodedFragment();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                map = UrlEncoding.INSTANCE.decodeQueryStringToMultiMap(string);
            }
            return map;
        }

        @Nullable
        public static Map<String, String> fragmentAsDecodedQueryDeduped(ImmutableUri $this) {
            Map<String, String> map;
            if ($this.getEncodedFragment() == null) {
                map = null;
            } else {
                String string = $this.getEncodedFragment();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                map = UrlEncoding.INSTANCE.decodeQueryToMap(string);
            }
            return map;
        }
    }
}

