/*
 * Decompiled with CFR 0.152.
 */
package uy.klutter.core.uri;

import java.net.URI;
import java.net.URL;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import uy.klutter.core.uri.ImmutableUri;
import uy.klutter.core.uri.UriBuilder;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\b\u00a8\u0006\t"}, d2={"buildUri", "Luy/klutter/core/uri/UriBuilder;", "uri", "Ljava/net/URI;", "url", "Ljava/net/URL;", "uriString", "", "Luy/klutter/core/uri/ImmutableUri;", "klutter-core"})
public final class UriBuilderKt {
    @NotNull
    public static final UriBuilder buildUri(@NotNull URI uri) {
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        return new UriBuilder(uri.getScheme(), uri.getRawUserInfo(), uri.getHost(), uri.getPort() < 0 ? null : Integer.valueOf(uri.getPort()), uri.getRawPath(), uri.getRawQuery(), uri.getRawFragment());
    }

    @NotNull
    public static final UriBuilder buildUri(@NotNull String uriString) {
        Intrinsics.checkParameterIsNotNull((Object)uriString, (String)"uriString");
        return UriBuilderKt.buildUri(new URI(uriString));
    }

    @NotNull
    public static final UriBuilder buildUri(@NotNull URL url) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        URI uRI = url.toURI();
        Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"url.toURI()");
        return UriBuilderKt.buildUri(uRI);
    }

    @NotNull
    public static final UriBuilder buildUri(@NotNull ImmutableUri uri) {
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        return new UriBuilder(uri.getScheme(), uri.getEncodedUserInfo(), uri.getHost(), uri.getPort(), uri.getEncodedPath(), uri.getEncodedQuery(), uri.getEncodedFragment());
    }
}

