/*
 * Decompiled with CFR 0.152.
 */
package uy.klutter.core.uri;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CharIterator;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.CharRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import uy.klutter.core.uri.UrlEncoding;
import uy.klutter.core.uri.UrlEncoding$WhenMappings;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0002\u0010\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u001a\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001EB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0014\u001a\u00020\u00042\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0016\"\u00020\u0004H\u0002\u00a2\u0006\u0002\u0010\u0017J\u0014\u0010\u0014\u001a\u00020\u00042\n\u0010\u0018\u001a\u00020\u0019\"\u00020\u001aH\u0002J\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u001bH\u0002J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\b\b\u0002\u0010\u001f\u001a\u00020 J\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001d0\"2\u0006\u0010#\u001a\u00020\u001dJ \u0010$\u001a\u0014\u0012\u0004\u0012\u00020\u001d\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\"0%2\u0006\u0010&\u001a\u00020\u001dJ\u001a\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001d0%2\u0006\u0010&\u001a\u00020\u001dJ,\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001d0%2\u0018\u0010)\u001a\u0014\u0012\u0004\u0012\u00020\u001d\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\"0%J\u000e\u0010*\u001a\u00020\u001d2\u0006\u0010+\u001a\u00020\u001dJ \u0010,\u001a\u00020\u001d2\u0006\u0010-\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010.\u001a\u00020\u0004H\u0002J\u000e\u0010/\u001a\u00020\u001d2\u0006\u00100\u001a\u00020\u001dJ\u000e\u00101\u001a\u00020\u001d2\u0006\u00102\u001a\u00020\u001dJ\u000e\u00103\u001a\u00020\u001d2\u0006\u00104\u001a\u00020\u001dJ\u0014\u00105\u001a\u00020\u001d2\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u001d0\"J\u001a\u00107\u001a\u00020\u001d2\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001d0%J \u00108\u001a\u00020\u001d2\u0018\u0010)\u001a\u0014\u0012\u0004\u0012\u00020\u001d\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\"0%J\u000e\u00109\u001a\u00020\u001d2\u0006\u0010:\u001a\u00020\u001dJ\u000e\u0010;\u001a\u00020\u001d2\u0006\u0010<\u001a\u00020\u001dJ\u000e\u0010=\u001a\u00020\u001d2\u0006\u0010>\u001a\u00020\u001dJ\u0014\u0010?\u001a\u00020@*\u00020\u00042\u0006\u0010A\u001a\u00020\u001aH\u0002J\u0015\u0010B\u001a\u00020\u0004*\u00020\u00042\u0006\u0010C\u001a\u00020\u0004H\u0082\u0002J\u0014\u0010D\u001a\u00020@*\u00020\u00042\u0006\u0010A\u001a\u00020\u001aH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Luy/klutter/core/uri/UrlEncoding;", "", "()V", "ALPHA", "Ljava/util/BitSet;", "ALPHANUM", "DIGIT", "FRAGMENT", "GEN_DELIMS", "LOW_ALPHA", "PATH_PARAM_NAME", "PATH_PARAM_VALUE", "PATH_SEGMENT", "PCHAR", "QUERY", "RESERVED", "SUB_DELIMS", "UNRESERVED", "UP_ALPHA", "USER_INFO", "bitsetFrom", "bitsets", "", "([Ljava/util/BitSet;)Ljava/util/BitSet;", "chars", "", "", "Lkotlin/ranges/CharRange;", "decode", "", "s", "charset", "Ljava/nio/charset/Charset;", "decodePathToSegments", "", "encodedPath", "decodeQueryStringToMultiMap", "", "encodedQuery", "decodeQueryToMap", "dedupeQueryFromMultiMapToMap", "decodedQuery", "encodeFragmentString", "fragment", "encodePart", "part", "allowed", "encodePathParamName", "pathParamName", "encodePathParamValue", "pathParamValue", "encodePathSegment", "pathSegment", "encodePathStringFromSegments", "decodedPath", "encodeQueryMapToString", "encodeQueryMultiMapToString", "encodeQueryNameOrValue", "queryNameOrValue", "encodeQueryNameOrValueNoParen", "queryNameOrValueNoParen", "encodeUserInfo", "userInfo", "clear", "", "c", "plus", "other", "set", "ParseState", "klutter-core"})
public final class UrlEncoding {
    private static final BitSet GEN_DELIMS;
    private static final BitSet SUB_DELIMS;
    private static final BitSet RESERVED;
    private static final BitSet LOW_ALPHA;
    private static final BitSet UP_ALPHA;
    private static final BitSet ALPHA;
    private static final BitSet DIGIT;
    private static final BitSet ALPHANUM;
    private static final BitSet UNRESERVED;
    private static final BitSet PCHAR;
    private static final BitSet USER_INFO;
    private static final BitSet PATH_SEGMENT;
    private static final BitSet PATH_PARAM_NAME;
    private static final BitSet PATH_PARAM_VALUE;
    private static final BitSet QUERY;
    private static final BitSet FRAGMENT;
    public static final UrlEncoding INSTANCE;

    private final void set(@NotNull BitSet $receiver, char c) {
        $receiver.set(c);
    }

    private final void clear(@NotNull BitSet $receiver, char c) {
        $receiver.clear(c);
    }

    private final BitSet bitsetFrom(char ... chars) {
        char[] $receiver$iv;
        BitSet temp = new BitSet();
        char[] cArray = $receiver$iv = chars;
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            char element$iv;
            char it = element$iv = cArray[i];
            INSTANCE.set(temp, it);
        }
        return temp;
    }

    private final BitSet bitsetFrom(CharRange chars) {
        BitSet temp = new BitSet();
        Iterable $receiver$iv = (Iterable)chars;
        Iterator iterator2 = $receiver$iv.iterator();
        while (iterator2.hasNext()) {
            char element$iv;
            char it = element$iv = ((CharIterator)iterator2).nextChar();
            INSTANCE.set(temp, it);
        }
        return temp;
    }

    private final BitSet bitsetFrom(BitSet ... bitsets) {
        BitSet[] $receiver$iv;
        BitSet temp = new BitSet();
        BitSet[] bitSetArray = $receiver$iv = bitsets;
        int n = bitSetArray.length;
        for (int i = 0; i < n; ++i) {
            BitSet element$iv;
            BitSet it = element$iv = bitSetArray[i];
            temp.or(it);
        }
        return temp;
    }

    private final BitSet plus(@NotNull BitSet $receiver, BitSet other) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        BitSet temp = new BitSet();
        temp.or($receiver);
        temp.or(other);
        return temp;
    }

    @NotNull
    public final String encodeFragmentString(@NotNull String fragment) {
        Intrinsics.checkParameterIsNotNull((Object)fragment, (String)"fragment");
        try {
            return this.encodePart(fragment, Charsets.UTF_8, FRAGMENT);
        }
        catch (UnsupportedEncodingException e) {
            throw (Throwable)new RuntimeException(e);
        }
    }

    @NotNull
    public final String encodeUserInfo(@NotNull String userInfo) {
        Intrinsics.checkParameterIsNotNull((Object)userInfo, (String)"userInfo");
        try {
            return this.encodePart(userInfo, Charsets.UTF_8, USER_INFO);
        }
        catch (UnsupportedEncodingException e) {
            throw (Throwable)new RuntimeException(e);
        }
    }

    @NotNull
    public final String encodePathParamName(@NotNull String pathParamName) {
        Intrinsics.checkParameterIsNotNull((Object)pathParamName, (String)"pathParamName");
        try {
            return this.encodePart(pathParamName, Charsets.UTF_8, PATH_PARAM_NAME);
        }
        catch (UnsupportedEncodingException e) {
            throw (Throwable)new RuntimeException(e);
        }
    }

    @NotNull
    public final String encodePathParamValue(@NotNull String pathParamValue) {
        Intrinsics.checkParameterIsNotNull((Object)pathParamValue, (String)"pathParamValue");
        try {
            return this.encodePart(pathParamValue, Charsets.UTF_8, PATH_PARAM_VALUE);
        }
        catch (UnsupportedEncodingException e) {
            throw (Throwable)new RuntimeException(e);
        }
    }

    @NotNull
    public final String encodeQueryNameOrValue(@NotNull String queryNameOrValue) {
        Intrinsics.checkParameterIsNotNull((Object)queryNameOrValue, (String)"queryNameOrValue");
        try {
            return this.encodePart(StringsKt.replace$default((String)queryNameOrValue, (char)' ', (char)'+', (boolean)false, (int)4, null), Charsets.UTF_8, QUERY);
        }
        catch (UnsupportedEncodingException e) {
            throw (Throwable)new RuntimeException(e);
        }
    }

    @NotNull
    public final String encodeQueryNameOrValueNoParen(@NotNull String queryNameOrValueNoParen) {
        Intrinsics.checkParameterIsNotNull((Object)queryNameOrValueNoParen, (String)"queryNameOrValueNoParen");
        try {
            String query = this.encodePart(StringsKt.replace$default((String)queryNameOrValueNoParen, (char)' ', (char)'+', (boolean)false, (int)4, null), Charsets.UTF_8, QUERY);
            query = StringsKt.replace$default((String)query, (String)"(", (String)"", (boolean)false, (int)4, null);
            return StringsKt.replace$default((String)query, (String)")", (String)"", (boolean)false, (int)4, null);
        }
        catch (UnsupportedEncodingException e) {
            throw (Throwable)new RuntimeException(e);
        }
    }

    @NotNull
    public final String encodePathSegment(@NotNull String pathSegment) {
        Intrinsics.checkParameterIsNotNull((Object)pathSegment, (String)"pathSegment");
        try {
            return this.encodePart(pathSegment, Charsets.UTF_8, PATH_SEGMENT);
        }
        catch (UnsupportedEncodingException e) {
            throw (Throwable)new RuntimeException(e);
        }
    }

    private final String encodePart(String part, Charset charset, BitSet allowed) {
        char[] toEncode;
        String string;
        StringBuffer encoded = new StringBuffer(part.length() * 3);
        String string2 = string = part;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        char[] cArray = string2.toCharArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
        for (char c : toEncode = cArray) {
            byte[] bytes;
            String string3;
            if (allowed.get(c)) {
                encoded.append(c);
                continue;
            }
            String string4 = string3 = String.valueOf(c);
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string4.getBytes(charset), (String)"(this as java.lang.String).getBytes(charset)");
            for (byte b : bytes) {
                int u8 = b & 0xFF;
                encoded.append(String.format("%%%1$02X", u8));
            }
        }
        String string5 = encoded.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"encoded.toString()");
        return string5;
    }

    @NotNull
    public final String decode(@NotNull String s, @NotNull Charset charset) {
        String string;
        String string2;
        StringBuffer stringBuffer;
        int n;
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        Intrinsics.checkParameterIsNotNull((Object)charset, (String)"charset");
        boolean decoded = false;
        int l = s.length();
        StringBuffer sb = new StringBuffer(l > 1024 ? l / 3 : l);
        ParseState state = ParseState.sText;
        int i = 0;
        int code = 0;
        int pos = 0;
        int ofs = 0;
        byte[] buf = null;
        boolean processDig = false;
        while (i < l) {
            char c;
            block40: {
                int n2;
                block45: {
                    char c2;
                    block44: {
                        block43: {
                            char c3;
                            block42: {
                                block41: {
                                    block39: {
                                        c = s.charAt(i);
                                        c2 = c;
                                        if (c2 != '+') break block39;
                                        decoded = true;
                                        switch (UrlEncoding$WhenMappings.$EnumSwitchMapping$0[state.ordinal()]) {
                                            case 1: {
                                                sb.append(' ');
                                                break block40;
                                            }
                                            case 2: {
                                                if (buf == null) {
                                                    Intrinsics.throwNpe();
                                                }
                                                byte[] byArray = buf;
                                                n = 0;
                                                n2 = pos + 1;
                                                stringBuffer = sb;
                                                string2 = new String(byArray, n, n2, charset);
                                                stringBuffer.append(string2);
                                                state = ParseState.sText;
                                                sb.append(' ');
                                                break block40;
                                            }
                                            default: {
                                                throw (Throwable)new IllegalArgumentException("decode: unexpected + at pos: " + i + ", of : " + s);
                                            }
                                        }
                                    }
                                    c3 = c2;
                                    if ('0' > c3 || '9' < c3) break block41;
                                    ofs = 48;
                                    processDig = true;
                                    break block40;
                                }
                                c3 = c2;
                                if ('a' > c3 || 'f' < c3) break block42;
                                ofs = 87;
                                processDig = true;
                                break block40;
                            }
                            c3 = c2;
                            if ('A' > c3 || 'F' < c3) break block43;
                            ofs = 55;
                            processDig = true;
                            break block40;
                        }
                        if (c2 != '%') break block44;
                        decoded = true;
                        switch (UrlEncoding$WhenMappings.$EnumSwitchMapping$1[state.ordinal()]) {
                            case 1: {
                                state = ParseState.sEscape;
                                if (buf == null) {
                                    buf = new byte[(l - i) / 3];
                                }
                                pos = 0;
                                break block40;
                            }
                            case 2: {
                                state = ParseState.sEscape;
                                ++pos;
                                break block40;
                            }
                            default: {
                                throw (Throwable)new IllegalArgumentException("decode: unexpected escape % at pos: " + i + ", of : " + s);
                            }
                        }
                    }
                    if (c2 != 'u') break block45;
                    switch (UrlEncoding$WhenMappings.$EnumSwitchMapping$2[state.ordinal()]) {
                        case 1: {
                            if (pos > 0) {
                                if (buf == null) {
                                    Intrinsics.throwNpe();
                                }
                                byte[] byArray = buf;
                                n = 0;
                                stringBuffer = sb;
                                string2 = new String(byArray, n, pos, charset);
                                stringBuffer.append(string2);
                                pos = 0;
                            }
                            state = ParseState.sU1;
                            break block40;
                        }
                        case 2: {
                            sb.append(c);
                            break block40;
                        }
                        case 3: {
                            if (buf == null) {
                                Intrinsics.throwNpe();
                            }
                            byte[] byArray = buf;
                            n = 0;
                            n2 = pos + 1;
                            stringBuffer = sb;
                            string2 = new String(byArray, n, n2, charset);
                            stringBuffer.append(string2);
                            state = ParseState.sText;
                            sb.append(c);
                            break block40;
                        }
                        default: {
                            throw (Throwable)new IllegalArgumentException("decode: unexpected char in hex at pos: " + i + ", of : " + s);
                        }
                    }
                }
                switch (UrlEncoding$WhenMappings.$EnumSwitchMapping$3[state.ordinal()]) {
                    case 1: {
                        sb.append(c);
                        break;
                    }
                    case 2: {
                        if (buf == null) {
                            Intrinsics.throwNpe();
                        }
                        byte[] byArray = buf;
                        n = 0;
                        n2 = pos + 1;
                        stringBuffer = sb;
                        string2 = new String(byArray, n, n2, charset);
                        stringBuffer.append(string2);
                        state = ParseState.sText;
                        sb.append(c);
                        break;
                    }
                    default: {
                        throw (Throwable)new IllegalArgumentException("decode: unexpected char in hex at pos: " + i + ", of : " + s);
                    }
                }
            }
            ++i;
            if (!processDig) continue;
            switch (UrlEncoding$WhenMappings.$EnumSwitchMapping$4[state.ordinal()]) {
                case 1: {
                    code = c - ofs;
                    state = ParseState.s1Dig;
                    break;
                }
                case 2: {
                    if (buf == null) {
                        Intrinsics.throwNpe();
                    }
                    buf[pos] = (byte)(code * 16 + (c - ofs));
                    state = ParseState.s2Dig;
                    break;
                }
                case 3: {
                    if (buf == null) {
                        Intrinsics.throwNpe();
                    }
                    byte[] byArray = buf;
                    int n3 = 0;
                    n = pos + 1;
                    stringBuffer = sb;
                    string2 = new String(byArray, n3, n, charset);
                    stringBuffer.append(string2);
                    state = ParseState.sText;
                    sb.append(c);
                    break;
                }
                case 4: {
                    code = c - ofs;
                    state = ParseState.sU2;
                    break;
                }
                case 5: {
                    code = code * 16 + c - ofs;
                    state = ParseState.sU3;
                    break;
                }
                case 6: {
                    code = code * 16 + c - ofs;
                    state = ParseState.sU4;
                    break;
                }
                case 7: {
                    sb.append((char)(code * 16 + c - ofs));
                    state = ParseState.sText;
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            processDig = false;
        }
        if (state == ParseState.s2Dig) {
            if (buf == null) {
                Intrinsics.throwNpe();
            }
            byte[] byArray = buf;
            int n4 = 0;
            n = pos + 1;
            stringBuffer = sb;
            string2 = new String(byArray, n4, n, charset);
            stringBuffer.append(string2);
        }
        if (decoded) {
            String string3 = sb.toString();
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"sb.toString()");
        } else {
            string = s;
        }
        return string;
    }

    @NotNull
    public static /* synthetic */ String decode$default(UrlEncoding urlEncoding, String string, Charset charset, int n, Object object) {
        if ((n & 2) != 0) {
            charset = Charsets.UTF_8;
        }
        return urlEncoding.decode(string, charset);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> decodePathToSegments(@NotNull String encodedPath) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)encodedPath, (String)"encodedPath");
        Iterable iterable = $receiver$iv = (Iterable)StringsKt.split$default((CharSequence)uy.klutter.core.common.StringsKt.mustNotEndWith(uy.klutter.core.common.StringsKt.mustNotStartWith(encodedPath, '/'), '/'), (char[])new char[]{'/'}, (boolean)false, (int)0, (int)6, null);
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            String string2 = UrlEncoding.decode$default(INSTANCE, (String)it, null, 2, null);
            collection.add(string2);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String encodePathStringFromSegments(@NotNull List<String> decodedPath) {
        String string;
        Intrinsics.checkParameterIsNotNull(decodedPath, (String)"decodedPath");
        if (decodedPath.isEmpty()) {
            string = "";
        } else {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)decodedPath;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                String string2 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                String string3 = INSTANCE.encodePathSegment((String)it);
                collection.add(string3);
            }
            string = uy.klutter.core.common.StringsKt.mustStartWith(CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"/", null, null, (int)0, null, null, (int)62, null), '/');
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, List<String>> decodeQueryStringToMultiMap(@NotNull String encodedQuery) {
        Object value$iv$iv$iv;
        Object key$iv$iv;
        Object $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)encodedQuery, (String)"encodedQuery");
        Object $receiver$iv = SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)StringsKt.splitToSequence$default((CharSequence)encodedQuery, (char[])new char[]{'&'}, (boolean)false, (int)0, (int)6, null), (Function1)decodeQueryStringToMultiMap.1.INSTANCE), (Function1)decodeQueryStringToMultiMap.2.INSTANCE), (Function1)decodeQueryStringToMultiMap.3.INSTANCE);
        Sequence sequence = $receiver$iv;
        Object destination$iv$iv = new LinkedHashMap();
        Object object = $receiver$iv$iv.iterator();
        while (object.hasNext()) {
            Object object2;
            Object $receiver$iv$iv$iv = destination$iv$iv;
            Object element$iv$iv = object.next();
            Pair it = (Pair)element$iv$iv;
            key$iv$iv = (String)it.getFirst();
            value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                ArrayList answer$iv$iv$iv = new ArrayList();
                $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList($receiver$iv.size());
        object = $receiver$iv$iv;
        Iterator iterator2 = object.entrySet().iterator();
        while (iterator2.hasNext()) {
            Collection<String> collection;
            void $receiver$iv$iv2;
            void $receiver$iv2;
            void groupPair;
            Map.Entry item$iv$iv;
            Map.Entry $i$a$4$groupBy = item$iv$iv = iterator2.next();
            Object object3 = destination$iv$iv;
            key$iv$iv = (Iterable)groupPair.getValue();
            Object k = groupPair.getKey();
            value$iv$iv$iv = $receiver$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
            for (Object item$iv$iv2 : $receiver$iv$iv2) {
                void it;
                Pair $i$f$groupByTo = (Pair)item$iv$iv2;
                collection = destination$iv$iv2;
                String string = (String)it.getSecond();
                collection.add(string);
            }
            collection = (List)destination$iv$iv2;
            Pair pair = TuplesKt.to(k, (Object)collection);
            object3.add(pair);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public final Map<String, String> decodeQueryToMap(@NotNull String encodedQuery) {
        Intrinsics.checkParameterIsNotNull((Object)encodedQuery, (String)"encodedQuery");
        return MapsKt.toMap((Iterable)SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)StringsKt.splitToSequence$default((CharSequence)encodedQuery, (char[])new char[]{'&'}, (boolean)false, (int)0, (int)6, null), (Function1)decodeQueryToMap.1.INSTANCE), (Function1)decodeQueryToMap.2.INSTANCE), (Function1)decodeQueryToMap.3.INSTANCE)));
    }

    @NotNull
    public final Map<String, String> dedupeQueryFromMultiMapToMap(@NotNull Map<String, ? extends List<String>> decodedQuery) {
        Intrinsics.checkParameterIsNotNull(decodedQuery, (String)"decodedQuery");
        return MapsKt.toMap((Iterable)SequencesKt.toList((Sequence)SequencesKt.flatMap((Sequence)SequencesKt.filter((Sequence)MapsKt.asSequence(decodedQuery), (Function1)dedupeQueryFromMultiMapToMap.1.INSTANCE), (Function1)dedupeQueryFromMultiMapToMap.2.INSTANCE)));
    }

    @NotNull
    public final String encodeQueryMultiMapToString(@NotNull Map<String, ? extends List<String>> decodedQuery) {
        Intrinsics.checkParameterIsNotNull(decodedQuery, (String)"decodedQuery");
        return SequencesKt.joinToString$default((Sequence)SequencesKt.map((Sequence)SequencesKt.flatMap((Sequence)SequencesKt.filter((Sequence)MapsKt.asSequence(decodedQuery), (Function1)encodeQueryMultiMapToString.1.INSTANCE), (Function1)encodeQueryMultiMapToString.2.INSTANCE), (Function1)encodeQueryMultiMapToString.3.INSTANCE), (CharSequence)"&", null, null, (int)0, null, null, (int)62, null);
    }

    @NotNull
    public final String encodeQueryMapToString(@NotNull Map<String, String> decodedQuery) {
        Intrinsics.checkParameterIsNotNull(decodedQuery, (String)"decodedQuery");
        return SequencesKt.joinToString$default((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)MapsKt.asSequence(decodedQuery), (Function1)encodeQueryMapToString.1.INSTANCE), (Function1)encodeQueryMapToString.2.INSTANCE), (CharSequence)"&", null, null, (int)0, null, null, (int)62, null);
    }

    private UrlEncoding() {
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var1_2;
        BitSet $receiver$iv;
        UrlEncoding urlEncoding;
        INSTANCE = urlEncoding = new UrlEncoding();
        GEN_DELIMS = urlEncoding.bitsetFrom(':', '/', '?', '#', '[', ']', '@');
        SUB_DELIMS = urlEncoding.bitsetFrom('!', '$', '&', '\'', '(', ')', '*', '+', ',', ';', '=');
        RESERVED = urlEncoding.plus(GEN_DELIMS, SUB_DELIMS);
        char c = 'a';
        LOW_ALPHA = urlEncoding.bitsetFrom(new CharRange(c, 'z'));
        c = 'A';
        UP_ALPHA = urlEncoding.bitsetFrom(new CharRange(c, 'Z'));
        ALPHA = urlEncoding.plus(LOW_ALPHA, UP_ALPHA);
        c = '0';
        DIGIT = urlEncoding.bitsetFrom(new CharRange(c, '9'));
        ALPHANUM = urlEncoding.plus(ALPHA, DIGIT);
        BitSet $receiver = $receiver$iv = urlEncoding.plus(ALPHA, DIGIT);
        INSTANCE.set($receiver, '-');
        INSTANCE.set($receiver, '.');
        INSTANCE.set($receiver, '_');
        INSTANCE.set($receiver, '~');
        UNRESERVED = $receiver$iv;
        $receiver = $receiver$iv = urlEncoding.plus(UNRESERVED, SUB_DELIMS);
        INSTANCE.set($receiver, ':');
        INSTANCE.set($receiver, '@');
        PCHAR = $receiver$iv;
        $receiver = $receiver$iv = urlEncoding.plus(UNRESERVED, SUB_DELIMS);
        INSTANCE.set($receiver, ':');
        USER_INFO = $receiver$iv;
        BitSet newSet = $receiver$iv = new BitSet();
        newSet.or(PCHAR);
        INSTANCE.clear(newSet, ';');
        PATH_SEGMENT = $receiver$iv;
        newSet = $receiver$iv = new BitSet();
        newSet.or(PCHAR);
        INSTANCE.clear(newSet, ';');
        INSTANCE.clear(newSet, '=');
        PATH_PARAM_NAME = $receiver$iv;
        newSet = $receiver$iv = new BitSet();
        newSet.or(PCHAR);
        INSTANCE.clear(newSet, ';');
        PATH_PARAM_VALUE = $receiver$iv;
        newSet = $receiver$iv = new BitSet();
        newSet.or(PCHAR);
        INSTANCE.set(newSet, '/');
        INSTANCE.set(newSet, '?');
        INSTANCE.clear(newSet, '=');
        INSTANCE.clear(newSet, '&');
        QUERY = $receiver$iv;
        newSet = $receiver$iv = new BitSet();
        newSet.or(PCHAR);
        INSTANCE.set(newSet, '/');
        INSTANCE.set(newSet, '?');
        FRAGMENT = var1_2;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Luy/klutter/core/uri/UrlEncoding$ParseState;", "", "(Ljava/lang/String;I)V", "sText", "s1Dig", "s2Dig", "sEscape", "sU1", "sU2", "sU3", "sU4", "klutter-core"})
    private static final class ParseState
    extends Enum<ParseState> {
        public static final /* enum */ ParseState sText;
        public static final /* enum */ ParseState s1Dig;
        public static final /* enum */ ParseState s2Dig;
        public static final /* enum */ ParseState sEscape;
        public static final /* enum */ ParseState sU1;
        public static final /* enum */ ParseState sU2;
        public static final /* enum */ ParseState sU3;
        public static final /* enum */ ParseState sU4;
        private static final /* synthetic */ ParseState[] $VALUES;

        static {
            ParseState[] parseStateArray = new ParseState[8];
            ParseState[] parseStateArray2 = parseStateArray;
            parseStateArray[0] = sText = new ParseState();
            parseStateArray[1] = s1Dig = new ParseState();
            parseStateArray[2] = s2Dig = new ParseState();
            parseStateArray[3] = sEscape = new ParseState();
            parseStateArray[4] = sU1 = new ParseState();
            parseStateArray[5] = sU2 = new ParseState();
            parseStateArray[6] = sU3 = new ParseState();
            parseStateArray[7] = sU4 = new ParseState();
            $VALUES = parseStateArray;
        }

        public static ParseState[] values() {
            return (ParseState[])$VALUES.clone();
        }

        public static ParseState valueOf(String string) {
            return Enum.valueOf(ParseState.class, string);
        }
    }
}

