/*
 * Decompiled with CFR 0.152.
 */
package uy.klutter.vertx;

import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.Session;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import uy.klutter.core.uri.ExternalizeUrlKt;
import uy.klutter.core.uri.UriBuilderKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000<\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0001\u001a\n\u0010\u0004\u001a\u00020\u0005*\u00020\u0002\u001a\u0012\u0010\u0004\u001a\u00020\u0005*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0001\u001a\u001c\u0010\u0006\u001a\u00020\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\u00012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u001a(\u0010\f\u001a\u00020\u0007*\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u000f2\b\b\u0002\u0010\u0011\u001a\u00020\u0012\u001a\u0014\u0010\u0013\u001a\u0004\u0018\u00010\u000b*\u00020\b2\u0006\u0010\t\u001a\u00020\u0001\u00a8\u0006\u0014"}, d2={"externalizeUrl", "", "Lio/vertx/ext/web/RoutingContext;", "resolveUrl", "externalizeUrlToUri", "Ljava/net/URI;", "putSafely", "", "Lio/vertx/ext/web/Session;", "key", "value", "", "redirectToHttpsHandler", "Lio/vertx/ext/web/Route;", "httpsPort", "", "redirectCode", "failOnUrlBuilding", "", "removeSafely", "klutter-vertx3"})
public final class VertxWebKt {
    public static final void putSafely(@NotNull Session $receiver, @NotNull String key, @Nullable Object value) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        if (value == null) {
            $receiver.remove(key);
        } else {
            $receiver.put(key, value);
        }
    }

    @Nullable
    public static final Object removeSafely(@NotNull Session $receiver, @NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return $receiver.remove(key);
    }

    @NotNull
    public static final String externalizeUrl(@NotNull RoutingContext $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return VertxWebKt.externalizeUrl($receiver, ExternalizeUrlKt.pathPlusParmsOfUrl((URI)new URI($receiver.request().absoluteURI())));
    }

    @NotNull
    public static final URI externalizeUrlToUri(@NotNull RoutingContext $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return VertxWebKt.externalizeUrlToUri($receiver, ExternalizeUrlKt.pathPlusParmsOfUrl((URI)new URI($receiver.request().absoluteURI())));
    }

    @NotNull
    public static final String externalizeUrl(@NotNull RoutingContext $receiver, @NotNull String resolveUrl) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)resolveUrl, (String)"resolveUrl");
        String string = VertxWebKt.externalizeUrlToUri($receiver, resolveUrl).toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"externalizeUrlToUri(resolveUrl).toString()");
        return string;
    }

    @NotNull
    public static final URI externalizeUrlToUri(@NotNull RoutingContext $receiver, @NotNull String resolveUrl) {
        Map.Entry it;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)resolveUrl, (String)"resolveUrl");
        MultiMap multiMap = $receiver.request().headers();
        Intrinsics.checkExpressionValueIsNotNull((Object)multiMap, (String)"request().headers()");
        Iterable iterable = $receiver$iv = (Iterable)multiMap;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (Map.Entry)element$iv$iv;
            CharSequence charSequence = (CharSequence)it.getValue();
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            Pair pair = TuplesKt.to(it.getKey(), it.getValue());
            collection.add(pair);
        }
        Map cleanHeaders = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        return ExternalizeUrlKt.externalizeURI((URI)new URI($receiver.request().absoluteURI()), (String)resolveUrl, (Map)cleanHeaders);
    }

    public static final void redirectToHttpsHandler(@NotNull Route $receiver, int httpsPort, int redirectCode, boolean failOnUrlBuilding) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        $receiver.handler((Handler)new Handler<RoutingContext>(httpsPort, redirectCode, failOnUrlBuilding){
            final /* synthetic */ int $httpsPort;
            final /* synthetic */ int $redirectCode;
            final /* synthetic */ boolean $failOnUrlBuilding;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final void handle(RoutingContext context) {
                String proto;
                String string = context.request().getHeader("X-Forwarded-Proto");
                if (string == null) {
                    string = proto = context.request().getHeader("X-Forwarded-Scheme");
                }
                if (Intrinsics.areEqual((Object)proto, (Object)"https")) {
                    context.next();
                    return;
                }
                CharSequence charSequence = proto;
                if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                    HttpServerRequest httpServerRequest = context.request();
                    Intrinsics.checkExpressionValueIsNotNull((Object)httpServerRequest, (String)"context.request()");
                    if (httpServerRequest.isSSL()) {
                        context.next();
                        return;
                    }
                }
                try {
                    RoutingContext routingContext = context;
                    Intrinsics.checkExpressionValueIsNotNull((Object)routingContext, (String)"context");
                    String myPublicUri = VertxWebKt.externalizeUrl(routingContext);
                    String myHttpsPublicUri = UriBuilderKt.buildUri((String)myPublicUri).scheme("https").port(Integer.valueOf(this.$httpsPort)).toString();
                    context.response().putHeader("location", myHttpsPublicUri).setStatusCode(this.$redirectCode).end();
                    return;
                }
                catch (Throwable ex) {
                    if (this.$failOnUrlBuilding) {
                        context.fail(ex);
                        return;
                    }
                    context.next();
                }
            }
            {
                this.$httpsPort = n;
                this.$redirectCode = n2;
                this.$failOnUrlBuilding = bl;
            }
        });
    }

    public static /* synthetic */ void redirectToHttpsHandler$default(Route route, int n, int n2, boolean bl, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 443;
        }
        if ((n3 & 2) != 0) {
            n2 = 302;
        }
        if ((n3 & 4) != 0) {
            bl = true;
        }
        VertxWebKt.redirectToHttpsHandler(route, n, n2, bl);
    }
}

