/*
 * Decompiled with CFR 0.152.
 */
package uy.klutter.vertx.json;

import io.vertx.core.json.Json;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.time.temporal.Temporal;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import uy.klutter.core.common.DatesKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\"\u0010\u0000\u001a\u00020\u00012\u0017\u0010\u0002\u001a\u0013\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\b\u0005H\u0086\b\u001a\u001d\u0010\u0006\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\tH\u0086\b\u001a\u0011\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\fH\u0086\b\u001a\"\u0010\r\u001a\u00020\u000e2\u0017\u0010\u0002\u001a\u0013\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\b\u0005H\u0086\b\u001a#\u0010\u000f\u001a\u00020\u000e\"\u0004\b\u0000\u0010\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u0002H\u00100\u0012H\u0086\b\u001a\u0011\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0086\b\u001a\u0011\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0086\b\u001a&\u0010\u0017\u001a\u00020\u0001*\u00020\u00012\u0017\u0010\u0002\u001a\u0013\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\b\u0005H\u0086\b\u001a\u0015\u0010\u0018\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0019\u001a\u00020\u001aH\u0086\b\u001a&\u0010\u001b\u001a\u00020\u0001*\u00020\u00012\u0017\u0010\u0002\u001a\u0013\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\b\u0005H\u0086\b\u001a.\u0010\u001c\u001a\u00020\u000e*\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\f2\u0017\u0010\u0002\u001a\u0013\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\b\u0005H\u0086\b\u001a\u001d\u0010\u001e\u001a\u00020\u000e*\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0086\b\u001a.\u0010\u001f\u001a\u00020\u000e*\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\f2\u0017\u0010\u0002\u001a\u0013\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\b\u0005H\u0086\b\u00a8\u0006 "}, d2={"jsonArray", "Lio/vertx/core/json/JsonArray;", "init", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "jsonArrayFromList", "T", "list", "", "jsonArrayFromString", "json", "", "jsonObject", "Lio/vertx/core/json/JsonObject;", "jsonObjectFromMap", "V", "map", "", "jsonObjectFromPojo", "something", "", "jsonObjectFromString", "addArray", "addDateIsoString", "value", "Ljava/time/temporal/Temporal;", "addObject", "putArray", "name", "putDateIsoString", "putObject", "klutter-vertx3"})
public final class VertxJsonKt {
    @NotNull
    public static final JsonObject jsonObjectFromString(@NotNull String json) {
        Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
        return new JsonObject(json);
    }

    @NotNull
    public static final JsonArray jsonArrayFromString(@NotNull String json) {
        Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
        return new JsonArray(json);
    }

    @NotNull
    public static final <V> JsonObject jsonObjectFromMap(@NotNull Map<String, ? extends V> map) {
        Intrinsics.checkParameterIsNotNull(map, (String)"map");
        return new JsonObject(map);
    }

    @NotNull
    public static final <T> JsonArray jsonArrayFromList(@NotNull List<? extends T> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"list");
        return new JsonArray(list);
    }

    @NotNull
    public static final JsonObject jsonObjectFromPojo(@NotNull Object something) {
        Intrinsics.checkParameterIsNotNull((Object)something, (String)"something");
        Object object = Json.mapper.convertValue(something, Map.class);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
        }
        Map map$iv = (Map)object;
        return new JsonObject(map$iv);
    }

    @NotNull
    public static final JsonObject jsonObject(@NotNull Function1<? super JsonObject, Unit> init) {
        Intrinsics.checkParameterIsNotNull(init, (String)"init");
        JsonObject jsonObject = new JsonObject();
        init.invoke((Object)jsonObject);
        return jsonObject;
    }

    @NotNull
    public static final JsonArray jsonArray(@NotNull Function1<? super JsonArray, Unit> init) {
        Intrinsics.checkParameterIsNotNull(init, (String)"init");
        JsonArray jsonArray = new JsonArray();
        init.invoke((Object)jsonArray);
        return jsonArray;
    }

    @NotNull
    public static final JsonObject putObject(@NotNull JsonObject $receiver, @NotNull String name, @NotNull Function1<? super JsonObject, Unit> init) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull(init, (String)"init");
        String string = name;
        JsonObject jsonObject = $receiver;
        JsonObject jsonObject$iv = new JsonObject();
        init.invoke((Object)jsonObject$iv);
        JsonObject jsonObject2 = jsonObject$iv;
        jsonObject.put(string, jsonObject2);
        return $receiver;
    }

    @NotNull
    public static final JsonObject putArray(@NotNull JsonObject $receiver, @NotNull String name, @NotNull Function1<? super JsonArray, Unit> init) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull(init, (String)"init");
        String string = name;
        JsonObject jsonObject = $receiver;
        JsonArray jsonArray$iv = new JsonArray();
        init.invoke((Object)jsonArray$iv);
        JsonArray jsonArray = jsonArray$iv;
        jsonObject.put(string, jsonArray);
        return $receiver;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final JsonArray addObject(@NotNull JsonArray $receiver, @NotNull Function1<? super JsonObject, Unit> init) {
        void var3_3;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull(init, (String)"init");
        JsonArray jsonArray = $receiver;
        JsonObject jsonObject$iv = new JsonObject();
        init.invoke((Object)jsonObject$iv);
        void var6_4 = var3_3;
        jsonArray.add((JsonObject)var6_4);
        return $receiver;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final JsonArray addArray(@NotNull JsonArray $receiver, @NotNull Function1<? super JsonArray, Unit> init) {
        void var3_3;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull(init, (String)"init");
        JsonArray jsonArray = $receiver;
        JsonArray jsonArray$iv = new JsonArray();
        init.invoke((Object)jsonArray$iv);
        void var6_4 = var3_3;
        jsonArray.add((JsonArray)var6_4);
        return $receiver;
    }

    @NotNull
    public static final JsonObject putDateIsoString(@NotNull JsonObject $receiver, @NotNull String name, @NotNull Temporal value) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        JsonObject jsonObject = $receiver.put(name, DatesKt.toIsoString((Temporal)value));
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonObject, (String)"put(name, value.toIsoString())");
        return jsonObject;
    }

    @NotNull
    public static final JsonArray addDateIsoString(@NotNull JsonArray $receiver, @NotNull Temporal value) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        JsonArray jsonArray = $receiver.add(DatesKt.toIsoString((Temporal)value));
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonArray, (String)"add(value.toIsoString())");
        return jsonArray;
    }
}

