/*
 * Decompiled with CFR 0.152.
 */
package net.sf.acegisecurity.adapters.jboss;

import java.io.IOException;
import java.security.Principal;
import java.util.Iterator;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import net.sf.acegisecurity.Authentication;
import net.sf.acegisecurity.context.security.SecureContext;
import net.sf.acegisecurity.context.security.SecureContextUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JbossIntegrationFilter
implements Filter {
    private static final Log logger = LogFactory.getLog((Class)(class$net$sf$acegisecurity$adapters$jboss$JbossIntegrationFilter == null ? (class$net$sf$acegisecurity$adapters$jboss$JbossIntegrationFilter = JbossIntegrationFilter.class$("net.sf.acegisecurity.adapters.jboss.JbossIntegrationFilter")) : class$net$sf$acegisecurity$adapters$jboss$JbossIntegrationFilter));
    static /* synthetic */ Class class$net$sf$acegisecurity$adapters$jboss$JbossIntegrationFilter;

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        SecureContext sc = SecureContextUtils.getSecureContext();
        Object principal = this.extractFromContainer(request);
        if (principal != null && principal instanceof Authentication) {
            sc.setAuthentication((Authentication)principal);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("ContextHolder updated with Authentication from container: '" + principal + "'"));
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("ContextHolder not set with new Authentication as Principal was: '" + principal + "'"));
        }
        chain.doFilter(request, response);
    }

    public void init(FilterConfig arg0) throws ServletException {
    }

    protected Context getLookupContext() throws NamingException {
        return new InitialContext();
    }

    private Object extractFromContainer(ServletRequest request) {
        Subject subject;
        block7: {
            subject = null;
            try {
                Context lc = this.getLookupContext();
                if (lc == null) {
                    if (logger.isWarnEnabled()) {
                        logger.warn((Object)"Could not obtain a Context to perform lookup");
                    }
                    return null;
                }
                Object result = lc.lookup("java:comp/env/security/subject");
                if (result instanceof Subject) {
                    subject = (Subject)result;
                }
            }
            catch (NamingException ne) {
                if (!logger.isWarnEnabled()) break block7;
                logger.warn((Object)("Lookup on Subject failed " + ne.getLocalizedMessage()));
            }
        }
        if (subject != null && subject.getPrincipals() != null) {
            Iterator<Principal> principals = subject.getPrincipals().iterator();
            while (principals.hasNext()) {
                Principal p = principals.next();
                if (!(p instanceof Authentication)) continue;
                return p;
            }
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

