/*
 * Decompiled with CFR 0.152.
 */
package net.sf.acegisecurity.intercept.method;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import net.sf.acegisecurity.ConfigAttribute;
import net.sf.acegisecurity.ConfigAttributeDefinition;
import net.sf.acegisecurity.intercept.method.AbstractMethodDefinitionSource;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.metadata.Attributes;

public class MethodDefinitionAttributes
extends AbstractMethodDefinitionSource {
    private Attributes attributes;

    public void setAttributes(Attributes attributes) {
        this.attributes = attributes;
    }

    public Iterator getConfigAttributeDefinitions() {
        return null;
    }

    protected ConfigAttributeDefinition lookupAttributes(MethodInvocation invocation) {
        ConfigAttributeDefinition definition = new ConfigAttributeDefinition();
        Class<?> interceptedClass = invocation.getMethod().getDeclaringClass();
        this.addClassAttributes(definition, interceptedClass);
        this.addClassAttributes(definition, interceptedClass.getInterfaces());
        this.addMethodAttributes(definition, invocation.getMethod());
        this.addInterfaceMethodAttributes(definition, invocation.getMethod());
        if (definition.size() == 0) {
            return null;
        }
        return definition;
    }

    private void add(ConfigAttributeDefinition definition, Collection attribs) {
        Iterator iter = attribs.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof ConfigAttribute)) continue;
            definition.addConfigAttribute((ConfigAttribute)o);
        }
    }

    private void addClassAttributes(ConfigAttributeDefinition definition, Class clazz) {
        this.addClassAttributes(definition, new Class[]{clazz});
    }

    private void addClassAttributes(ConfigAttributeDefinition definition, Class[] clazz) {
        for (int i = 0; i < clazz.length; ++i) {
            Collection classAttributes = this.attributes.getAttributes(clazz[i]);
            if (classAttributes == null) continue;
            this.add(definition, classAttributes);
        }
    }

    private void addInterfaceMethodAttributes(ConfigAttributeDefinition definition, Method method) {
        Class<?>[] interfaces = method.getDeclaringClass().getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            Class<?> clazz = interfaces[i];
            try {
                Method m = clazz.getDeclaredMethod(method.getName(), method.getParameterTypes());
                this.addMethodAttributes(definition, m);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private void addMethodAttributes(ConfigAttributeDefinition definition, Method method) {
        Collection methodAttributes = this.attributes.getAttributes(method);
        if (methodAttributes != null) {
            this.add(definition, methodAttributes);
        }
    }
}

