/*
 * Decompiled with CFR 0.152.
 */
package net.sf.acegisecurity.providers;

import java.util.Iterator;
import java.util.List;
import net.sf.acegisecurity.AbstractAuthenticationManager;
import net.sf.acegisecurity.Authentication;
import net.sf.acegisecurity.AuthenticationException;
import net.sf.acegisecurity.providers.AuthenticationProvider;
import net.sf.acegisecurity.providers.ProviderNotFoundException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;

public class ProviderManager
extends AbstractAuthenticationManager
implements InitializingBean {
    private static final Log logger = LogFactory.getLog((Class)(class$net$sf$acegisecurity$providers$ProviderManager == null ? (class$net$sf$acegisecurity$providers$ProviderManager = ProviderManager.class$("net.sf.acegisecurity.providers.ProviderManager")) : class$net$sf$acegisecurity$providers$ProviderManager));
    private List providers;
    static /* synthetic */ Class class$net$sf$acegisecurity$providers$ProviderManager;

    public void setProviders(List newList) {
        this.checkIfValidList(newList);
        Iterator iter = newList.iterator();
        while (iter.hasNext()) {
            Object currentObject = null;
            try {
                currentObject = iter.next();
                AuthenticationProvider attemptToCast = (AuthenticationProvider)currentObject;
            }
            catch (ClassCastException cce) {
                throw new IllegalArgumentException("AuthenticationProvider " + currentObject.getClass().getName() + " must implement AuthenticationProvider");
            }
        }
        this.providers = newList;
    }

    public List getProviders() {
        return this.providers;
    }

    public void afterPropertiesSet() throws Exception {
        this.checkIfValidList(this.providers);
    }

    public Authentication doAuthentication(Authentication authentication) throws AuthenticationException {
        Iterator iter = this.providers.iterator();
        Class<?> toTest = authentication.getClass();
        while (iter.hasNext()) {
            AuthenticationProvider provider = (AuthenticationProvider)iter.next();
            if (!provider.supports(toTest)) continue;
            logger.debug((Object)("Authentication attempt using " + provider.getClass().getName()));
            Authentication result = provider.authenticate(authentication);
            if (result == null) continue;
            return result;
        }
        throw new ProviderNotFoundException("No authentication provider for " + toTest.getName());
    }

    private void checkIfValidList(List listToCheck) {
        if (listToCheck == null || listToCheck.size() == 0) {
            throw new IllegalArgumentException("A list of AuthenticationManagers is required");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

