/*
 * Decompiled with CFR 0.152.
 */
package net.sf.acegisecurity.ui;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import net.sf.acegisecurity.Authentication;
import net.sf.acegisecurity.adapters.HttpRequestIntegrationFilter;
import net.sf.acegisecurity.adapters.jboss.JbossIntegrationFilter;
import net.sf.acegisecurity.ui.AbstractIntegrationFilter;
import net.sf.acegisecurity.ui.webapp.HttpSessionIntegrationFilter;

public class AutoIntegrationFilter
extends AbstractIntegrationFilter {
    public void commitToContainer(ServletRequest request, Authentication authentication) {
        if (request instanceof HttpServletRequest) {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            if (this.getHttpSessionIntegrationFilter().extractFromContainer(request) != null) {
                this.getHttpSessionIntegrationFilter().commitToContainer(request, authentication);
                return;
            }
        }
    }

    public Object extractFromContainer(ServletRequest request) {
        if (request instanceof HttpServletRequest) {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            if (httpRequest.getUserPrincipal() instanceof Authentication) {
                return this.getHttpServletRequest().extractFromContainer(request);
            }
            if (this.getHttpSessionIntegrationFilter().extractFromContainer(request) != null) {
                return this.getHttpSessionIntegrationFilter().extractFromContainer(request);
            }
            try {
                Class<?> simplePrincipalClass = Class.forName("org.jboss.security.SimplePrincipal");
                if (null != httpRequest.getUserPrincipal() && simplePrincipalClass.isAssignableFrom(httpRequest.getUserPrincipal().getClass())) {
                    return this.getJbossIntegrationFilter().extractFromContainer(request);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    protected HttpRequestIntegrationFilter getHttpServletRequest() {
        return new HttpRequestIntegrationFilter();
    }

    protected HttpSessionIntegrationFilter getHttpSessionIntegrationFilter() {
        return new HttpSessionIntegrationFilter();
    }

    protected JbossIntegrationFilter getJbossIntegrationFilter() {
        return new JbossIntegrationFilter();
    }
}

