/*
 * Decompiled with CFR 0.152.
 */
package net.sf.acegisecurity.providers.dao;

import net.sf.acegisecurity.AccountExpiredException;
import net.sf.acegisecurity.Authentication;
import net.sf.acegisecurity.AuthenticationException;
import net.sf.acegisecurity.AuthenticationServiceException;
import net.sf.acegisecurity.BadCredentialsException;
import net.sf.acegisecurity.CredentialsExpiredException;
import net.sf.acegisecurity.DisabledException;
import net.sf.acegisecurity.GrantedAuthority;
import net.sf.acegisecurity.UserDetails;
import net.sf.acegisecurity.providers.AuthenticationProvider;
import net.sf.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import net.sf.acegisecurity.providers.dao.PasswordAuthenticationDao;
import net.sf.acegisecurity.providers.dao.User;
import net.sf.acegisecurity.providers.dao.UserCache;
import net.sf.acegisecurity.providers.dao.cache.NullUserCache;
import net.sf.acegisecurity.providers.dao.event.AuthenticationFailureAccountExpiredEvent;
import net.sf.acegisecurity.providers.dao.event.AuthenticationFailureCredentialsExpiredEvent;
import net.sf.acegisecurity.providers.dao.event.AuthenticationFailureDisabledEvent;
import net.sf.acegisecurity.providers.dao.event.AuthenticationFailureUsernameOrPasswordEvent;
import net.sf.acegisecurity.providers.dao.event.AuthenticationSuccessEvent;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.dao.DataAccessException;

public class PasswordDaoAuthenticationProvider
implements AuthenticationProvider,
InitializingBean,
ApplicationContextAware {
    private ApplicationContext context;
    private PasswordAuthenticationDao authenticationDao;
    private UserCache userCache = new NullUserCache();
    private boolean forcePrincipalAsString = false;
    static /* synthetic */ Class class$net$sf$acegisecurity$providers$UsernamePasswordAuthenticationToken;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }

    public ApplicationContext getContext() {
        return this.context;
    }

    public void setForcePrincipalAsString(boolean forcePrincipalAsString) {
        this.forcePrincipalAsString = forcePrincipalAsString;
    }

    public boolean isForcePrincipalAsString() {
        return this.forcePrincipalAsString;
    }

    public void setPasswordAuthenticationDao(PasswordAuthenticationDao authenticationDao) {
        this.authenticationDao = authenticationDao;
    }

    public PasswordAuthenticationDao getPasswordAuthenticationDao() {
        return this.authenticationDao;
    }

    public void setUserCache(UserCache userCache) {
        this.userCache = userCache;
    }

    public UserCache getUserCache() {
        return this.userCache;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.authenticationDao == null) {
            throw new IllegalArgumentException("A Password authentication DAO must be set");
        }
        if (this.userCache == null) {
            throw new IllegalArgumentException("A user cache must be set");
        }
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        String username = authentication.getPrincipal().toString();
        if (authentication.getPrincipal() instanceof UserDetails) {
            username = ((UserDetails)authentication.getPrincipal()).getUsername();
        }
        String password = authentication.getCredentials().toString();
        boolean cacheWasUsed = true;
        UserDetails user = this.userCache.getUserFromCache(username);
        if (user != null && !password.equals(user.getPassword())) {
            user = null;
            this.userCache.removeUserFromCache(username);
        }
        if (user == null) {
            cacheWasUsed = false;
            try {
                user = this.getUserFromBackend(username, password);
            }
            catch (BadCredentialsException ex) {
                if (this.context != null) {
                    if (username == null || "".equals(username)) {
                        username = "NONE_PROVIDED";
                    }
                    this.context.publishEvent((ApplicationEvent)new AuthenticationFailureUsernameOrPasswordEvent(authentication, new User(username, "*****", false, false, false, new GrantedAuthority[0])));
                }
                throw ex;
            }
        }
        if (!user.isEnabled()) {
            if (this.context != null) {
                this.context.publishEvent((ApplicationEvent)new AuthenticationFailureDisabledEvent(authentication, user));
            }
            throw new DisabledException("User is disabled");
        }
        if (!user.isAccountNonExpired()) {
            if (this.context != null) {
                this.context.publishEvent((ApplicationEvent)new AuthenticationFailureAccountExpiredEvent(authentication, user));
            }
            throw new AccountExpiredException("User account has expired");
        }
        if (!user.isCredentialsNonExpired()) {
            if (this.context != null) {
                this.context.publishEvent((ApplicationEvent)new AuthenticationFailureCredentialsExpiredEvent(authentication, user));
            }
            throw new CredentialsExpiredException("User credentials have expired");
        }
        if (!cacheWasUsed) {
            this.userCache.putUserInCache(user);
            if (this.context != null) {
                this.context.publishEvent((ApplicationEvent)new AuthenticationSuccessEvent(authentication, user));
            }
        }
        Object principalToReturn = user;
        if (this.forcePrincipalAsString) {
            principalToReturn = user.getUsername();
        }
        return this.createSuccessAuthentication(principalToReturn, authentication, user);
    }

    public boolean supports(Class authentication) {
        return (class$net$sf$acegisecurity$providers$UsernamePasswordAuthenticationToken == null ? (class$net$sf$acegisecurity$providers$UsernamePasswordAuthenticationToken = PasswordDaoAuthenticationProvider.class$("net.sf.acegisecurity.providers.UsernamePasswordAuthenticationToken")) : class$net$sf$acegisecurity$providers$UsernamePasswordAuthenticationToken).isAssignableFrom(authentication);
    }

    protected Authentication createSuccessAuthentication(Object principal, Authentication authentication, UserDetails user) {
        UsernamePasswordAuthenticationToken result = new UsernamePasswordAuthenticationToken(principal, authentication.getCredentials(), user.getAuthorities());
        result.setDetails(authentication.getDetails() != null ? authentication.getDetails().toString() : null);
        return result;
    }

    private UserDetails getUserFromBackend(String username, String password) {
        try {
            return this.authenticationDao.loadUserByUsernameAndPassword(username, password);
        }
        catch (DataAccessException repositoryProblem) {
            throw new AuthenticationServiceException(repositoryProblem.getMessage(), repositoryProblem);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

