/*
 * Decompiled with CFR 0.152.
 */
package net.sf.acegisecurity.providers.jaas;

import java.io.IOException;
import java.security.Principal;
import java.security.Security;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import net.sf.acegisecurity.AcegiSecurityException;
import net.sf.acegisecurity.Authentication;
import net.sf.acegisecurity.AuthenticationException;
import net.sf.acegisecurity.GrantedAuthority;
import net.sf.acegisecurity.providers.AuthenticationProvider;
import net.sf.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import net.sf.acegisecurity.providers.jaas.AuthorityGranter;
import net.sf.acegisecurity.providers.jaas.DefaultLoginExceptionResolver;
import net.sf.acegisecurity.providers.jaas.JaasAuthenticationCallbackHandler;
import net.sf.acegisecurity.providers.jaas.JaasGrantedAuthority;
import net.sf.acegisecurity.providers.jaas.LoginExceptionResolver;
import net.sf.acegisecurity.providers.jaas.event.JaasAuthenticationFailedEvent;
import net.sf.acegisecurity.providers.jaas.event.JaasAuthenticationSuccessEvent;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationContextException;
import org.springframework.context.ApplicationEvent;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class JaasAuthenticationProvider
implements AuthenticationProvider,
InitializingBean,
ApplicationContextAware {
    private ApplicationContext context;
    private LoginExceptionResolver loginExceptionResolver = new DefaultLoginExceptionResolver();
    private Resource loginConfig;
    private final String SYSPROP = "java.security.auth.login.config";
    private String loginContextName = "ACEGI";
    private AuthorityGranter[] authorityGranters;
    private JaasAuthenticationCallbackHandler[] callbackHandlers;
    static /* synthetic */ Class class$net$sf$acegisecurity$providers$UsernamePasswordAuthenticationToken;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }

    public void setAuthorityGranters(AuthorityGranter[] authorityGranters) {
        this.authorityGranters = authorityGranters;
    }

    public AuthorityGranter[] getAuthorityGranters() {
        return this.authorityGranters;
    }

    public void setCallbackHandlers(JaasAuthenticationCallbackHandler[] callbackHandlers) {
        this.callbackHandlers = callbackHandlers;
    }

    public JaasAuthenticationCallbackHandler[] getCallbackHandlers() {
        return this.callbackHandlers;
    }

    public void setLoginConfig(Resource loginConfig) {
        this.loginConfig = loginConfig;
    }

    public Resource getLoginConfig() {
        return this.loginConfig;
    }

    public void setLoginContextName(String loginContextName) {
        this.loginContextName = loginContextName;
    }

    public String getLoginContextName() {
        return this.loginContextName;
    }

    public void setLoginExceptionResolver(LoginExceptionResolver loginExceptionResolver) {
        this.loginExceptionResolver = loginExceptionResolver;
    }

    public LoginExceptionResolver getLoginExceptionResolver() {
        return this.loginExceptionResolver;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.loginConfig == null) {
            throw new ApplicationContextException("loginConfig must be set on " + this.getClass());
        }
        if (this.loginContextName == null || "".equals(this.loginContextName)) {
            throw new ApplicationContextException("loginContextName must be set on " + this.getClass());
        }
        String loginConfigStr = this.loginConfig.getURL().toString();
        boolean allowed = "true".equalsIgnoreCase(Security.getProperty("policy.allowSystemProperty"));
        if (allowed) {
            System.setProperty("java.security.auth.login.config", loginConfigStr);
        } else {
            this.setPropertyUsingLoop(loginConfigStr);
        }
        Assert.notNull((Object)Configuration.getConfiguration(), (String)"As per http://java.sun.com/j2se/1.5.0/docs/api/javax/security/auth/login/Configuration.html \"If a Configuration object was set via the Configuration.setConfiguration method, then that object is returned. Otherwise, a default Configuration object is returned\". Your JRE returned null to Configuration.getConfiguration().");
    }

    public Authentication authenticate(Authentication auth) throws AuthenticationException {
        if (auth instanceof UsernamePasswordAuthenticationToken) {
            UsernamePasswordAuthenticationToken token = (UsernamePasswordAuthenticationToken)auth;
            try {
                LoginContext lc = new LoginContext(this.loginContextName, new InternalCallbackHandler(auth));
                lc.login();
                HashSet<GrantedAuthority> authorities = new HashSet<GrantedAuthority>();
                if (token.getAuthorities() != null) {
                    authorities.addAll(Arrays.asList(token.getAuthorities()));
                }
                Set<Principal> principals = lc.getSubject().getPrincipals();
                Iterator<Principal> iterator = principals.iterator();
                while (iterator.hasNext()) {
                    Principal principal = iterator.next();
                    for (int i = 0; i < this.authorityGranters.length; ++i) {
                        AuthorityGranter granter = this.authorityGranters[i];
                        String role = granter.grant(principal);
                        if (role == null) continue;
                        authorities.add(new JaasGrantedAuthority(role, principal));
                    }
                }
                token.setAuthorities(authorities.toArray(new GrantedAuthority[authorities.size()]));
                this.context.publishEvent((ApplicationEvent)new JaasAuthenticationSuccessEvent(token));
                return token;
            }
            catch (LoginException loginException) {
                AcegiSecurityException ase = this.loginExceptionResolver.resolveException(loginException);
                this.context.publishEvent((ApplicationEvent)new JaasAuthenticationFailedEvent(auth, (Exception)((Object)ase)));
                throw ase;
            }
        }
        return null;
    }

    public boolean supports(Class aClass) {
        return (class$net$sf$acegisecurity$providers$UsernamePasswordAuthenticationToken == null ? (class$net$sf$acegisecurity$providers$UsernamePasswordAuthenticationToken = JaasAuthenticationProvider.class$("net.sf.acegisecurity.providers.UsernamePasswordAuthenticationToken")) : class$net$sf$acegisecurity$providers$UsernamePasswordAuthenticationToken).isAssignableFrom(aClass);
    }

    private void setPropertyUsingLoop(String loginConfigStr) {
        boolean alreadySet = false;
        int n = 1;
        String prefix = "login.config.url.";
        String existing = null;
        while ((existing = Security.getProperty(prefix + n)) != null && !(alreadySet = existing.equals(loginConfigStr))) {
            ++n;
        }
        if (!alreadySet) {
            Security.setProperty(prefix + n, loginConfigStr);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class InternalCallbackHandler
    implements CallbackHandler {
        private Authentication authentication;

        public InternalCallbackHandler(Authentication authentication) {
            this.authentication = authentication;
        }

        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (int i = 0; i < JaasAuthenticationProvider.this.callbackHandlers.length; ++i) {
                JaasAuthenticationCallbackHandler handler = JaasAuthenticationProvider.this.callbackHandlers[i];
                for (int j = 0; j < callbacks.length; ++j) {
                    Callback callback = callbacks[j];
                    handler.handle(callback, this.authentication);
                }
            }
        }
    }
}

