/*
 * Decompiled with CFR 0.152.
 */
package net.sf.acegisecurity.providers.cas.cache;

import java.io.Serializable;
import net.sf.acegisecurity.providers.cas.CasAuthenticationToken;
import net.sf.acegisecurity.providers.cas.StatelessTicketCache;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Element;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataRetrievalFailureException;

public class EhCacheBasedTicketCache
implements StatelessTicketCache,
InitializingBean {
    private static final Log logger = LogFactory.getLog((Class)(class$net$sf$acegisecurity$providers$cas$cache$EhCacheBasedTicketCache == null ? (class$net$sf$acegisecurity$providers$cas$cache$EhCacheBasedTicketCache = EhCacheBasedTicketCache.class$("net.sf.acegisecurity.providers.cas.cache.EhCacheBasedTicketCache")) : class$net$sf$acegisecurity$providers$cas$cache$EhCacheBasedTicketCache));
    private Cache cache;
    static /* synthetic */ Class class$net$sf$acegisecurity$providers$cas$cache$EhCacheBasedTicketCache;

    public CasAuthenticationToken getByTicketId(String serviceTicket) {
        Element element = null;
        try {
            element = this.cache.get((Serializable)((Object)serviceTicket));
        }
        catch (CacheException cacheException) {
            throw new DataRetrievalFailureException("Cache failure: " + cacheException.getMessage());
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Cache hit: " + (element != null) + "; service ticket: " + serviceTicket));
        }
        if (element == null) {
            return null;
        }
        return (CasAuthenticationToken)element.getValue();
    }

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public Cache getCache() {
        return this.cache;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.cache == null) {
            throw new IllegalArgumentException("cache mandatory");
        }
    }

    public void putTicketInCache(CasAuthenticationToken token) {
        Element element = new Element((Serializable)((Object)token.getCredentials().toString()), (Serializable)token);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Cache put: " + element.getKey()));
        }
        this.cache.put(element);
    }

    public void removeTicketFromCache(CasAuthenticationToken token) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Cache remove: " + token.getCredentials().toString()));
        }
        this.removeTicketFromCache(token.getCredentials().toString());
    }

    public void removeTicketFromCache(String serviceTicket) {
        this.cache.remove((Serializable)((Object)serviceTicket));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

