/*
 * Decompiled with CFR 0.152.
 */
package net.sf.acegisecurity.providers.x509.cache;

import java.io.Serializable;
import java.security.cert.X509Certificate;
import net.sf.acegisecurity.UserDetails;
import net.sf.acegisecurity.providers.x509.X509UserCache;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Element;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.util.Assert;

public class EhCacheBasedX509UserCache
implements X509UserCache,
InitializingBean {
    private static final Log logger = LogFactory.getLog((Class)(class$net$sf$acegisecurity$providers$x509$cache$EhCacheBasedX509UserCache == null ? (class$net$sf$acegisecurity$providers$x509$cache$EhCacheBasedX509UserCache = EhCacheBasedX509UserCache.class$("net.sf.acegisecurity.providers.x509.cache.EhCacheBasedX509UserCache")) : class$net$sf$acegisecurity$providers$x509$cache$EhCacheBasedX509UserCache));
    private Cache cache;
    static /* synthetic */ Class class$net$sf$acegisecurity$providers$x509$cache$EhCacheBasedX509UserCache;

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public UserDetails getUserFromCache(X509Certificate userCert) {
        Element element = null;
        try {
            element = this.cache.get((Serializable)userCert);
        }
        catch (CacheException cacheException) {
            throw new DataRetrievalFailureException("Cache failure: " + cacheException.getMessage());
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("X.509 Cache hit. SubjectDN: " + userCert.getSubjectDN()));
        }
        if (element == null) {
            return null;
        }
        return (UserDetails)element.getValue();
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.cache, (String)"cache is mandatory");
    }

    public void putUserInCache(X509Certificate userCert, UserDetails user) {
        Element element = new Element((Serializable)userCert, (Serializable)user);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Cache put: " + userCert.getSubjectDN()));
        }
        this.cache.put(element);
    }

    public void removeUserFromCache(X509Certificate userCert) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Cache remove: " + userCert.getSubjectDN()));
        }
        this.removeUserFromCache(userCert);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

