/*
 * Decompiled with CFR 0.152.
 */
package net.sf.acegisecurity.taglibs.authz;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TagSupport;
import net.sf.acegisecurity.Authentication;
import net.sf.acegisecurity.GrantedAuthority;
import net.sf.acegisecurity.GrantedAuthorityImpl;
import net.sf.acegisecurity.context.ContextHolder;
import net.sf.acegisecurity.context.security.SecureContext;
import org.springframework.util.StringUtils;
import org.springframework.web.util.ExpressionEvaluationUtils;

public class AuthorizeTag
extends TagSupport {
    private String ifAllGranted = "";
    private String ifAnyGranted = "";
    private String ifNotGranted = "";

    public void setIfAllGranted(String ifAllGranted) throws JspException {
        this.ifAllGranted = ifAllGranted;
    }

    public String getIfAllGranted() {
        return this.ifAllGranted;
    }

    public void setIfAnyGranted(String ifAnyGranted) throws JspException {
        this.ifAnyGranted = ifAnyGranted;
    }

    public String getIfAnyGranted() {
        return this.ifAnyGranted;
    }

    public void setIfNotGranted(String ifNotGranted) throws JspException {
        this.ifNotGranted = ifNotGranted;
    }

    public String getIfNotGranted() {
        return this.ifNotGranted;
    }

    public int doStartTag() throws JspException {
        Set grantedCopy;
        Set grantedCopy2;
        if (!(null != this.ifAllGranted && !"".equals(this.ifAllGranted) || null != this.ifAnyGranted && !"".equals(this.ifAnyGranted) || null != this.ifNotGranted && !"".equals(this.ifNotGranted))) {
            return 0;
        }
        Collection granted = this.getPrincipalAuthorities();
        String evaledIfNotGranted = ExpressionEvaluationUtils.evaluateString((String)"ifNotGranted", (String)this.ifNotGranted, (PageContext)this.pageContext);
        if (null != evaledIfNotGranted && !"".equals(evaledIfNotGranted) && !(grantedCopy2 = this.retainAll(granted, this.parseAuthoritiesString(evaledIfNotGranted))).isEmpty()) {
            return 0;
        }
        String evaledIfAllGranted = ExpressionEvaluationUtils.evaluateString((String)"ifAllGranted", (String)this.ifAllGranted, (PageContext)this.pageContext);
        if (null != evaledIfAllGranted && !"".equals(evaledIfAllGranted) && !granted.containsAll(this.parseAuthoritiesString(evaledIfAllGranted))) {
            return 0;
        }
        String evaledIfAnyGranted = ExpressionEvaluationUtils.evaluateString((String)"ifAnyGranted", (String)this.ifAnyGranted, (PageContext)this.pageContext);
        if (null != evaledIfAnyGranted && !"".equals(evaledIfAnyGranted) && (grantedCopy = this.retainAll(granted, this.parseAuthoritiesString(evaledIfAnyGranted))).isEmpty()) {
            return 0;
        }
        return 1;
    }

    private Collection getPrincipalAuthorities() {
        SecureContext context = (SecureContext)ContextHolder.getContext();
        if (null == context) {
            return Collections.EMPTY_LIST;
        }
        Authentication currentUser = context.getAuthentication();
        if (null == currentUser) {
            return Collections.EMPTY_LIST;
        }
        List<GrantedAuthority> granted = Arrays.asList(currentUser.getAuthorities());
        return granted;
    }

    private Set authoritiesToRoles(Collection c) {
        HashSet<String> target = new HashSet<String>();
        Iterator iterator = c.iterator();
        while (iterator.hasNext()) {
            GrantedAuthority authority = (GrantedAuthority)iterator.next();
            if (null == authority.getAuthority()) {
                throw new IllegalArgumentException("Cannot process GrantedAuthority objects which return null from getAuthority() - attempting to process " + authority.toString());
            }
            target.add(authority.getAuthority());
        }
        return target;
    }

    private Set parseAuthoritiesString(String authorizationsString) {
        HashSet<GrantedAuthorityImpl> requiredAuthorities = new HashSet<GrantedAuthorityImpl>();
        String[] authorities = StringUtils.commaDelimitedListToStringArray((String)authorizationsString);
        for (int i = 0; i < authorities.length; ++i) {
            String authority = authorities[i];
            String role = authority.replaceAll("\\s+", "");
            requiredAuthorities.add(new GrantedAuthorityImpl(role));
        }
        return requiredAuthorities;
    }

    private Set retainAll(Collection granted, Set required) {
        Set grantedRoles = this.authoritiesToRoles(granted);
        Set requiredRoles = this.authoritiesToRoles(required);
        grantedRoles.retainAll(requiredRoles);
        return this.rolesToAuthorities(grantedRoles, granted);
    }

    private Set rolesToAuthorities(Set grantedRoles, Collection granted) {
        HashSet<GrantedAuthority> target = new HashSet<GrantedAuthority>();
        Iterator iterator = grantedRoles.iterator();
        block0: while (iterator.hasNext()) {
            String role = (String)iterator.next();
            Iterator grantedIterator = granted.iterator();
            while (grantedIterator.hasNext()) {
                GrantedAuthority authority = (GrantedAuthority)grantedIterator.next();
                if (!authority.getAuthority().equals(role)) continue;
                target.add(authority);
                continue block0;
            }
        }
        return target;
    }
}

