/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.bean;

import java.io.Serializable;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;

public class JmsHelper {
    private Session session;
    private MessageProducer producer;
    private long defaultTimeout = 5000L;

    public JmsHelper() {
    }

    public JmsHelper(Session session, MessageProducer producer) {
        this.session = session;
        this.producer = producer;
    }

    public void send(Destination destination, Message message) throws JMSException {
        this.producer.send(destination, message);
    }

    public void send(Message message) throws JMSException {
        this.producer.send(message);
    }

    public void send(String subject, Message message, boolean isTopic) throws JMSException {
        Object destination = null;
        destination = isTopic ? this.session.createTopic(subject) : this.session.createQueue(subject);
        this.send((Destination)destination, message);
    }

    public Message call(Destination destination, Message request, long timeout) throws JMSException {
        Object tempDest = null;
        tempDest = destination instanceof Topic ? this.session.createTemporaryTopic() : this.session.createTemporaryQueue();
        MessageConsumer consumer = this.session.createConsumer((Destination)tempDest);
        Message answer = consumer.receive(timeout);
        consumer.close();
        return answer;
    }

    public Message call(Destination destination, Message request) throws JMSException {
        return this.call(destination, request, this.defaultTimeout);
    }

    public TextMessage createTextMessage(String text) throws JMSException {
        return this.session.createTextMessage(text);
    }

    public ObjectMessage createObjectMessage(Serializable object) throws JMSException {
        return this.session.createObjectMessage(object);
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public MessageProducer getProducer() {
        return this.producer;
    }

    public void setProducer(MessageProducer producer) {
        this.producer = producer;
    }

    public long getDefaultTimeout() {
        return this.defaultTimeout;
    }

    public void setDefaultTimeout(long defaultTimeout) {
        this.defaultTimeout = defaultTimeout;
    }
}

