/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.bean;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.TextMessage;

public class BridgeBean
implements MessageListener {
    private Session session;
    private MessageProducer producer;
    private Destination destination;

    public BridgeBean(Session session, MessageProducer producer, Destination destination) {
        this.session = session;
        this.producer = producer;
        this.destination = destination;
    }

    public void onMessage(Message inputMessage) {
        try {
            Message outputMessage = this.createOutputMessage(inputMessage);
            this.enrich(outputMessage, inputMessage);
            this.producer.send(this.destination, outputMessage);
        }
        catch (JMSException e) {
            this.onJMSException(e);
        }
    }

    protected void enrich(Message outputMessage, Message inputMessage) {
    }

    protected Message createOutputMessage(Message message) throws JMSException {
        if (message instanceof ObjectMessage) {
            ObjectMessage objMsg = (ObjectMessage)message;
            return this.session.createObjectMessage(objMsg.getObject());
        }
        if (message instanceof TextMessage) {
            TextMessage txtMsg = (TextMessage)message;
            return this.session.createTextMessage(txtMsg.getText());
        }
        return this.session.createMessage();
    }

    protected void onJMSException(JMSException e) {
        throw new RuntimeException(e);
    }
}

