/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.bean;

import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.codehaus.activemq.util.MessageListenerSupport;
import org.w3c.dom.Node;

public class TransformerBean
extends MessageListenerSupport {
    private Session session;
    private MessageProducer producer;
    private Transformer transformer;

    public Transformer getTransformer() {
        return this.transformer;
    }

    public void setTransformer(Transformer transformer) {
        this.transformer = transformer;
    }

    public MessageProducer getProducer() {
        return this.producer;
    }

    public void setProducer(MessageProducer producer) {
        this.producer = producer;
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    protected void processMessage(Message inputMessage) throws Exception {
        Source source = this.createSource(inputMessage);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        this.transformer.transform(source, result);
        String output = writer.toString();
        Message outputMessage = this.createMessage(output);
        this.configureMessage(inputMessage, outputMessage);
        this.send(outputMessage);
    }

    protected void send(Message message) throws JMSException {
        this.producer.send(message);
    }

    protected void configureMessage(Message inputMessage, Message outputMessage) throws JMSException {
        outputMessage.setJMSCorrelationID(inputMessage.getJMSCorrelationID());
    }

    protected Message createMessage(String output) throws JMSException {
        return this.getSession().createTextMessage(output);
    }

    protected Source createSource(Message message) throws JMSException {
        if (message instanceof TextMessage) {
            TextMessage textMessage = (TextMessage)message;
            String text = textMessage.getText();
            return this.createSource(text);
        }
        if (message instanceof ObjectMessage) {
            ObjectMessage objectMessage = (ObjectMessage)message;
            Serializable value = objectMessage.getObject();
            if (value instanceof String) {
                this.createSource((String)((Object)value));
            } else {
                if (value instanceof Node) {
                    return new DOMSource((Node)((Object)value));
                }
                if (value != null) {
                    this.createSource((String)((Object)value));
                }
            }
        }
        throw new JMSException("Cannot convert message body to a String or a DOM Node");
    }

    protected StreamSource createSource(String text) {
        return new StreamSource(new StringReader(text));
    }
}

