/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.jca;

import java.lang.reflect.Method;
import javax.jms.MessageListener;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.UnavailableException;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.codehaus.activemq.jca.AcknowledgeEndpoint;
import org.codehaus.activemq.jca.LocalTransactionEndpoint;
import org.codehaus.activemq.jca.XAEndpoint;
import org.springframework.beans.factory.InitializingBean;

public class DefaultEndpointFactory
implements MessageEndpointFactory,
InitializingBean {
    private MessageListener messageListener;
    private TransactionManager transactionManager;

    public DefaultEndpointFactory() {
    }

    public DefaultEndpointFactory(MessageListener messageListener) {
        this.messageListener = messageListener;
    }

    public DefaultEndpointFactory(MessageListener messageListener, TransactionManager transactionManager) {
        this.messageListener = messageListener;
        this.transactionManager = transactionManager;
    }

    public MessageEndpoint createEndpoint(XAResource xaResource) throws UnavailableException {
        if (this.transactionManager != null) {
            return new XAEndpoint(this.messageListener, xaResource, this.transactionManager);
        }
        if (xaResource instanceof LocalTransaction) {
            return new LocalTransactionEndpoint(this.messageListener, (LocalTransaction)xaResource);
        }
        return new AcknowledgeEndpoint(this.messageListener);
    }

    public boolean isDeliveryTransacted(Method method) throws NoSuchMethodException {
        return this.transactionManager != null;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.messageListener == null) {
            throw new IllegalArgumentException("messageListener property must be set");
        }
    }

    public MessageListener getMessageListener() {
        return this.messageListener;
    }

    public void setMessageListener(MessageListener messageListener) {
        this.messageListener = messageListener;
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }
}

