/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.jca.impl;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.ClassPathResource;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class JCADtdResolver
implements EntityResolver {
    private static final String DTD_NAME = "mdo.dtd";
    private static final String SEARCH_PACKAGE = "/org/codehaus/activemq/mdo/";
    protected final Log logger = LogFactory.getLog(this.getClass());

    public InputSource resolveEntity(String publicId, String systemId) throws IOException {
        this.logger.debug((Object)("Trying to resolve XML entity with public ID [" + publicId + "] and system ID [" + systemId + "]"));
        if (systemId != null && systemId.indexOf(DTD_NAME) > systemId.lastIndexOf("/")) {
            String dtdFile = systemId.substring(systemId.indexOf(DTD_NAME));
            this.logger.debug((Object)("Trying to locate [" + dtdFile + "] under [" + SEARCH_PACKAGE + "]"));
            try {
                String name = SEARCH_PACKAGE + dtdFile;
                ClassPathResource resource = new ClassPathResource(name, this.getClass());
                InputSource source = new InputSource(resource.getInputStream());
                source.setPublicId(publicId);
                source.setSystemId(systemId);
                this.logger.debug((Object)("Found beans DTD [" + systemId + "] in classpath"));
                return source;
            }
            catch (IOException ex) {
                this.logger.debug((Object)("Could not resolve beans DTD [" + systemId + "]: not found in classpath"), (Throwable)ex);
            }
        }
        return null;
    }
}

