/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.message;

import org.codehaus.activemq.message.AbstractPacket;
import org.codehaus.activemq.message.ActiveMQDestination;
import org.codehaus.activemq.service.MessageIdentity;

public class MessageAck
extends AbstractPacket {
    public static final int MESSAGE_READ_INDEX = 0;
    public static final int XA_TRANSACTED_INDEX = 1;
    public static final int PERSISTENT_INDEX = 2;
    private String consumerId;
    private String messageID;
    private ActiveMQDestination destination;
    private String transactionId;
    private boolean messageRead;
    private boolean xaTransacted;
    private boolean persistent;
    private transient MessageIdentity messageIdentity;

    public int getPacketType() {
        return 15;
    }

    public String toString() {
        String str = super.toString();
        str = str + " consumerId = " + this.consumerId;
        str = str + " , messageId = " + this.messageID;
        str = str + " ,read = " + this.messageRead;
        str = str + " ,trans = " + this.transactionId;
        return str;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String newTransactionId) {
        this.transactionId = newTransactionId;
    }

    public boolean isPartOfTransaction() {
        return this.transactionId != null && this.transactionId.length() > 0;
    }

    public String getMessageID() {
        return this.messageID;
    }

    public void setMessageID(String messageID) {
        this.messageID = messageID;
    }

    public boolean isMessageRead() {
        return this.messageRead;
    }

    public void setMessageRead(boolean messageRead) {
        this.messageRead = messageRead;
    }

    public String getConsumerId() {
        return this.consumerId;
    }

    public void setConsumerId(String consumerId) {
        this.consumerId = consumerId;
    }

    public boolean isXaTransacted() {
        return this.xaTransacted;
    }

    public void setXaTransacted(boolean xaTransacted) {
        this.xaTransacted = xaTransacted;
    }

    public MessageIdentity getMessageIdentity() {
        if (this.messageIdentity == null) {
            this.messageIdentity = new MessageIdentity(this.messageID);
        }
        return this.messageIdentity;
    }

    public ActiveMQDestination getDestination() {
        return this.destination;
    }

    public void setDestination(ActiveMQDestination destination) {
        this.destination = destination;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    public boolean isTemporary() {
        return !this.persistent || this.destination != null && this.destination.isTemporary();
    }
}

