/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.service.impl;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.jms.Destination;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import org.codehaus.activemq.DuplicateDurableSubscriptionException;
import org.codehaus.activemq.broker.BrokerClient;
import org.codehaus.activemq.filter.AndFilter;
import org.codehaus.activemq.filter.DestinationMap;
import org.codehaus.activemq.filter.Filter;
import org.codehaus.activemq.filter.FilterFactory;
import org.codehaus.activemq.filter.FilterFactoryImpl;
import org.codehaus.activemq.filter.NoLocalFilter;
import org.codehaus.activemq.message.ActiveMQDestination;
import org.codehaus.activemq.message.ActiveMQMessage;
import org.codehaus.activemq.message.ActiveMQTopic;
import org.codehaus.activemq.message.ConsumerInfo;
import org.codehaus.activemq.message.MessageAck;
import org.codehaus.activemq.service.Dispatcher;
import org.codehaus.activemq.service.MessageContainer;
import org.codehaus.activemq.service.RedeliveryPolicy;
import org.codehaus.activemq.service.Subscription;
import org.codehaus.activemq.service.SubscriptionContainer;
import org.codehaus.activemq.service.TopicMessageContainer;
import org.codehaus.activemq.service.impl.DispatcherImpl;
import org.codehaus.activemq.service.impl.DurableTopicMessageContainer;
import org.codehaus.activemq.service.impl.DurableTopicSubscriptionContainerImpl;
import org.codehaus.activemq.service.impl.MessageContainerManagerSupport;
import org.codehaus.activemq.store.PersistenceAdapter;

public class DurableTopicMessageContainerManager
extends MessageContainerManagerSupport {
    private PersistenceAdapter persistenceAdapter;
    protected SubscriptionContainer subscriptionContainer;
    protected FilterFactory filterFactory;
    protected Map activeSubscriptions = new ConcurrentHashMap();
    private DestinationMap destinationMap = new DestinationMap();
    private boolean loadedMessageContainers;

    public DurableTopicMessageContainerManager(PersistenceAdapter persistenceAdapter, RedeliveryPolicy redeliveryPolicy) {
        this(persistenceAdapter, new DurableTopicSubscriptionContainerImpl(redeliveryPolicy), new FilterFactoryImpl(), new DispatcherImpl());
    }

    public DurableTopicMessageContainerManager(PersistenceAdapter persistenceAdapter, SubscriptionContainer subscriptionContainer, FilterFactory filterFactory, Dispatcher dispatcher) {
        super(dispatcher);
        this.persistenceAdapter = persistenceAdapter;
        this.subscriptionContainer = subscriptionContainer;
        this.filterFactory = filterFactory;
    }

    public void addMessageConsumer(BrokerClient client, ConsumerInfo info) throws JMSException {
        if (info.isDurableTopic()) {
            this.doAddMessageConsumer(client, info);
        }
    }

    public void removeMessageConsumer(BrokerClient client, ConsumerInfo info) throws JMSException {
        Subscription sub = (Subscription)this.activeSubscriptions.remove(info.getConsumerId());
        if (sub != null) {
            sub.setActive(false);
            this.dispatcher.removeActiveSubscription(client, sub);
        }
    }

    public void deleteSubscription(String clientId, String subscriberName) throws JMSException {
        boolean subscriptionFound = false;
        Iterator i = this.subscriptionContainer.subscriptionIterator();
        while (i.hasNext()) {
            Subscription sub = (Subscription)i.next();
            if (!sub.getClientId().equals(clientId) || !sub.getSubscriberName().equals(subscriberName)) continue;
            if (sub.isActive()) {
                throw new JMSException("The Consummer " + subscriberName + " is still active");
            }
            this.subscriptionContainer.removeSubscription(sub.getConsumerId());
            sub.clear();
            subscriptionFound = true;
        }
        if (!subscriptionFound) {
            throw new InvalidDestinationException("The Consumer " + subscriberName + " does not exist for client: " + clientId);
        }
    }

    public void sendMessage(BrokerClient client, ActiveMQMessage message) throws JMSException {
        ActiveMQDestination dest = (ActiveMQDestination)message.getJMSDestination();
        if (dest != null && dest.isTopic() && message.getJMSDeliveryMode() == 2) {
            MessageContainer container = this.getContainer(message.getJMSDestination().toString());
            Set matchingSubscriptions = this.subscriptionContainer.getSubscriptions(message.getJMSActiveMQDestination());
            container.addMessage(message);
            if (!matchingSubscriptions.isEmpty()) {
                Iterator i = matchingSubscriptions.iterator();
                while (i.hasNext()) {
                    Subscription sub = (Subscription)i.next();
                    if (!sub.isTarget(message)) continue;
                    sub.addMessage(container, message);
                }
                this.updateSendStats(client, message);
            }
        }
    }

    public void acknowledgeMessage(BrokerClient client, MessageAck ack) throws JMSException {
        Subscription sub;
        if (ack.getDestination().isTopic() && (sub = (Subscription)this.activeSubscriptions.get(ack.getConsumerId())) != null) {
            sub.messageConsumed(ack);
        }
    }

    public void acknowledgeTransactedMessage(BrokerClient client, String transactionId, MessageAck ack) throws JMSException {
        Subscription sub = (Subscription)this.activeSubscriptions.get(ack.getConsumerId());
        if (sub != null) {
            sub.onAcknowledgeTransactedMessageBeforeCommit(ack);
        }
    }

    public void redeliverMessage(BrokerClient client, MessageAck ack) throws JMSException {
        Subscription sub = (Subscription)this.activeSubscriptions.get(ack.getConsumerId());
        if (sub != null) {
            Iterator iter = this.messageContainers.values().iterator();
            while (iter.hasNext()) {
                MessageContainer container = (MessageContainer)iter.next();
                if (!container.containsMessage(ack.getMessageIdentity())) continue;
                sub.redeliverMessage(container, ack);
                break;
            }
        }
    }

    public void poll() throws JMSException {
    }

    public void commitTransaction(BrokerClient client, String transactionId) {
    }

    public void rollbackTransaction(BrokerClient client, String transactionId) {
    }

    protected MessageContainer createContainer(String destinationName) throws JMSException {
        TopicMessageContainer topicMessageContainer = this.persistenceAdapter.createTopicMessageContainer(destinationName);
        this.destinationMap.put(new ActiveMQTopic(destinationName), topicMessageContainer);
        return topicMessageContainer;
    }

    protected Destination createDestination(String destinationName) {
        return new ActiveMQTopic(destinationName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doAddMessageConsumer(BrokerClient client, ConsumerInfo info) throws JMSException {
        Subscription subscription;
        Object subscription2;
        boolean shouldRecover = false;
        if (info.getConsumerName() != null && info.getClientId() != null) {
            Iterator iter = this.activeSubscriptions.values().iterator();
            while (iter.hasNext()) {
                subscription2 = (Subscription)iter.next();
                if (!subscription2.isSameDurableSubscription(info)) continue;
                throw new DuplicateDurableSubscriptionException(info);
            }
        }
        if ((subscription = this.subscriptionContainer.getSubscription(info.getConsumerId())) != null && subscription.isDurableTopic()) {
            if (!subscription.getDestination().equals(subscription.getDestination()) || !subscription.getSelector().equals(info.getSelector())) {
                this.subscriptionContainer.removeSubscription(info.getConsumerId());
                subscription.clear();
                subscription = this.subscriptionContainer.makeSubscription(this.dispatcher, client, info, this.createFilter(info));
            }
        } else {
            subscription = this.subscriptionContainer.makeSubscription(this.dispatcher, client, info, this.createFilter(info));
            shouldRecover = true;
        }
        subscription.setActiveConsumer(client, info);
        this.activeSubscriptions.put(info.getConsumerId(), subscription);
        this.dispatcher.addActiveSubscription(client, subscription);
        if (subscription.isWildcard()) {
            subscription2 = this;
            synchronized (subscription2) {
                if (!this.loadedMessageContainers) {
                    this.loadAllMessageContainers();
                    this.loadedMessageContainers = true;
                }
            }
        } else {
            this.getContainer(subscription.getDestination().getPhysicalName());
        }
        Set containers = this.destinationMap.get(subscription.getDestination());
        Iterator iter = containers.iterator();
        while (iter.hasNext()) {
            TopicMessageContainer container = (TopicMessageContainer)iter.next();
            if (!(container instanceof DurableTopicMessageContainer)) continue;
            ((DurableTopicMessageContainer)container).storeSubscription(info, subscription);
        }
        if (shouldRecover) {
            this.recoverSubscriptions(subscription);
        }
        subscription.setActive(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recoverSubscriptions(Subscription subscription) throws JMSException {
        if (subscription.isWildcard()) {
            DurableTopicMessageContainerManager durableTopicMessageContainerManager = this;
            synchronized (durableTopicMessageContainerManager) {
                if (!this.loadedMessageContainers) {
                    this.loadAllMessageContainers();
                    this.loadedMessageContainers = true;
                }
            }
        } else {
            this.getContainer(subscription.getDestination().getPhysicalName());
        }
        Set containers = this.destinationMap.get(subscription.getDestination());
        Iterator iter = containers.iterator();
        while (iter.hasNext()) {
            TopicMessageContainer container = (TopicMessageContainer)iter.next();
            container.recoverSubscription(subscription);
        }
    }

    protected void loadAllMessageContainers() throws JMSException {
        Map destinations = this.persistenceAdapter.getInitialDestinations();
        if (destinations != null) {
            Iterator iter = destinations.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String name = (String)entry.getKey();
                Destination destination = (Destination)entry.getValue();
                this.loadContainer(name, destination);
            }
        }
    }

    protected Filter createFilter(ConsumerInfo info) throws JMSException {
        Filter filter = this.filterFactory.createFilter(info.getDestination(), info.getSelector());
        if (info.isNoLocal()) {
            filter = new AndFilter(filter, new NoLocalFilter(info.getClientId()));
        }
        return filter;
    }

    public void createMessageContainer(ActiveMQDestination dest) throws JMSException {
        if (!dest.isTopic()) {
            return;
        }
        super.createMessageContainer(dest);
    }

    public synchronized void destroyMessageContainer(ActiveMQDestination dest) throws JMSException {
        if (!dest.isTopic()) {
            return;
        }
        super.destroyMessageContainer(dest);
    }
}

