/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.service.impl;

import java.util.Map;
import javax.transaction.xa.XAException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.activemq.broker.Broker;
import org.codehaus.activemq.service.impl.AbstractTransaction;

public class LocalTransactionCommand
extends AbstractTransaction {
    private static final long serialVersionUID = -5754338187296859149L;
    private static final Log log = LogFactory.getLog((Class)LocalTransactionCommand.class);
    private Map localTxs;
    private Object txid;

    public LocalTransactionCommand(Broker broker, Map localTxs, Object txid) {
        super(broker);
        this.localTxs = localTxs;
        this.txid = txid;
    }

    public void commit(boolean onePhase) throws XAException {
        try {
            this.prePrepare();
        }
        catch (XAException e) {
            throw e;
        }
        catch (Throwable e) {
            log.warn((Object)"COMMIT FAILED: ", e);
            this.rollback();
            XAException xae = new XAException("COMMIT FAILED: Transaction rolled back.");
            xae.errorCode = 104;
            xae.initCause(e);
            throw xae;
        }
        this.setState((byte)3);
        this.localTxs.remove(this.txid);
        try {
            this.postCommit();
        }
        catch (Throwable e) {
            log.warn((Object)"POST COMMIT FAILED: ", e);
            XAException xae = new XAException("POST COMMIT FAILED");
            xae.errorCode = -3;
            xae.initCause(e);
            throw xae;
        }
    }

    public void rollback() throws XAException {
        this.setState((byte)3);
        this.localTxs.remove(this.txid);
        try {
            this.postRollback();
        }
        catch (Throwable e) {
            log.warn((Object)"POST ROLLBACK FAILED: ", e);
            XAException xae = new XAException("POST ROLLBACK FAILED");
            xae.errorCode = -3;
            xae.initCause(e);
            throw xae;
        }
    }

    public int prepare() throws XAException {
        XAException xae = new XAException("Prepare not implemented on Local Transactions.");
        xae.errorCode = -3;
        throw xae;
    }
}

