/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.message;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import org.codehaus.activemq.filter.DestinationFilter;
import org.codehaus.activemq.filter.DestinationPath;
import org.codehaus.activemq.jndi.JNDIBaseStorable;
import org.codehaus.activemq.management.JMSDestinationStats;
import org.codehaus.activemq.message.ActiveMQQueue;
import org.codehaus.activemq.message.ActiveMQTemporaryQueue;
import org.codehaus.activemq.message.ActiveMQTemporaryTopic;
import org.codehaus.activemq.message.ActiveMQTopic;

public abstract class ActiveMQDestination
extends JNDIBaseStorable
implements Destination,
Comparable,
Serializable {
    public static final int ACTIVEMQ_TOPIC = 1;
    public static final int ACTIVEMQ_TEMPORARY_TOPIC = 2;
    public static final int ACTIVEMQ_QUEUE = 3;
    public static final int ACTIVEMQ_TEMPORARY_QUEUE = 4;
    private static final int NULL_DESTINATION = 10;
    private static final String TEMP_PREFIX = "{TD{";
    private static final String TEMP_POSTFIX = "}TD}";
    private static final String COMPOSITE_SEPARATOR = ",";
    private static final String QUEUE_PREFIX = "queue://";
    private static final String TOPIC_PREFIX = "topic://";
    private String physicalName;
    private transient DestinationFilter filter;
    private transient JMSDestinationStats stats;
    private transient String[] paths;
    private transient int consumerCounter;
    private transient boolean deleted;

    public static String inspect(Destination destination) {
        if (destination instanceof Topic) {
            return "Topic(" + destination.toString() + ")";
        }
        return "Queue(" + destination.toString() + ")";
    }

    public static ActiveMQDestination transformDestination(Destination destination) throws JMSException {
        ActiveMQDestination result = null;
        if (destination != null) {
            if (destination instanceof ActiveMQDestination) {
                result = (ActiveMQDestination)destination;
            } else if (destination instanceof TemporaryQueue) {
                result = new ActiveMQTemporaryQueue(((Queue)destination).getQueueName());
            } else if (destination instanceof TemporaryTopic) {
                result = new ActiveMQTemporaryTopic(((Topic)destination).getTopicName());
            } else if (destination instanceof Queue) {
                result = new ActiveMQTemporaryQueue(((Queue)destination).getQueueName());
            } else if (destination instanceof Topic) {
                result = new ActiveMQTemporaryTopic(((Topic)destination).getTopicName());
            }
        }
        return result;
    }

    public static void writeToStream(ActiveMQDestination destination, DataOutput dataOut) throws IOException {
        if (destination != null) {
            dataOut.write(destination.getDestinationType());
            dataOut.writeUTF(destination == null ? "" : destination.getPhysicalName());
        } else {
            dataOut.write(10);
        }
    }

    public static ActiveMQDestination readFromStream(DataInput dataIn) throws IOException {
        byte type = dataIn.readByte();
        if (type == 10) {
            return null;
        }
        ActiveMQDestination result = null;
        result = type == 1 ? new ActiveMQTopic() : (type == 2 ? new ActiveMQTemporaryTopic() : (type == 3 ? new ActiveMQQueue() : new ActiveMQTemporaryQueue()));
        result.setPhysicalName(dataIn.readUTF());
        return result;
    }

    public static String createTemporaryName(String clientId) {
        return TEMP_PREFIX + clientId + TEMP_POSTFIX;
    }

    public static String getClientId(ActiveMQDestination destination) {
        int stop;
        String name;
        int start;
        String answer = null;
        if (destination != null && destination.isTemporary() && (start = (name = destination.getPhysicalName()).indexOf(TEMP_PREFIX)) >= 0 && (stop = name.lastIndexOf(TEMP_POSTFIX)) > (start += TEMP_PREFIX.length()) && stop < name.length()) {
            answer = name.substring(start, stop);
        }
        return answer;
    }

    protected ActiveMQDestination() {
    }

    protected ActiveMQDestination(String name) {
        this.physicalName = name;
    }

    public int compareTo(Object o) {
        if (o instanceof ActiveMQDestination) {
            return this.compareTo((ActiveMQDestination)o);
        }
        return -1;
    }

    public int compareTo(ActiveMQDestination that) {
        int answer = 0;
        if (this.physicalName != that.physicalName) {
            if (this.physicalName == null) {
                return -1;
            }
            if (that.physicalName == null) {
                return 1;
            }
            answer = this.physicalName.compareTo(that.physicalName);
        }
        if (answer == 0) {
            if (this.isTopic()) {
                if (that.isQueue()) {
                    return 1;
                }
            } else if (that.isTopic()) {
                return -1;
            }
        }
        return answer;
    }

    public abstract int getDestinationType();

    public String getPhysicalName() {
        return this.physicalName;
    }

    public void setPhysicalName(String newPhysicalName) {
        this.physicalName = newPhysicalName;
    }

    public boolean isTemporary() {
        return this.getDestinationType() == 2 || this.getDestinationType() == 4;
    }

    public boolean isTopic() {
        return this.getDestinationType() == 1 || this.getDestinationType() == 2;
    }

    public boolean isQueue() {
        return !this.isTopic();
    }

    public boolean isComposite() {
        return this.physicalName.indexOf(COMPOSITE_SEPARATOR) > 0;
    }

    public List getChildDestinations() {
        ArrayList<ActiveMQDestination> answer = new ArrayList<ActiveMQDestination>();
        StringTokenizer iter = new StringTokenizer(this.physicalName, COMPOSITE_SEPARATOR);
        while (iter.hasMoreTokens()) {
            String name = iter.nextToken();
            ActiveMQDestination child = null;
            child = name.startsWith(QUEUE_PREFIX) ? new ActiveMQQueue(name.substring(QUEUE_PREFIX.length())) : (name.startsWith(TOPIC_PREFIX) ? new ActiveMQTopic(name.substring(TOPIC_PREFIX.length())) : this.createDestination(name));
            answer.add(child);
        }
        if (answer.size() == 1) {
            answer.set(0, this);
        }
        return answer;
    }

    public String toString() {
        return this.physicalName;
    }

    public int hashCode() {
        int answer = -889275714;
        if (this.physicalName != null) {
            answer = this.physicalName.hashCode();
        }
        if (this.isTopic()) {
            answer ^= 0xFABFAB;
        }
        return answer;
    }

    public boolean equals(Object obj) {
        boolean result;
        boolean bl = result = this == obj;
        if (!result && obj != null && obj instanceof ActiveMQDestination) {
            ActiveMQDestination other = (ActiveMQDestination)obj;
            result = this.getDestinationType() == other.getDestinationType() && this.physicalName.equals(other.physicalName);
        }
        return result;
    }

    public boolean isWildcard() {
        if (this.physicalName != null) {
            return this.physicalName.indexOf("*") >= 0 || this.physicalName.indexOf(">") >= 0;
        }
        return false;
    }

    public boolean matches(ActiveMQDestination destination) {
        if (this.isWildcard()) {
            return this.getDestinationFilter().matches(destination);
        }
        return this.equals(destination);
    }

    public DestinationFilter getDestinationFilter() {
        if (this.filter == null) {
            this.filter = DestinationFilter.parseFilter(this);
        }
        return this.filter;
    }

    public String[] getDestinationPaths() {
        if (this.paths == null) {
            this.paths = DestinationPath.getDestinationPaths(this.physicalName);
        }
        return this.paths;
    }

    public JMSDestinationStats getStats() {
        if (this.stats == null) {
            this.stats = this.createDestinationStats();
        }
        return this.stats;
    }

    public void setStats(JMSDestinationStats stats) {
        this.stats = stats;
    }

    public synchronized void incrementConsumerCounter() {
        ++this.consumerCounter;
    }

    public synchronized void decrementConsumerCounter() {
        --this.consumerCounter;
    }

    public synchronized boolean isDeleted() {
        return this.deleted;
    }

    public synchronized void delete() throws JMSException {
        if (this.consumerCounter != 0) {
            throw new JMSException("A consumer is still using this temporary queue.");
        }
        this.deleted = true;
    }

    protected abstract Destination createDestination(String var1);

    protected abstract JMSDestinationStats createDestinationStats();

    protected void buildFromProperties(Properties props) {
        this.physicalName = props.getProperty("physicalName", this.physicalName);
    }

    protected void populateProperties(Properties props) {
        props.put("physicalName", this.physicalName);
    }
}

