/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.util;

import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import org.codehaus.activemq.util.JMSExceptionHelper;

public abstract class MessageListenerSupport
implements MessageListener {
    private ExceptionListener exceptionListener;

    public void onMessage(Message message) {
        try {
            this.processMessage(message);
        }
        catch (JMSException e) {
            this.onJMSException(e, message);
        }
        catch (Exception e) {
            JMSException jmsEx = JMSExceptionHelper.newJMSException(e.getMessage(), e);
            this.onJMSException(jmsEx, message);
        }
    }

    public ExceptionListener getExceptionListener() {
        return this.exceptionListener;
    }

    public void setExceptionListener(ExceptionListener exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    protected abstract void processMessage(Message var1) throws Exception;

    protected void onJMSException(JMSException e, Message message) {
        if (this.exceptionListener == null) {
            throw new RuntimeException("Failed to process message: " + message + " Reason: " + (Object)((Object)e), e);
        }
        this.exceptionListener.onException(e);
    }
}

