/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.broker;

import java.io.File;
import java.util.Hashtable;
import java.util.Map;
import javax.jms.JMSException;
import javax.naming.Context;
import javax.transaction.xa.XAException;
import org.codehaus.activemq.broker.BrokerAdmin;
import org.codehaus.activemq.broker.BrokerClient;
import org.codehaus.activemq.broker.ConsumerInfoListener;
import org.codehaus.activemq.capacity.CapacityMonitor;
import org.codehaus.activemq.message.ActiveMQMessage;
import org.codehaus.activemq.message.ActiveMQXid;
import org.codehaus.activemq.message.ConnectionInfo;
import org.codehaus.activemq.message.ConsumerInfo;
import org.codehaus.activemq.message.MessageAck;
import org.codehaus.activemq.message.ProducerInfo;
import org.codehaus.activemq.security.SecurityAdapter;
import org.codehaus.activemq.service.DeadLetterPolicy;
import org.codehaus.activemq.service.MessageContainerManager;
import org.codehaus.activemq.service.RedeliveryPolicy;
import org.codehaus.activemq.service.Service;
import org.codehaus.activemq.store.PersistenceAdapter;

public interface Broker
extends Service,
CapacityMonitor {
    public BrokerAdmin getBrokerAdmin();

    public void addClient(BrokerClient var1, ConnectionInfo var2) throws JMSException;

    public void removeClient(BrokerClient var1, ConnectionInfo var2) throws JMSException;

    public void addMessageProducer(BrokerClient var1, ProducerInfo var2) throws JMSException;

    public void removeMessageProducer(BrokerClient var1, ProducerInfo var2) throws JMSException;

    public void addMessageConsumer(BrokerClient var1, ConsumerInfo var2) throws JMSException;

    public void removeMessageConsumer(BrokerClient var1, ConsumerInfo var2) throws JMSException;

    public void sendMessage(BrokerClient var1, ActiveMQMessage var2) throws JMSException;

    public void sendTransactedMessage(BrokerClient var1, String var2, ActiveMQMessage var3) throws JMSException;

    public void acknowledgeMessage(BrokerClient var1, MessageAck var2) throws JMSException;

    public void acknowledgeTransactedMessage(BrokerClient var1, String var2, MessageAck var3) throws JMSException;

    public ActiveMQXid[] getPreparedTransactions(BrokerClient var1) throws XAException;

    public void redeliverMessage(BrokerClient var1, MessageAck var2) throws JMSException;

    public void deleteSubscription(String var1, String var2) throws JMSException;

    public void startTransaction(BrokerClient var1, String var2) throws JMSException;

    public void commitTransaction(BrokerClient var1, String var2) throws JMSException;

    public void rollbackTransaction(BrokerClient var1, String var2) throws JMSException;

    public void startTransaction(BrokerClient var1, ActiveMQXid var2) throws XAException;

    public int prepareTransaction(BrokerClient var1, ActiveMQXid var2) throws XAException;

    public void rollbackTransaction(BrokerClient var1, ActiveMQXid var2) throws XAException;

    public void commitTransaction(BrokerClient var1, ActiveMQXid var2, boolean var3) throws XAException;

    public File getTempDir();

    public String getBrokerName();

    public String getBrokerClusterName();

    public PersistenceAdapter getPersistenceAdapter();

    public void setPersistenceAdapter(PersistenceAdapter var1);

    public Map getContainerManagerMap();

    public Context getDestinationContext(Hashtable var1);

    public void addConsumerInfoListener(ConsumerInfoListener var1);

    public void removeConsumerInfoListener(ConsumerInfoListener var1);

    public MessageContainerManager getPersistentTopicContainerManager();

    public MessageContainerManager getTransientTopicContainerManager();

    public MessageContainerManager getPersistentQueueContainerManager();

    public MessageContainerManager getTransientQueueContainerManager();

    public SecurityAdapter getSecurityAdapter();

    public void setSecurityAdapter(SecurityAdapter var1);

    public RedeliveryPolicy getRedeliveryPolicy();

    public void setRedeliveryPolicy(RedeliveryPolicy var1);

    public DeadLetterPolicy getDeadLetterPolicy();

    public void setDeadLetterPolicy(DeadLetterPolicy var1);

    public void sendToDeadLetterQueue(String var1, ActiveMQMessage var2) throws JMSException;
}

