/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.jndi;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.Topic;
import javax.naming.CommunicationException;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import org.codehaus.activemq.ActiveMQConnectionFactory;
import org.codehaus.activemq.broker.Broker;
import org.codehaus.activemq.jndi.ReadOnlyContext;
import org.codehaus.activemq.message.ActiveMQQueue;
import org.codehaus.activemq.message.ActiveMQTopic;

public class ActiveMQInitialContextFactory
implements InitialContextFactory {
    protected static final String[] defaultConnectionFactoryNames = new String[]{"ConnectionFactory", "QueueConnectionFactory", "TopicConnectionFactory"};
    private String queuePrefix = "queue.";
    private String topicPrefix = "topic.";

    public Context getInitialContext(Hashtable environment) throws NamingException {
        ConcurrentHashMap data = new ConcurrentHashMap();
        ActiveMQConnectionFactory factory = this.createConnectionFactory(environment);
        String[] names = this.getConnectionFactoryNames(environment);
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            data.put(name, factory);
        }
        ActiveMQConnectionFactory durableFactory = this.createDurableConnectionFactory(environment);
        ConcurrentHashMap jmsContext = new ConcurrentHashMap();
        jmsContext.put("DURABLE_SUB_CONNECTION_FACTORY", durableFactory);
        data.put("jms", new ReadOnlyContext(environment, (Map)jmsContext));
        this.createQueues((Map)data, environment);
        this.createTopics((Map)data, environment);
        try {
            Broker broker = factory.getEmbeddedBroker();
            if (broker != null) {
                data.put("destinations", broker.getDestinationContext(environment));
            }
        }
        catch (JMSException e) {
            CommunicationException exception = new CommunicationException("Failed to access embedded broker: " + (Object)((Object)e));
            exception.setRootCause(e);
            throw exception;
        }
        return new ReadOnlyContext(environment, (Map)data);
    }

    public String getTopicPrefix() {
        return this.topicPrefix;
    }

    public void setTopicPrefix(String topicPrefix) {
        this.topicPrefix = topicPrefix;
    }

    public String getQueuePrefix() {
        return this.queuePrefix;
    }

    public void setQueuePrefix(String queuePrefix) {
        this.queuePrefix = queuePrefix;
    }

    protected String[] getConnectionFactoryNames(Map environment) {
        String factoryNames = (String)environment.get("connectionFactoryNames");
        if (factoryNames != null) {
            ArrayList<String> list = new ArrayList<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(factoryNames, ",");
            while (stringTokenizer.hasMoreTokens()) {
                list.add(stringTokenizer.nextToken().trim());
            }
            int size = list.size();
            if (size > 0) {
                String[] answer = new String[size];
                list.toArray(answer);
                return answer;
            }
        }
        return defaultConnectionFactoryNames;
    }

    protected void createQueues(Map data, Hashtable environment) {
        Iterator iter = environment.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String key = entry.getKey().toString();
            if (!key.startsWith(this.queuePrefix)) continue;
            String jndiName = key.substring(this.queuePrefix.length());
            data.put(jndiName, this.createQueue(entry.getValue().toString()));
        }
    }

    protected void createTopics(Map data, Hashtable environment) {
        Iterator iter = environment.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String key = entry.getKey().toString();
            if (!key.startsWith(this.topicPrefix)) continue;
            String jndiName = key.substring(this.topicPrefix.length());
            data.put(jndiName, this.createTopic(entry.getValue().toString()));
        }
    }

    protected ActiveMQConnectionFactory createDurableConnectionFactory(Hashtable environment) {
        ActiveMQConnectionFactory answer = this.createConnectionFactory(environment);
        if (answer.getClientID() == null || answer.getClientID().length() == 0) {
            answer.setClientID("clientid");
        }
        return answer;
    }

    protected Queue createQueue(String name) {
        return new ActiveMQQueue(name);
    }

    protected Topic createTopic(String name) {
        return new ActiveMQTopic(name);
    }

    protected ActiveMQConnectionFactory createConnectionFactory(Hashtable environment) {
        ActiveMQConnectionFactory answer = new ActiveMQConnectionFactory();
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)environment);
        answer.setProperties(properties);
        return answer;
    }
}

