/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.security.jassjacc;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.Iterator;
import javax.jms.JMSException;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyConfigurationFactory;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.activemq.broker.BrokerClient;
import org.codehaus.activemq.message.ActiveMQDestination;
import org.codehaus.activemq.message.ActiveMQMessage;
import org.codehaus.activemq.message.ConnectionInfo;
import org.codehaus.activemq.message.ConsumerInfo;
import org.codehaus.activemq.message.ProducerInfo;
import org.codehaus.activemq.security.SecurityAdapter;
import org.codehaus.activemq.security.jassjacc.BrokerSecurityConfig;
import org.codehaus.activemq.security.jassjacc.DestinationSecurityConfig;
import org.codehaus.activemq.security.jassjacc.JMSBrokerPermission;
import org.codehaus.activemq.security.jassjacc.JMSDestinationPermission;
import org.codehaus.activemq.security.jassjacc.UsernamePasswordCallback;

public class JassJaccSecurityAdapter
implements SecurityAdapter {
    private static final Log log = LogFactory.getLog((Class)JassJaccSecurityAdapter.class);
    private String jassConfiguration;

    public JassJaccSecurityAdapter(String jassConfiguration) {
        this.jassConfiguration = jassConfiguration;
    }

    protected AccessControlContext getAccessControlContext(BrokerClient client) {
        Subject subject = client.getSubject();
        if (subject == null) {
            throw new IllegalArgumentException("Subject must not be null");
        }
        AccessControlContext acc = (AccessControlContext)Subject.doAsPrivileged(subject, new PrivilegedAction(){

            public Object run() {
                return AccessController.getContext();
            }
        }, null);
        return acc;
    }

    protected static String getBrokerName(BrokerClient client) {
        return client.getBrokerConnector().getBrokerInfo().getBrokerName();
    }

    public void authorizeConnection(BrokerClient client, ConnectionInfo info) throws JMSException {
        Thread.currentThread().setContextClassLoader(JassJaccSecurityAdapter.class.getClassLoader());
        Subject subject = this.doJassLogin(info);
        client.setSubject(subject);
        PolicyContext.setContextID((String)JassJaccSecurityAdapter.getBrokerPoicyContextId(client));
        AccessControlContext accessContext = this.getAccessControlContext(client);
        if (accessContext != null) {
            JMSBrokerPermission permission = new JMSBrokerPermission(JassJaccSecurityAdapter.getBrokerName(client), "connect");
            accessContext.checkPermission(permission);
        }
    }

    private static String getBrokerPoicyContextId(BrokerClient client) {
        return JassJaccSecurityAdapter.getBrokerPolicyContextId(JassJaccSecurityAdapter.getBrokerName(client));
    }

    private static String getBrokerPolicyContextId(String brokerName) {
        return "org.codehaus.activemq.broker:" + brokerName;
    }

    private Subject doJassLogin(ConnectionInfo info) throws JMSException {
        try {
            LoginContext lc = new LoginContext(this.jassConfiguration, new UsernamePasswordCallback(info.getUserName(), info.getPassword()));
            lc.login();
            return lc.getSubject();
        }
        catch (Exception e) {
            throw (JMSException)new JMSException("Login failed: " + e.getMessage()).initCause((Throwable)e);
        }
    }

    public void authorizeConsumer(BrokerClient client, ConsumerInfo info) throws JMSException {
        PolicyContext.setContextID((String)JassJaccSecurityAdapter.getDestinationPoicyContextId(client, info.getDestination()));
        AccessControlContext accessContext = this.getAccessControlContext(client);
        if (accessContext != null) {
            JMSDestinationPermission permission = new JMSDestinationPermission(info.getDestination().getPhysicalName(), "consume");
            accessContext.checkPermission(permission);
        }
    }

    private static String getDestinationPoicyContextId(BrokerClient client, ActiveMQDestination destination) {
        return JassJaccSecurityAdapter.getDestinationPoicyContextId(JassJaccSecurityAdapter.getBrokerName(client), destination);
    }

    private static String getDestinationPoicyContextId(String brokerName, ActiveMQDestination destination) {
        ActiveMQDestination activeMQDestination = destination;
        return (activeMQDestination.isTopic() ? "org.codehaus.activemq.topic:" : "org.codehaus.activemq.queue:") + brokerName + ":" + activeMQDestination.getPhysicalName();
    }

    public void authorizeProducer(BrokerClient client, ProducerInfo info) throws JMSException {
        PolicyContext.setContextID((String)JassJaccSecurityAdapter.getDestinationPoicyContextId(client, info.getDestination()));
        AccessControlContext accessContext = this.getAccessControlContext(client);
        if (accessContext != null) {
            JMSDestinationPermission permission = new JMSDestinationPermission(info.getDestination().getPhysicalName(), "produce");
            accessContext.checkPermission(permission);
        }
    }

    public void authorizeSendMessage(BrokerClient client, ActiveMQMessage message) throws JMSException {
        PolicyContext.setContextID((String)JassJaccSecurityAdapter.getDestinationPoicyContextId(client, message.getJMSActiveMQDestination()));
        AccessControlContext accessContext = this.getAccessControlContext(client);
        if (accessContext != null) {
            String physicalName = ((ActiveMQDestination)message.getJMSDestination()).getPhysicalName();
            JMSDestinationPermission permission = new JMSDestinationPermission(message.getJMSActiveMQDestination().getPhysicalName(), "send");
            accessContext.checkPermission(permission);
        }
    }

    public static void secure(BrokerSecurityConfig brokerSecurity) {
        try {
            PolicyConfigurationFactory factory = PolicyConfigurationFactory.getPolicyConfigurationFactory();
            PolicyConfiguration policyConfiguration = factory.getPolicyConfiguration(JassJaccSecurityAdapter.getBrokerPolicyContextId(brokerSecurity.getBrokerName()), true);
            Iterator iter = brokerSecurity.getConnectRoles().iterator();
            while (iter.hasNext()) {
                String role = (String)iter.next();
                policyConfiguration.addToRole(role, (Permission)new JMSBrokerPermission(brokerSecurity.getBrokerName(), "connect"));
            }
            policyConfiguration.commit();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (PolicyContextException e) {
            e.printStackTrace();
        }
    }

    public static void secure(DestinationSecurityConfig destinationSecurity) {
        try {
            String role;
            String policyId = JassJaccSecurityAdapter.getDestinationPoicyContextId(destinationSecurity.getBrokerName(), destinationSecurity.getDestination());
            PolicyConfigurationFactory factory = PolicyConfigurationFactory.getPolicyConfigurationFactory();
            PolicyConfiguration policyConfiguration = factory.getPolicyConfiguration(policyId, true);
            Iterator iter = destinationSecurity.getConsumeRoles().iterator();
            while (iter.hasNext()) {
                role = (String)iter.next();
                policyConfiguration.addToRole(role, (Permission)new JMSDestinationPermission(destinationSecurity.getDestination().getPhysicalName(), "consume"));
            }
            iter = destinationSecurity.getProduceRoles().iterator();
            while (iter.hasNext()) {
                role = (String)iter.next();
                policyConfiguration.addToRole(role, (Permission)new JMSDestinationPermission(destinationSecurity.getDestination().getPhysicalName(), "produce"));
            }
            iter = destinationSecurity.getSendRoles().iterator();
            while (iter.hasNext()) {
                role = (String)iter.next();
                policyConfiguration.addToRole(role, (Permission)new JMSDestinationPermission(destinationSecurity.getDestination().getPhysicalName(), "send"));
            }
            policyConfiguration.commit();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (PolicyContextException e) {
            e.printStackTrace();
        }
    }
}

