/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq;

import EDU.oswego.cs.dl.util.concurrent.CopyOnWriteArrayList;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedInt;
import java.util.Iterator;
import java.util.List;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import javax.jms.XAConnection;
import javax.management.j2ee.statistics.Stats;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.activemq.ActiveMQConnectionConsumer;
import org.codehaus.activemq.ActiveMQConnectionFactory;
import org.codehaus.activemq.ActiveMQConnectionMetaData;
import org.codehaus.activemq.ActiveMQMessageConsumer;
import org.codehaus.activemq.ActiveMQMessageDispatcher;
import org.codehaus.activemq.ActiveMQMessageProducer;
import org.codehaus.activemq.ActiveMQMessageTransformation;
import org.codehaus.activemq.ActiveMQPrefetchPolicy;
import org.codehaus.activemq.ActiveMQQueueSession;
import org.codehaus.activemq.ActiveMQSession;
import org.codehaus.activemq.ActiveMQTopicSession;
import org.codehaus.activemq.Closeable;
import org.codehaus.activemq.TimeoutExpiredException;
import org.codehaus.activemq.capacity.CapacityMonitorEvent;
import org.codehaus.activemq.capacity.CapacityMonitorEventListener;
import org.codehaus.activemq.management.JMSConnectionStatsImpl;
import org.codehaus.activemq.management.JMSStatsImpl;
import org.codehaus.activemq.management.StatsCapable;
import org.codehaus.activemq.message.ActiveMQDestination;
import org.codehaus.activemq.message.ActiveMQMessage;
import org.codehaus.activemq.message.BrokerAdminCommand;
import org.codehaus.activemq.message.CapacityInfo;
import org.codehaus.activemq.message.CleanupConnectionInfo;
import org.codehaus.activemq.message.ConnectionInfo;
import org.codehaus.activemq.message.ConsumerInfo;
import org.codehaus.activemq.message.Packet;
import org.codehaus.activemq.message.PacketListener;
import org.codehaus.activemq.message.ProducerInfo;
import org.codehaus.activemq.message.Receipt;
import org.codehaus.activemq.message.SessionInfo;
import org.codehaus.activemq.message.WireFormatInfo;
import org.codehaus.activemq.message.util.MemoryBoundedQueue;
import org.codehaus.activemq.message.util.MemoryBoundedQueueManager;
import org.codehaus.activemq.transport.TransportChannel;
import org.codehaus.activemq.transport.TransportStatusEvent;
import org.codehaus.activemq.transport.TransportStatusEventListener;
import org.codehaus.activemq.util.IdGenerator;
import org.codehaus.activemq.util.JMSExceptionHelper;

public class ActiveMQConnection
implements Connection,
PacketListener,
ExceptionListener,
TopicConnection,
QueueConnection,
StatsCapable,
CapacityMonitorEventListener,
TransportStatusEventListener,
Closeable {
    public static final String DEFAULT_USER = "defaultUser";
    public static final String DEFAULT_URL = "tcp://localhost:61616";
    public static final String DEFAULT_PASSWORD = "defaultPassword";
    private static final Log log = LogFactory.getLog((Class)ActiveMQConnection.class);
    private static final int DEFAULT_CONNECTION_MEMORY_LIMIT = 0xA00000;
    private ActiveMQConnectionFactory factory;
    private String userName;
    private String password;
    protected String clientID;
    private int sendCloseTimeout = 2000;
    private TransportChannel transportChannel;
    private ExceptionListener exceptionListener;
    private ActiveMQPrefetchPolicy prefetchPolicy;
    private JMSStatsImpl factoryStats;
    private MemoryBoundedQueueManager boundedQueueManager;
    protected IdGenerator handleIdGenerator;
    private IdGenerator clientIdGenerator;
    protected IdGenerator packetIdGenerator;
    private IdGenerator sessionIdGenerator;
    private JMSConnectionStatsImpl stats;
    private CopyOnWriteArrayList sessions;
    private CopyOnWriteArrayList messageDispatchers;
    private CopyOnWriteArrayList connectionConsumers;
    private SynchronizedInt consumerNumberGenerator;
    private ActiveMQConnectionMetaData connectionMetaData;
    private SynchronizedBoolean closed;
    private SynchronizedBoolean started;
    private boolean clientIDSet;
    private boolean isConnectionInfoSentToBroker;
    private boolean isTransportOK;
    private boolean startedTransport;
    private long startTime;
    private long flowControlSleepTime = 0L;
    private boolean quickClose;
    private boolean internalConnection;
    private boolean userSpecifiedClientID;
    protected boolean useAsyncSend = false;
    private int sendConnectionInfoTimeout = 30000;
    private boolean disableTimeStampsByDefault = false;
    private boolean J2EEcompliant = true;
    private boolean prepareMessageBodyOnSend = true;
    private boolean doMessageCompression = true;
    private int messageCompressionLimit = 32768;
    private int messageCompressionLevel = 1;
    private int messageCompressionStrategy = 0;
    private boolean doMessageFragmentation = true;
    private int messageFragmentationLimit = 65536;
    private boolean cachingEnabled = true;

    public static ActiveMQConnection makeConnection() throws JMSException {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory();
        return (ActiveMQConnection)factory.createConnection();
    }

    public static ActiveMQConnection makeConnection(String uri) throws JMSException {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(uri);
        return (ActiveMQConnection)factory.createConnection();
    }

    public static ActiveMQConnection makeConnection(String user, String password, String uri) throws JMSException {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(user, password, uri);
        return (ActiveMQConnection)factory.createConnection();
    }

    public ActiveMQConnection(ActiveMQConnectionFactory factory, String theUserName, String thePassword, TransportChannel transportChannel) throws JMSException {
        this(factory, theUserName, thePassword);
        this.transportChannel = transportChannel;
        this.transportChannel.setPacketListener(this);
        this.transportChannel.setExceptionListener(this);
        this.transportChannel.addTransportStatusEventListener(this);
        this.isTransportOK = true;
    }

    protected ActiveMQConnection(ActiveMQConnectionFactory factory, String theUserName, String thePassword) {
        this.factory = factory;
        this.userName = theUserName;
        this.password = thePassword;
        this.clientIdGenerator = new IdGenerator();
        this.packetIdGenerator = new IdGenerator();
        this.handleIdGenerator = new IdGenerator();
        this.sessionIdGenerator = new IdGenerator();
        this.consumerNumberGenerator = new SynchronizedInt(0);
        this.sessions = new CopyOnWriteArrayList();
        this.messageDispatchers = new CopyOnWriteArrayList();
        this.connectionConsumers = new CopyOnWriteArrayList();
        this.connectionMetaData = new ActiveMQConnectionMetaData();
        this.closed = new SynchronizedBoolean(false);
        this.started = new SynchronizedBoolean(false);
        this.startTime = System.currentTimeMillis();
        this.prefetchPolicy = new ActiveMQPrefetchPolicy();
        this.boundedQueueManager = new MemoryBoundedQueueManager(this.clientID, 0xA00000L);
        this.boundedQueueManager.addCapacityEventListener(this);
        boolean transactional = this instanceof XAConnection;
        this.factoryStats = factory.getFactoryStats();
        this.factoryStats.addConnection(this);
        this.stats = new JMSConnectionStatsImpl((List)this.sessions, transactional);
        factory.onConnectionCreate(this);
    }

    public Stats getStats() {
        return this.stats;
    }

    public JMSConnectionStatsImpl getConnectionStats() {
        return this.stats;
    }

    public Session createSession(boolean transacted, int acknowledgeMode) throws JMSException {
        this.checkClosed();
        this.sendConnectionInfoToBroker();
        return new ActiveMQSession(this, transacted ? 0 : acknowledgeMode);
    }

    public String getClientID() throws JMSException {
        this.checkClosed();
        return this.clientID;
    }

    public void setClientID(String newClientID) throws JMSException {
        if (this.clientIDSet) {
            throw new IllegalStateException("The clientID has already been set");
        }
        if (this.isConnectionInfoSentToBroker) {
            throw new IllegalStateException("Setting clientID on a used Connection is not allowed");
        }
        this.checkClosed();
        this.clientID = newClientID;
        this.userSpecifiedClientID = true;
        this.ensureClientIDInitialised();
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        this.checkClosed();
        return this.connectionMetaData;
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        this.checkClosed();
        return this.exceptionListener;
    }

    public void setExceptionListener(ExceptionListener listener) throws JMSException {
        this.checkClosed();
        this.exceptionListener = listener;
        this.transportChannel.setExceptionListener(listener);
    }

    public void start() throws JMSException {
        this.checkClosed();
        if (this.started.commit(false, true)) {
            this.sendConnectionInfoToBroker(this.sendConnectionInfoTimeout, true, false);
            Iterator i = this.sessions.iterator();
            while (i.hasNext()) {
                ActiveMQSession s = (ActiveMQSession)i.next();
                s.start();
            }
        }
    }

    protected boolean isStarted() {
        return this.started.get();
    }

    public void stop() throws JMSException {
        this.checkClosed();
        if (this.started.commit(true, false)) {
            Iterator i = this.sessions.iterator();
            while (i.hasNext()) {
                ActiveMQSession s = (ActiveMQSession)i.next();
                s.stop();
            }
            this.sendConnectionInfoToBroker(2000, true, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws JMSException {
        this.transportChannel.setPendingStop(true);
        if (!this.closed.get()) {
            this.boundedQueueManager.removeCapacityEventListener(this);
            try {
                Iterator i = this.sessions.iterator();
                while (i.hasNext()) {
                    ActiveMQSession s = (ActiveMQSession)i.next();
                    s.close();
                }
                i = this.connectionConsumers.iterator();
                while (i.hasNext()) {
                    ActiveMQConnectionConsumer c = (ActiveMQConnectionConsumer)i.next();
                    c.close();
                }
                try {
                    this.sendConnectionInfoToBroker(this.sendCloseTimeout, true, true);
                }
                catch (TimeoutExpiredException e) {
                    log.warn((Object)("Failed to send close to broker, timeout expired of: " + this.sendCloseTimeout + " millis"));
                }
                this.connectionConsumers.clear();
                this.messageDispatchers.clear();
                this.transportChannel.stop();
                Object var4_4 = null;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.sessions.clear();
                this.started.set(false);
                this.factory.onConnectionClose(this);
                throw throwable;
            }
            this.sessions.clear();
            this.started.set(false);
            this.factory.onConnectionClose(this);
            this.closed.set(true);
        }
    }

    protected synchronized void checkClosed() throws JMSException {
        if (!this.startedTransport) {
            this.startedTransport = true;
            this.transportChannel.setCachingEnabled(this.isCachingEnabled());
            if (!this.useAsyncSend) {
                this.transportChannel.setNoDelay(true);
            }
            this.transportChannel.start();
            if (this.transportChannel.doesSupportWireFormatVersioning()) {
                WireFormatInfo info = new WireFormatInfo();
                info.setVersion(this.transportChannel.getCurrentWireFormatVersion());
                this.asyncSendPacket(info);
            }
        }
        if (this.closed.get()) {
            throw new IllegalStateException("The Connection is closed");
        }
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        this.checkClosed();
        this.ensureClientIDInitialised();
        ConsumerInfo info = new ConsumerInfo();
        info.setConsumerId(this.handleIdGenerator.generateId());
        info.setDestination(ActiveMQMessageTransformation.transformDestination(destination));
        info.setSelector(messageSelector);
        info.setConsumerNo(this.handleIdGenerator.getNextShortSequence());
        return new ActiveMQConnectionConsumer(this, sessionPool, info, maxMessages);
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        this.checkClosed();
        this.ensureClientIDInitialised();
        ConsumerInfo info = new ConsumerInfo();
        info.setConsumerId(this.handleIdGenerator.generateId());
        info.setDestination(ActiveMQMessageTransformation.transformDestination((Destination)topic));
        info.setSelector(messageSelector);
        info.setConsumerName(subscriptionName);
        info.setConsumerNo(this.handleIdGenerator.getNextShortSequence());
        return new ActiveMQConnectionConsumer(this, sessionPool, info, maxMessages);
    }

    public void consume(Packet packet) {
        if (!this.closed.get() && packet != null) {
            if (packet.isJMSMessage()) {
                long timeStamp;
                long expiration;
                ActiveMQMessage message = (ActiveMQMessage)packet;
                message.setReadOnly(true);
                message.setConsumerIdentifer(this.clientID);
                if (this.transportChannel.isMulticast() && (expiration = message.getJMSExpiration()) > 0L && (timeStamp = System.currentTimeMillis()) > expiration) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Discarding expired message: " + message));
                    }
                    return;
                }
                try {
                    int count = 0;
                    Iterator i = this.messageDispatchers.iterator();
                    while (i.hasNext()) {
                        ActiveMQMessageDispatcher dispatcher = (ActiveMQMessageDispatcher)i.next();
                        if (!dispatcher.isTarget(message)) continue;
                        if (count > 0) {
                            message = message.deepCopy();
                        }
                        dispatcher.dispatch(message);
                        ++count;
                    }
                }
                catch (JMSException jmsEx) {
                    this.handleAsyncException(jmsEx);
                }
            } else if (packet.getPacketType() == 27) {
                CapacityInfo info = (CapacityInfo)packet;
                this.flowControlSleepTime = info.getFlowControlTimeout();
            } else if (packet.getPacketType() == 30 && packet.isReceiptRequired()) {
                Receipt receipt = new Receipt();
                receipt.setCorrelationId(packet.getId());
                receipt.setReceiptRequired(false);
                try {
                    this.asyncSendPacket(receipt);
                }
                catch (JMSException jmsEx) {
                    this.handleAsyncException(jmsEx);
                }
            }
        }
    }

    public void onException(JMSException jmsEx) {
        this.handleAsyncException(jmsEx);
        this.isTransportOK = false;
        try {
            this.close();
        }
        catch (JMSException ex) {
            log.debug((Object)"Exception closing the connection", (Throwable)ex);
        }
    }

    public TopicSession createTopicSession(boolean transacted, int acknowledgeMode) throws JMSException {
        return new ActiveMQTopicSession((ActiveMQSession)this.createSession(transacted, acknowledgeMode));
    }

    public ConnectionConsumer createConnectionConsumer(Topic topic, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        this.checkClosed();
        this.ensureClientIDInitialised();
        ConsumerInfo info = new ConsumerInfo();
        info.setConsumerId(this.handleIdGenerator.generateId());
        info.setDestination(ActiveMQMessageTransformation.transformDestination((Destination)topic));
        info.setSelector(messageSelector);
        info.setConsumerNo(this.handleIdGenerator.getNextShortSequence());
        return new ActiveMQConnectionConsumer(this, sessionPool, info, maxMessages);
    }

    public QueueSession createQueueSession(boolean transacted, int acknowledgeMode) throws JMSException {
        return new ActiveMQQueueSession((ActiveMQSession)this.createSession(transacted, acknowledgeMode));
    }

    public ConnectionConsumer createConnectionConsumer(Queue queue, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        this.checkClosed();
        this.ensureClientIDInitialised();
        ConsumerInfo info = new ConsumerInfo();
        info.setConsumerId(this.handleIdGenerator.generateId());
        info.setDestination(ActiveMQMessageTransformation.transformDestination((Destination)queue));
        info.setSelector(messageSelector);
        info.setConsumerNo(this.handleIdGenerator.getNextShortSequence());
        return new ActiveMQConnectionConsumer(this, sessionPool, info, maxMessages);
    }

    public void checkClientIDWasManuallySpecified() throws JMSException {
        if (!this.userSpecifiedClientID) {
            throw new JMSException("You cannot create a durable subscriber without specifying a unique clientID on a Connection");
        }
    }

    public void statusChanged(TransportStatusEvent event) {
        log.info((Object)("channel status changed: " + event));
        if (event.getChannelStatus() == 3) {
            this.isTransportOK = true;
            this.doReconnect();
        } else if (event.getChannelStatus() == 2) {
            this.isTransportOK = false;
            this.clearMessagesInProgress();
        }
    }

    public void asyncSendPacket(Packet packet) throws JMSException {
        this.asyncSendPacket(packet, true);
    }

    public void asyncSendPacket(Packet packet, boolean doSendWhileReconnecting) throws JMSException {
        if (this.isTransportOK && !this.closed.get() && (doSendWhileReconnecting || this.transportChannel.isTransportConnected())) {
            packet.setId(this.packetIdGenerator.getNextShortSequence());
            packet.setReceiptRequired(false);
            if (packet.isJMSMessage() && this.flowControlSleepTime > 0L) {
                try {
                    Thread.sleep(this.flowControlSleepTime);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.transportChannel.asyncSend(packet);
        }
    }

    public void syncSendPacket(Packet packet) throws JMSException {
        this.syncSendPacket(packet, 0);
    }

    public void syncSendPacket(Packet packet, int timeout) throws JMSException {
        if (this.isTransportOK && !this.closed.get()) {
            packet.setId(this.packetIdGenerator.getNextShortSequence());
            packet.setReceiptRequired(true);
            Receipt receipt = this.transportChannel.send(packet, timeout);
            if (receipt != null && receipt.isFailed()) {
                Throwable e = receipt.getException();
                if (e != null) {
                    throw JMSExceptionHelper.newJMSException(e);
                }
                throw new JMSException("syncSendPacket failed with unknown exception");
            }
        } else {
            throw new JMSException("syncSendTimedOut");
        }
    }

    public Receipt syncSendRequest(Packet packet) throws JMSException {
        this.checkClosed();
        if (this.isTransportOK && !this.closed.get()) {
            packet.setReceiptRequired(true);
            packet.setId(this.packetIdGenerator.getNextShortSequence());
            Receipt receipt = this.transportChannel.send(packet);
            if (receipt != null && receipt.isFailed()) {
                Throwable e = receipt.getException();
                if (e != null) {
                    throw (JMSException)new JMSException(e.getMessage()).initCause(e);
                }
                throw new JMSException("syncSendPacket failed with unknown exception");
            }
            return receipt;
        }
        throw new JMSException("Connection closed.");
    }

    public ActiveMQPrefetchPolicy getPrefetchPolicy() {
        return this.prefetchPolicy;
    }

    public void setPrefetchPolicy(ActiveMQPrefetchPolicy prefetchPolicy) {
        this.prefetchPolicy = prefetchPolicy;
    }

    public int getSendCloseTimeout() {
        return this.sendCloseTimeout;
    }

    public void setSendCloseTimeout(int sendCloseTimeout) {
        this.sendCloseTimeout = sendCloseTimeout;
    }

    public int getSendConnectionInfoTimeout() {
        return this.sendConnectionInfoTimeout;
    }

    public void setSendConnectionInfoTimeout(int sendConnectionInfoTimeout) {
        this.sendConnectionInfoTimeout = sendConnectionInfoTimeout;
    }

    public TransportChannel getTransportChannel() {
        return this.transportChannel;
    }

    public String getInitializedClientID() throws JMSException {
        this.ensureClientIDInitialised();
        return this.clientID;
    }

    protected void addSession(ActiveMQSession session) throws JMSException {
        this.sessions.add((Object)session);
        this.addMessageDispatcher(session);
        if (this.started.get()) {
            session.start();
        }
        SessionInfo info = this.createSessionInfo(session);
        info.setStarted(true);
        this.asyncSendPacket(info);
    }

    protected void removeSession(ActiveMQSession session) throws JMSException {
        this.sessions.remove((Object)session);
        this.removeMessageDispatcher(session);
        SessionInfo info = this.createSessionInfo(session);
        info.setStarted(false);
        this.asyncSendPacket(info, false);
    }

    private SessionInfo createSessionInfo(ActiveMQSession session) {
        SessionInfo info = new SessionInfo();
        info.setClientId(this.clientID);
        info.setSessionId(session.getSessionId());
        info.setStartTime(session.getStartTime());
        return info;
    }

    protected void addConnectionConsumer(ActiveMQConnectionConsumer connectionConsumer) throws JMSException {
        this.connectionConsumers.add((Object)connectionConsumer);
        this.addMessageDispatcher(connectionConsumer);
    }

    protected void removeConnectionConsumer(ActiveMQConnectionConsumer connectionConsumer) {
        this.connectionConsumers.add((Object)connectionConsumer);
        this.removeMessageDispatcher(connectionConsumer);
    }

    protected void addMessageDispatcher(ActiveMQMessageDispatcher messageDispatch) throws JMSException {
        this.messageDispatchers.add((Object)messageDispatch);
    }

    protected void removeMessageDispatcher(ActiveMQMessageDispatcher messageDispatcher) {
        this.messageDispatchers.remove((Object)messageDispatcher);
    }

    protected void handleAsyncException(JMSException jmsEx) {
        if (this.exceptionListener != null) {
            this.exceptionListener.onException(jmsEx);
        } else {
            log.debug((Object)"Async exception with no exception listener.", (Throwable)jmsEx);
        }
    }

    protected void sendConnectionInfoToBroker() throws JMSException {
        this.sendConnectionInfoToBroker(this.sendConnectionInfoTimeout, this.closed.get(), false);
    }

    protected void sendConnectionInfoToBroker(int timeout, boolean forceResend, boolean closing) throws JMSException {
        if (this.isConnectionInfoSentToBroker && !forceResend) {
            return;
        }
        this.isConnectionInfoSentToBroker = true;
        this.ensureClientIDInitialised();
        ConnectionInfo info = new ConnectionInfo();
        info.setClientId(this.clientID);
        info.setHostName(IdGenerator.getHostName());
        info.setUserName(this.userName);
        info.setPassword(this.password);
        info.setStartTime(this.startTime);
        info.setStarted(this.started.get());
        info.setClosed(this.closed.get() || closing);
        info.setClientVersion(this.connectionMetaData.getProviderVersion());
        info.setWireFormatVersion(this.transportChannel.getCurrentWireFormatVersion());
        if (info.getProperties() != null) {
            info.getProperties().setProperty(ConnectionInfo.NO_DELAY_PROPERTY, new Boolean(!this.useAsyncSend).toString());
        }
        if (this.quickClose && info.isClosed()) {
            this.asyncSendPacket(info);
        } else {
            this.syncSendPacket(info, timeout);
        }
    }

    public void setConnectionMemoryLimit(int newMemoryLimit) {
        this.boundedQueueManager.setValueLimit(newMemoryLimit);
    }

    public int getConnectionMemoryLimit() {
        return (int)this.boundedQueueManager.getValueLimit();
    }

    public void capacityChanged(CapacityMonitorEvent event) {
        CapacityInfo info = new CapacityInfo();
        info.setResourceName(event.getMonitorName());
        info.setCapacity(event.getCapacity());
        try {
            this.asyncSendPacket(info, false);
        }
        catch (JMSException e) {
            JMSException jmsEx = new JMSException("failed to send change in capacity");
            jmsEx.setLinkedException((Exception)((Object)e));
            this.handleAsyncException(jmsEx);
        }
    }

    protected int getNextConsumerNumber() {
        return this.consumerNumberGenerator.increment();
    }

    protected short generateSessionId() {
        return this.sessionIdGenerator.getNextShortSequence();
    }

    private synchronized void ensureClientIDInitialised() {
        if (this.clientID == null || this.clientID.trim().equals("")) {
            this.clientID = this.clientIdGenerator.generateId();
        }
        this.transportChannel.setClientID(this.clientID);
        this.clientIDSet = true;
    }

    protected MemoryBoundedQueue getMemoryBoundedQueue(String name) {
        return this.boundedQueueManager.getMemoryBoundedQueue(name);
    }

    protected void doReconnect() {
        try {
            this.sendConnectionInfoToBroker(this.sendConnectionInfoTimeout, true, false);
            Iterator iter = this.sessions.iterator();
            while (iter.hasNext()) {
                ActiveMQSession session = (ActiveMQSession)iter.next();
                SessionInfo sessionInfo = this.createSessionInfo(session);
                sessionInfo.setStarted(true);
                this.asyncSendPacket(sessionInfo, false);
                Iterator consumersIterator = session.consumers.iterator();
                while (consumersIterator.hasNext()) {
                    ActiveMQMessageConsumer consumer = (ActiveMQMessageConsumer)consumersIterator.next();
                    ConsumerInfo consumerInfo = session.createConsumerInfo(consumer);
                    consumerInfo.setStarted(true);
                    this.asyncSendPacket(consumerInfo, false);
                }
                Iterator producersIterator = session.producers.iterator();
                while (producersIterator.hasNext()) {
                    ActiveMQMessageProducer producer = (ActiveMQMessageProducer)producersIterator.next();
                    ProducerInfo producerInfo = session.createProducerInfo(producer);
                    producerInfo.setStarted(true);
                    this.asyncSendPacket(producerInfo, false);
                }
                CapacityMonitorEvent event = this.boundedQueueManager.generateCapacityMonitorEvent();
                if (event == null) continue;
                this.capacityChanged(event);
            }
        }
        catch (JMSException jmsEx) {
            log.error((Object)"Failed to do reconnection");
            this.handleAsyncException(jmsEx);
            this.isTransportOK = false;
        }
    }

    public boolean isUseAsyncSend() {
        return this.useAsyncSend;
    }

    public void setUseAsyncSend(boolean useAsyncSend) {
        this.useAsyncSend = useAsyncSend;
    }

    public boolean isCachingEnabled() {
        return this.cachingEnabled;
    }

    public void setCachingEnabled(boolean cachingEnabled) {
        this.cachingEnabled = cachingEnabled;
    }

    public boolean isJ2EEcompliant() {
        return this.J2EEcompliant;
    }

    public void setJ2EEcompliant(boolean ecompliant) {
        this.J2EEcompliant = ecompliant;
    }

    public boolean isInternalConnection() {
        return this.internalConnection;
    }

    public void setInternalConnection(boolean internalConnection) {
        this.internalConnection = internalConnection;
    }

    public boolean isDoMessageCompression() {
        return this.doMessageCompression && this.transportChannel.doesSupportMessageCompression();
    }

    public void setDoMessageCompression(boolean doMessageCompression) {
        this.doMessageCompression = doMessageCompression && this.transportChannel.doesSupportMessageCompression();
    }

    public boolean isDoMessageFragmentation() {
        return this.doMessageFragmentation && this.transportChannel.doesSupportMessageFragmentation();
    }

    public void setDoMessageFragmentation(boolean doMessageFragmentation) {
        this.doMessageFragmentation = doMessageFragmentation && this.transportChannel.doesSupportMessageFragmentation();
    }

    public int getMessageCompressionLevel() {
        return this.messageCompressionLevel;
    }

    public void setMessageCompressionLevel(int messageCompressionLevel) {
        this.messageCompressionLevel = messageCompressionLevel;
    }

    public int getMessageCompressionLimit() {
        return this.messageCompressionLimit;
    }

    public void setMessageCompressionLimit(int messageCompressionLimit) {
        this.messageCompressionLimit = messageCompressionLimit;
    }

    public int getMessageCompressionStrategy() {
        return this.messageCompressionStrategy;
    }

    public void setMessageCompressionStrategy(int messageCompressionStrategy) {
        this.messageCompressionStrategy = messageCompressionStrategy;
    }

    public int getMessageFragmentationLimit() {
        return this.messageFragmentationLimit;
    }

    public void setMessageFragmentationLimit(int messageFragmentationLimit) {
        this.messageFragmentationLimit = messageFragmentationLimit;
    }

    public boolean isDisableTimeStampsByDefault() {
        return this.disableTimeStampsByDefault;
    }

    public void setDisableTimeStampsByDefault(boolean disableTimeStampsByDefault) {
        this.disableTimeStampsByDefault = disableTimeStampsByDefault;
    }

    public boolean isPrepareMessageBodyOnSend() {
        return this.prepareMessageBodyOnSend;
    }

    public void setPrepareMessageBodyOnSend(boolean prePrepareMessageOnSend) {
        this.prepareMessageBodyOnSend = prePrepareMessageOnSend;
    }

    public boolean isQuickClose() {
        return this.quickClose;
    }

    public void setQuickClose(boolean quickClose) {
        this.quickClose = quickClose;
    }

    protected void clearMessagesInProgress() {
        Iterator i = this.sessions.iterator();
        while (i.hasNext()) {
            ActiveMQSession session = (ActiveMQSession)i.next();
            session.clearMessagesInProgress();
        }
    }

    public void destroyDestination(ActiveMQDestination destination) throws JMSException {
        BrokerAdminCommand command = new BrokerAdminCommand();
        command.setCommand("DESTROY_DESTINATION");
        command.setDestination(destination);
        this.syncSendPacket(command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() throws JMSException {
        try {
            Iterator i = this.sessions.iterator();
            while (i.hasNext()) {
                ActiveMQSession s = (ActiveMQSession)i.next();
                s.close();
            }
            i = this.connectionConsumers.iterator();
            while (i.hasNext()) {
                ActiveMQConnectionConsumer c = (ActiveMQConnectionConsumer)i.next();
                c.close();
            }
            this.connectionConsumers.clear();
            this.messageDispatchers.clear();
        }
        finally {
            this.sessions.clear();
            this.started.set(false);
        }
        this.setExceptionListener(null);
        this.clientIDSet = false;
        this.isConnectionInfoSentToBroker = false;
        CleanupConnectionInfo cleanupInfo = new CleanupConnectionInfo();
        cleanupInfo.setClientId(this.getClientID());
        this.asyncSendPacket(cleanupInfo);
    }
}

