/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.management.j2ee.statistics.Stats;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.activemq.ActiveMQConnection;
import org.codehaus.activemq.XmlConfigHelper;
import org.codehaus.activemq.broker.Broker;
import org.codehaus.activemq.broker.BrokerConnector;
import org.codehaus.activemq.broker.BrokerContainer;
import org.codehaus.activemq.broker.BrokerContainerFactory;
import org.codehaus.activemq.broker.BrokerContext;
import org.codehaus.activemq.broker.impl.BrokerClientImpl;
import org.codehaus.activemq.broker.impl.BrokerConnectorImpl;
import org.codehaus.activemq.broker.impl.BrokerContainerFactoryImpl;
import org.codehaus.activemq.io.WireFormat;
import org.codehaus.activemq.io.WireFormatLoader;
import org.codehaus.activemq.io.impl.DefaultWireFormat;
import org.codehaus.activemq.jndi.JNDIBaseStorable;
import org.codehaus.activemq.management.JMSStatsImpl;
import org.codehaus.activemq.management.StatsCapable;
import org.codehaus.activemq.message.ActiveMQQueue;
import org.codehaus.activemq.message.ActiveMQTopic;
import org.codehaus.activemq.message.ConnectionInfo;
import org.codehaus.activemq.message.ConsumerInfo;
import org.codehaus.activemq.service.Service;
import org.codehaus.activemq.transport.TransportChannel;
import org.codehaus.activemq.transport.TransportChannelFactory;
import org.codehaus.activemq.transport.TransportChannelListener;
import org.codehaus.activemq.transport.TransportChannelProvider;
import org.codehaus.activemq.transport.vm.VmTransportChannel;
import org.codehaus.activemq.util.IdGenerator;

public class ActiveMQConnectionFactory
extends JNDIBaseStorable
implements ConnectionFactory,
QueueConnectionFactory,
TopicConnectionFactory,
Service,
StatsCapable {
    private static final Log log = LogFactory.getLog((Class)ActiveMQConnectionFactory.class);
    private BrokerContext brokerContext = BrokerContext.getInstance();
    private BrokerContainerFactory brokerContainerFactory;
    protected BrokerContainer brokerContainer;
    protected String userName;
    protected String password;
    protected String brokerURL;
    protected String clientID;
    protected String brokerName;
    private boolean useEmbeddedBroker;
    protected boolean useAsyncSend = false;
    protected boolean disableTimeStampsByDefault = false;
    protected boolean J2EEcompliant = true;
    private List startedEmbeddedBrokers = new ArrayList();
    private JMSStatsImpl stats = new JMSStatsImpl();
    private WireFormat wireFormat = new DefaultWireFormat();
    private IdGenerator idGenerator = new IdGenerator();
    private int connectionCount;
    private String brokerXmlConfig;
    protected boolean doMessageCompression = true;
    protected int messageCompressionLimit = 32768;
    protected int messageCompressionLevel = 1;
    protected int messageCompressionStrategy = 0;
    protected boolean doMessageFragmentation = true;
    protected int messageFragmentationLimit = 65536;
    protected boolean cachingEnabled = true;
    protected boolean prepareMessageBodyOnSend = true;
    protected boolean quickClose = false;
    protected boolean internalConnection = false;

    public ActiveMQConnectionFactory() {
        this.userName = "defaultUser";
        this.password = "defaultPassword";
        this.brokerURL = "tcp://localhost:61616";
    }

    public ActiveMQConnectionFactory(String brokerURL) {
        this();
        this.brokerURL = brokerURL;
    }

    public ActiveMQConnectionFactory(String userName, String password, String brokerURL) {
        this.userName = userName;
        this.password = password;
        this.brokerURL = brokerURL;
    }

    public ActiveMQConnectionFactory(BrokerContainer container) {
        this(container, "vm://" + container.getBroker().getName());
    }

    public ActiveMQConnectionFactory(BrokerContainer container, String brokerURL) {
        this();
        this.brokerContainer = container;
        this.useEmbeddedBroker = true;
        this.brokerURL = brokerURL;
    }

    public Stats getStats() {
        return this.stats;
    }

    public JMSStatsImpl getFactoryStats() {
        return this.stats;
    }

    public String getBrokerURL() {
        return this.brokerURL;
    }

    public void setBrokerURL(String brokerURL) {
        this.brokerURL = brokerURL;
    }

    public String getClientID() {
        return this.clientID;
    }

    public void setClientID(String clientID) {
        this.clientID = clientID;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public boolean isUseEmbeddedBroker() {
        return this.useEmbeddedBroker;
    }

    public void setUseEmbeddedBroker(boolean useEmbeddedBroker) {
        this.useEmbeddedBroker = useEmbeddedBroker;
    }

    public String getBrokerName() {
        if (this.brokerName == null) {
            this.brokerName = this.idGenerator.generateId();
        }
        return this.brokerName;
    }

    public String getBrokerName(String url) {
        if (this.brokerName == null) {
            this.brokerName = url;
        }
        return this.brokerName;
    }

    public void setBrokerName(String brokerName) {
        this.brokerName = brokerName;
    }

    public boolean isUseAsyncSend() {
        return this.useAsyncSend;
    }

    public void setUseAsyncSend(boolean useAsyncSend) {
        this.useAsyncSend = useAsyncSend;
    }

    public WireFormat getWireFormat() {
        return this.wireFormat.copy();
    }

    public void setTurboBoost(boolean value) {
        this.disableTimeStampsByDefault = value;
        this.useAsyncSend = value;
        this.cachingEnabled = value;
    }

    public boolean isTurboBoost() {
        return this.disableTimeStampsByDefault && this.useAsyncSend && this.cachingEnabled;
    }

    public boolean isDisableTimeStampsByDefault() {
        return this.disableTimeStampsByDefault;
    }

    public void setDisableTimeStampsByDefault(boolean disableTimeStampsByDefault) {
        this.disableTimeStampsByDefault = disableTimeStampsByDefault;
    }

    public boolean isJ2EEcompliant() {
        return this.J2EEcompliant;
    }

    public void setJ2EEcompliant(boolean ecompliant) {
        this.J2EEcompliant = ecompliant;
    }

    public boolean isInternalConnection() {
        return this.internalConnection;
    }

    public void setInternalConnection(boolean internalConnection) {
        this.internalConnection = internalConnection;
    }

    public boolean isQuickClose() {
        return this.quickClose;
    }

    public void setQuickClose(boolean quickClose) {
        this.quickClose = quickClose;
    }

    public boolean isDoMessageCompression() {
        return this.doMessageCompression;
    }

    public void setDoMessageCompression(boolean doMessageCompression) {
        this.doMessageCompression = doMessageCompression;
    }

    public boolean isDoMessageFragmentation() {
        return this.doMessageFragmentation;
    }

    public void setDoMessageFragmentation(boolean doMessageFragmentation) {
        this.doMessageFragmentation = doMessageFragmentation;
    }

    public int getMessageCompressionLimit() {
        return this.messageCompressionLimit;
    }

    public void setMessageCompressionLimit(int messageCompressionLimit) {
        this.messageCompressionLimit = messageCompressionLimit;
    }

    public int getMessageCompressionStrategy() {
        return this.messageCompressionStrategy;
    }

    public void setMessageCompressionStrategy(int messageCompressionStrategy) {
        this.messageCompressionStrategy = messageCompressionStrategy;
    }

    public int getMessageFragmentationLimit() {
        return this.messageFragmentationLimit;
    }

    public void setMessageFragmentationLimit(int messageFragmentationLimit) {
        this.messageFragmentationLimit = messageFragmentationLimit;
    }

    public boolean isCachingEnabled() {
        return this.cachingEnabled;
    }

    public void setCachingEnabled(boolean cachingEnabled) {
        this.cachingEnabled = cachingEnabled;
    }

    public boolean isPrepareMessageBodyOnSend() {
        return this.prepareMessageBodyOnSend;
    }

    public void setPrepareMessageBodyOnSend(boolean prePrepareMessageOnSend) {
        this.prepareMessageBodyOnSend = prePrepareMessageOnSend;
    }

    public void setWireFormat(WireFormat wireFormat) {
        this.wireFormat = wireFormat;
    }

    public void setWireFormat(String format) throws JMSException {
        this.wireFormat = WireFormatLoader.getWireFormat(format);
    }

    public String getBrokerXmlConfig() {
        return this.brokerXmlConfig;
    }

    public BrokerContainer getBrokerContainer() {
        return this.brokerContainer;
    }

    public void setBrokerXmlConfig(String brokerXmlConfig) {
        this.brokerXmlConfig = brokerXmlConfig;
    }

    public BrokerContainerFactory getBrokerContainerFactory() throws JMSException {
        if (this.brokerContainerFactory == null) {
            this.brokerContainerFactory = this.createBrokerContainerFactory();
        }
        return this.brokerContainerFactory;
    }

    public void setBrokerContainerFactory(BrokerContainerFactory brokerContainerFactory) {
        this.brokerContainerFactory = brokerContainerFactory;
    }

    public BrokerContext getBrokerContext() {
        return this.brokerContext;
    }

    public void setBrokerContext(BrokerContext brokerContext) {
        this.brokerContext = brokerContext;
    }

    public Connection createConnection() throws JMSException {
        return this.createConnection(this.userName, this.password);
    }

    public Connection createConnection(String userName, String password) throws JMSException {
        ActiveMQConnection connection = new ActiveMQConnection(this, userName, password, this.createTransportChannel(this.brokerURL));
        connection.setCachingEnabled(this.isCachingEnabled());
        connection.setUseAsyncSend(this.isUseAsyncSend());
        connection.setDisableTimeStampsByDefault(this.isDisableTimeStampsByDefault());
        connection.setJ2EEcompliant(this.isJ2EEcompliant());
        connection.setDoMessageCompression(this.isDoMessageCompression());
        connection.setMessageCompressionLevel(this.messageCompressionLevel);
        connection.setMessageCompressionLimit(this.getMessageCompressionLimit());
        connection.setMessageCompressionStrategy(this.getMessageCompressionStrategy());
        connection.setDoMessageFragmentation(this.isDoMessageFragmentation());
        connection.setMessageFragmentationLimit(this.getMessageFragmentationLimit());
        connection.setPrepareMessageBodyOnSend(this.isPrepareMessageBodyOnSend());
        connection.setInternalConnection(this.isInternalConnection());
        connection.setQuickClose(this.isQuickClose());
        if (this.clientID != null && this.clientID.length() > 0) {
            connection.setClientID(this.clientID);
        }
        return connection;
    }

    public QueueConnection createQueueConnection() throws JMSException {
        return this.createQueueConnection(this.userName, this.password);
    }

    public QueueConnection createQueueConnection(String userName, String password) throws JMSException {
        return (QueueConnection)this.createConnection(userName, password);
    }

    public TopicConnection createTopicConnection() throws JMSException {
        return this.createTopicConnection(this.userName, this.password);
    }

    public TopicConnection createTopicConnection(String userName, String password) throws JMSException {
        return (TopicConnection)this.createConnection(userName, password);
    }

    public void start() throws JMSException {
    }

    public synchronized void stop() throws JMSException {
        Iterator iter = this.startedEmbeddedBrokers.iterator();
        while (iter.hasNext()) {
            String uri = (String)iter.next();
            this.brokerContext.deregisterConnector(uri);
        }
        if (this.brokerContainer != null) {
            this.brokerContainer.stop();
            this.brokerContainer = null;
        }
    }

    public Broker getEmbeddedBroker() throws JMSException {
        if (this.isUseEmbeddedBroker()) {
            return this.getContainer(this.getBrokerName()).getBroker();
        }
        return null;
    }

    public static synchronized void registerBroker(String theURLString, BrokerConnector brokerConnector) {
        BrokerContext.getInstance().registerConnector(theURLString, brokerConnector);
    }

    public static synchronized void unregisterBroker(String theURLString) {
        BrokerContext.getInstance().deregisterConnector(theURLString);
    }

    protected void buildFromProperties(Properties props) {
        this.userName = props.getProperty("userName", this.userName);
        this.password = props.getProperty("password", this.password);
        this.brokerURL = props.getProperty("brokerURL", this.brokerURL);
        this.brokerName = props.getProperty("brokerName", this.brokerName);
        this.clientID = props.getProperty("clientID");
        this.useAsyncSend = this.getBoolean(props, "useAsyncSend", true);
        this.useEmbeddedBroker = this.getBoolean(props, "useEmbeddedBroker");
        this.brokerXmlConfig = props.getProperty("brokerXmlConfig", this.brokerXmlConfig);
        this.J2EEcompliant = this.getBoolean(props, "J2EEcompliant", true);
        if (props.containsKey("turboBoost")) {
            this.setTurboBoost(this.getBoolean(props, "turboBoost"));
        }
    }

    protected void populateProperties(Properties props) {
        props.put("userName", this.userName);
        props.put("password", this.password);
        props.put("brokerURL", this.brokerURL);
        props.put("brokerName", this.brokerName);
        if (this.clientID != null) {
            props.put("clientID", this.clientID);
        }
        props.put("useAsyncSend", this.useAsyncSend ? "true" : "false");
        props.put("useEmbeddedBroker", this.useEmbeddedBroker ? "true" : "false");
        props.put("J2EEcompliant", this.J2EEcompliant ? "true" : "false");
        props.put("turboBoost", this.isTurboBoost() ? "true" : "false");
        if (this.brokerXmlConfig != null) {
            props.put("brokerXmlConfig", this.brokerXmlConfig);
        }
    }

    protected boolean getBoolean(Properties props, String key) {
        return this.getBoolean(props, key, false);
    }

    protected boolean getBoolean(Properties props, String key, boolean defaultValue) {
        String value = props.getProperty(key);
        return value != null ? value.equalsIgnoreCase("true") : defaultValue;
    }

    protected BrokerContainerFactory createBrokerContainerFactory() throws JMSException {
        if (this.brokerXmlConfig != null) {
            return XmlConfigHelper.createBrokerContainerFactory(this.brokerXmlConfig);
        }
        return new BrokerContainerFactoryImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TransportChannel createTransportChannel(String theURLString) throws JMSException {
        boolean embedServer;
        URI uri = this.createURI(theURLString);
        TransportChannelFactory factory = TransportChannelProvider.getFactory(uri);
        BrokerConnector brokerConnector = null;
        boolean created = false;
        TransportChannel transportChannel = null;
        boolean bl = embedServer = this.isUseEmbeddedBroker() || factory.requiresEmbeddedBroker();
        if (embedServer) {
            ActiveMQConnectionFactory activeMQConnectionFactory = this;
            synchronized (activeMQConnectionFactory) {
                if (factory.requiresEmbeddedBroker()) {
                    transportChannel = factory.create(this.getWireFormat(), uri);
                    brokerConnector = transportChannel.getEmbeddedBrokerConnector();
                }
                if (brokerConnector == null) {
                    brokerConnector = this.brokerContext.getConnectorByURL(theURLString);
                    if (brokerConnector == null) {
                        brokerConnector = this.createBrokerConnector(theURLString);
                        this.brokerContext.registerConnector(theURLString, brokerConnector);
                        this.startedEmbeddedBrokers.add(theURLString);
                        created = true;
                    }
                } else {
                    created = true;
                }
            }
        }
        if (transportChannel == null) {
            transportChannel = factory.create(this.getWireFormat(), uri);
        }
        if (embedServer) {
            return this.ensureServerIsAvailable(uri, transportChannel, brokerConnector, created);
        }
        return transportChannel;
    }

    protected synchronized BrokerContainer getContainer(String brokerName) throws JMSException {
        if (this.brokerContainer == null) {
            this.brokerContainer = this.brokerContext.getBrokerContainerByName(brokerName, this.getBrokerContainerFactory());
        }
        return this.brokerContainer;
    }

    protected BrokerConnector createBrokerConnector(String url) throws JMSException {
        BrokerConnectorImpl brokerConnector = new BrokerConnectorImpl(this.getContainer(this.getBrokerName()), url, this.getWireFormat());
        brokerConnector.start();
        log.info((Object)"Embedded JMS Broker has started");
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            System.out.println("Caught: " + e);
            e.printStackTrace();
        }
        return brokerConnector;
    }

    protected TransportChannel ensureServerIsAvailable(URI remoteLocation, TransportChannel channel, BrokerConnector brokerConnector, boolean created) throws JMSException {
        this.ensureVmServerIsAvailable(channel, brokerConnector);
        if (channel.isMulticast()) {
            return this.ensureMulticastChannelIsAvailable(remoteLocation, channel, brokerConnector, created);
        }
        return channel;
    }

    private void ensureVmServerIsAvailable(TransportChannel channel, BrokerConnector brokerConnector) throws JMSException {
        if (channel instanceof VmTransportChannel && brokerConnector instanceof TransportChannelListener) {
            VmTransportChannel answer = (VmTransportChannel)channel;
            answer.connect(brokerConnector);
        }
    }

    protected TransportChannel ensureMulticastChannelIsAvailable(URI remoteLocation, TransportChannel channel, BrokerConnector brokerConnector, boolean created) throws JMSException {
        if (created) {
            BrokerConnectorImpl brokerImpl = (BrokerConnectorImpl)brokerConnector;
            BrokerClientImpl client = new BrokerClientImpl();
            client.initialize(brokerImpl, channel);
            channel.start();
            String brokerClientID = this.createMulticastClientID();
            channel.setClientID(brokerClientID);
            ConnectionInfo info = new ConnectionInfo();
            info.setHostName(IdGenerator.getHostName());
            info.setClientId(brokerClientID);
            info.setStarted(true);
            client.consumeConnectionInfo(info);
            ConsumerInfo consumerInfo = new ConsumerInfo();
            consumerInfo.setDestination(new ActiveMQTopic(">"));
            consumerInfo.setNoLocal(true);
            consumerInfo.setClientId(brokerClientID);
            consumerInfo.setConsumerId(this.idGenerator.generateId());
            consumerInfo.setStarted(true);
            client.consumeConsumerInfo(consumerInfo);
            consumerInfo = new ConsumerInfo();
            consumerInfo.setDestination(new ActiveMQQueue(">"));
            consumerInfo.setNoLocal(true);
            consumerInfo.setClientId(brokerClientID);
            consumerInfo.setConsumerId(this.idGenerator.generateId());
            consumerInfo.setStarted(true);
            client.consumeConsumerInfo(consumerInfo);
        }
        URI localURI = this.createURI("vm", remoteLocation);
        TransportChannel localChannel = TransportChannelProvider.create(this.getWireFormat(), localURI);
        this.ensureVmServerIsAvailable(localChannel, brokerConnector);
        return localChannel;
    }

    protected String createMulticastClientID() {
        return this.idGenerator.generateId();
    }

    protected URI createURI(String protocol, URI uri) throws JMSException {
        try {
            return new URI(protocol, uri.getRawSchemeSpecificPart(), uri.getFragment());
        }
        catch (URISyntaxException e) {
            JMSException jmsEx = new JMSException("the URL string is badly formated:", e.getMessage());
            jmsEx.setLinkedException((Exception)e);
            throw jmsEx;
        }
    }

    protected URI createURI(String uri) throws JMSException {
        try {
            if (uri == null) {
                throw new JMSException("The connection URI must be specified!");
            }
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            JMSException jmsEx = new JMSException("the URL string is badly formated:", e.getMessage());
            jmsEx.setLinkedException((Exception)e);
            throw jmsEx;
        }
    }

    synchronized void onConnectionClose(ActiveMQConnection connection) throws JMSException {
        if (--this.connectionCount <= 0) {
            this.stop();
        }
    }

    synchronized void onConnectionCreate(ActiveMQConnection connection) {
        ++this.connectionCount;
    }
}

