/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.broker.impl;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import EDU.oswego.cs.dl.util.concurrent.CopyOnWriteArrayList;
import EDU.oswego.cs.dl.util.concurrent.CopyOnWriteArraySet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jms.InvalidClientIDException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.transaction.xa.XAException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.activemq.broker.Broker;
import org.codehaus.activemq.broker.BrokerClient;
import org.codehaus.activemq.broker.BrokerConnector;
import org.codehaus.activemq.broker.BrokerContainer;
import org.codehaus.activemq.broker.BrokerContext;
import org.codehaus.activemq.broker.impl.BrokerConnectorImpl;
import org.codehaus.activemq.broker.impl.DefaultBroker;
import org.codehaus.activemq.capacity.CapacityMonitorEvent;
import org.codehaus.activemq.capacity.CapacityMonitorEventListener;
import org.codehaus.activemq.io.WireFormat;
import org.codehaus.activemq.io.impl.DefaultWireFormat;
import org.codehaus.activemq.message.ActiveMQDestination;
import org.codehaus.activemq.message.ActiveMQMessage;
import org.codehaus.activemq.message.ActiveMQXid;
import org.codehaus.activemq.message.ConnectionInfo;
import org.codehaus.activemq.message.ConsumerInfo;
import org.codehaus.activemq.message.DurableUnsubscribe;
import org.codehaus.activemq.message.MessageAck;
import org.codehaus.activemq.message.ProducerInfo;
import org.codehaus.activemq.message.SessionInfo;
import org.codehaus.activemq.security.SecurityAdapter;
import org.codehaus.activemq.service.RedeliveryPolicy;
import org.codehaus.activemq.service.Service;
import org.codehaus.activemq.store.PersistenceAdapter;
import org.codehaus.activemq.transport.DiscoveryAgent;
import org.codehaus.activemq.transport.NetworkConnector;
import org.codehaus.activemq.transport.TransportServerChannel;
import org.codehaus.activemq.util.IdGenerator;

public class BrokerContainerImpl
implements BrokerContainer,
CapacityMonitorEventListener {
    public static final String DISABLE_CLEAN_SHUTDOWN_PROPERTY = "activemq.broker.disable-clean-shutdown";
    private static final Log log = LogFactory.getLog((Class)BrokerContainerImpl.class);
    private static final boolean useLoggingForShutdownErrors = false;
    private BrokerContext context;
    private Broker broker;
    private Map clientIds;
    private Map consumerInfos;
    private Map producerInfos;
    private List transportConnectors;
    private Thread shutdownHook;
    private boolean stopped;
    private List networkConnectors;
    private DiscoveryAgent discoveryAgent;
    private Map localDiscoveryDetails;
    private Set remoteClientIds;

    public BrokerContainerImpl() {
        this(new IdGenerator().generateId());
    }

    public BrokerContainerImpl(String brokerName) {
        this(brokerName, BrokerContext.getInstance());
    }

    public BrokerContainerImpl(String brokerName, String clusterName) {
        this(brokerName, clusterName, BrokerContext.getInstance());
    }

    public BrokerContainerImpl(String brokerName, PersistenceAdapter persistenceAdapter) {
        this(brokerName, persistenceAdapter, BrokerContext.getInstance());
    }

    public BrokerContainerImpl(String brokerName, BrokerContext context) {
        this(new DefaultBroker(brokerName), context);
    }

    public BrokerContainerImpl(String brokerName, String clusterName, BrokerContext context) {
        this(new DefaultBroker(brokerName, clusterName), context);
    }

    public BrokerContainerImpl(String brokerName, PersistenceAdapter persistenceAdapter, BrokerContext context) {
        this(new DefaultBroker(brokerName, persistenceAdapter), context);
    }

    public BrokerContainerImpl(String brokerName, String clusterName, PersistenceAdapter persistenceAdapter, BrokerContext context) {
        this(new DefaultBroker(brokerName, clusterName, persistenceAdapter), context);
    }

    public BrokerContainerImpl(Broker broker, BrokerContext context) {
        this.broker = broker;
        this.context = context;
        this.clientIds = new ConcurrentHashMap();
        this.consumerInfos = new ConcurrentHashMap();
        this.producerInfos = new ConcurrentHashMap();
        this.transportConnectors = new CopyOnWriteArrayList();
        this.networkConnectors = new CopyOnWriteArrayList();
        this.remoteClientIds = new CopyOnWriteArraySet();
        this.broker.addCapacityEventListener(this);
        context.registerContainer(broker.getBrokerName(), this);
    }

    public void start() throws JMSException {
        Service connector;
        log.info((Object)("ActiveMQ 2.0 JMS Message Broker (" + this.broker.getBrokerName() + ") is starting"));
        log.info((Object)"For help or more information please see: www.protique.com");
        this.broker.start();
        this.addShutdownHook();
        Iterator iter = new ArrayList(this.networkConnectors).iterator();
        while (iter.hasNext()) {
            connector = (Service)iter.next();
            connector.start();
        }
        iter = new ArrayList(this.transportConnectors).iterator();
        while (iter.hasNext()) {
            connector = (Service)iter.next();
            connector.start();
        }
        if (this.discoveryAgent != null) {
            this.discoveryAgent.start();
            this.localDiscoveryDetails = this.createLocalDiscoveryDetails();
            this.discoveryAgent.registerService(this.getLocalBrokerName(), this.localDiscoveryDetails);
        }
        log.info((Object)("ActiveMQ JMS Message Broker (" + this.broker.getBrokerName() + ") has started"));
    }

    public synchronized void stop() throws JMSException {
        if (!this.stopped) {
            Service connector;
            this.stopped = true;
            log.info((Object)("ActiveMQ Message Broker (" + this.broker.getBrokerName() + ") is shutting down"));
            this.context.deregisterContainer(this.broker.getBrokerName(), this);
            try {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            }
            catch (Exception e) {
                log.debug((Object)("Caught exception, must be shutting down: " + e));
            }
            JMSException firstException = null;
            if (this.discoveryAgent != null) {
                try {
                    this.discoveryAgent.stop();
                }
                catch (JMSException e) {
                    firstException = e;
                    log.warn((Object)("Could not close discovery agent: " + this.discoveryAgent + " due to: " + (Object)((Object)e)), (Throwable)e);
                }
            }
            Iterator<Object> iter = new ArrayList(this.transportConnectors).iterator();
            while (iter.hasNext()) {
                connector = (Service)iter.next();
                try {
                    connector.stop();
                }
                catch (JMSException e) {
                    if (firstException == null) {
                        firstException = e;
                    }
                    log.warn((Object)("Could not close transport connector: " + connector + " due to: " + (Object)((Object)e)), (Throwable)e);
                }
            }
            this.transportConnectors.clear();
            iter = new ArrayList(this.networkConnectors).iterator();
            while (iter.hasNext()) {
                connector = (Service)iter.next();
                try {
                    connector.stop();
                }
                catch (JMSException e) {
                    if (firstException == null) {
                        firstException = e;
                    }
                    log.warn((Object)("Could not close network connector: " + connector + " due to: " + (Object)((Object)e)), (Throwable)e);
                }
            }
            this.networkConnectors.clear();
            iter = this.clientIds.values().iterator();
            while (iter.hasNext()) {
                BrokerClient client = (BrokerClient)iter.next();
                if (client == null) continue;
                try {
                    client.stop();
                }
                catch (JMSException e) {
                    if (firstException == null) {
                        firstException = e;
                    }
                    log.warn((Object)("Could not close client: " + client + " due to: " + (Object)((Object)e)), (Throwable)e);
                }
            }
            this.clientIds.clear();
            this.broker.removeCapacityEventListener(this);
            this.broker.stop();
            log.info((Object)("ActiveMQ JMS Message Broker (" + this.broker.getBrokerName() + ") stopped"));
            if (firstException != null) {
                throw firstException;
            }
        }
    }

    public void registerConnection(BrokerClient client, ConnectionInfo info) throws JMSException {
        String clientId = info.getClientId();
        if (this.clientIds.containsKey(clientId)) {
            int timeout = 5000;
            log.info((Object)("Got duplicate client with id: " + clientId + ". Giving the existing client " + timeout + " millis to prove it's alive."));
            BrokerClient existingClient = (BrokerClient)this.clientIds.get(clientId);
            JMSException ex = null;
            boolean isValid = true;
            try {
                existingClient.validateConnection(timeout);
            }
            catch (JMSException e) {
                isValid = false;
                ex = e;
            }
            if (isValid) {
                log.info((Object)("Client: " + clientId + " on transport: " + existingClient.getChannel() + "' is alive, rejecting new client on transport: " + client.getChannel()));
                throw new InvalidClientIDException("Duplicate clientId: " + info);
            }
            log.info((Object)("Replacing client: " + clientId + " on transport: " + existingClient.getChannel() + " (" + ex.getMessage() + ") with client on transport: " + client.getChannel()));
            existingClient.cleanUp();
            existingClient.stop();
        }
        this.getBroker().addClient(client, info);
        log.info((Object)("Adding new client: " + clientId + " on transport: " + client.getChannel()));
        this.clientIds.put(clientId, client);
    }

    public void deregisterConnection(BrokerClient client, ConnectionInfo info) throws JMSException {
        String clientId = client.getClientID();
        if (clientId != null) {
            Object answer = this.clientIds.remove(clientId);
            if (answer != null) {
                log.info((Object)("Removing client: " + clientId + " on transport: " + client.getChannel()));
                this.getBroker().removeClient(client, info);
            } else {
                log.warn((Object)("Got duplicate deregisterConnection for client: " + clientId));
            }
        } else {
            log.warn((Object)("No clientID available for client: " + client));
        }
    }

    public void registerMessageConsumer(BrokerClient client, ConsumerInfo info) throws JMSException {
        this.consumerInfos.put(info, client);
        this.getBroker().addMessageConsumer(client, info);
    }

    public void deregisterMessageConsumer(BrokerClient client, ConsumerInfo info) throws JMSException {
        this.consumerInfos.remove(info);
        this.getBroker().removeMessageConsumer(client, info);
    }

    public void registerMessageProducer(BrokerClient client, ProducerInfo info) throws JMSException {
        ActiveMQDestination dest = info.getDestination();
        this.checkTempDestinationExistance(dest);
        this.getBroker().addMessageProducer(client, info);
        this.producerInfos.put(info, client);
    }

    public void deregisterMessageProducer(BrokerClient client, ProducerInfo info) throws JMSException {
        this.getBroker().removeMessageProducer(client, info);
        this.producerInfos.remove(info);
    }

    public void registerSession(BrokerClient client, SessionInfo info) throws JMSException {
    }

    public void deregisterSession(BrokerClient client, SessionInfo info) throws JMSException {
    }

    public void startTransaction(BrokerClient client, String transactionId) throws JMSException {
        this.getBroker().startTransaction(client, transactionId);
    }

    public void rollbackTransaction(BrokerClient client, String transactionId) throws JMSException {
        this.getBroker().rollbackTransaction(client, transactionId);
    }

    public void commitTransaction(BrokerClient client, String transactionId) throws JMSException {
        this.getBroker().commitTransaction(client, transactionId);
    }

    public void sendMessage(BrokerClient client, ActiveMQMessage message) throws JMSException {
        ActiveMQDestination dest = message.getJMSActiveMQDestination();
        this.checkTempDestinationExistance(dest);
        this.getBroker().sendMessage(client, message);
    }

    public void registerRemoteClientID(String remoteClientID) {
        this.remoteClientIds.add(remoteClientID);
    }

    public void deregisterRemoteClientID(String remoteClientID) {
        this.remoteClientIds.remove(remoteClientID);
    }

    private void checkTempDestinationExistance(ActiveMQDestination dest) throws InvalidDestinationException {
        if (dest != null && dest.isTemporary()) {
            String clientId = ActiveMQDestination.getClientId(dest);
            if (clientId == null) {
                throw new InvalidDestinationException("Destination " + dest.getPhysicalName() + " is a temporary destination with null clientId");
            }
            if (!this.clientIds.containsKey(clientId) && !this.remoteClientIds.contains(clientId)) {
                throw new InvalidDestinationException("Destination " + dest.getPhysicalName() + " is no longer valid because the client " + clientId + " no longer exists");
            }
        }
    }

    public void acknowledgeMessage(BrokerClient client, MessageAck ack) throws JMSException {
        this.getBroker().acknowledgeMessage(client, ack);
    }

    public void durableUnsubscribe(BrokerClient client, DurableUnsubscribe ds) throws JMSException {
        this.getBroker().deleteSubscription(ds.getClientId(), ds.getSubscriberName());
    }

    public void startTransaction(BrokerClient client, ActiveMQXid xid) throws XAException {
        this.getBroker().startTransaction(client, xid);
    }

    public ActiveMQXid[] getPreparedTransactions(BrokerClient client) throws XAException {
        return this.getBroker().getPreparedTransactions(client);
    }

    public int prepareTransaction(BrokerClient client, ActiveMQXid xid) throws XAException {
        return this.getBroker().prepareTransaction(client, xid);
    }

    public void rollbackTransaction(BrokerClient client, ActiveMQXid xid) throws XAException {
        this.getBroker().rollbackTransaction(client, xid);
    }

    public void commitTransaction(BrokerClient client, ActiveMQXid xid, boolean onePhase) throws XAException {
        this.getBroker().commitTransaction(client, xid, onePhase);
    }

    public void capacityChanged(CapacityMonitorEvent event) {
        Iterator i = this.producerInfos.values().iterator();
        while (i.hasNext()) {
            BrokerClient client = (BrokerClient)i.next();
            client.updateBrokerCapacity(event.getCapacity());
        }
    }

    public List getTransportConnectors() {
        return this.transportConnectors;
    }

    public void setTransportConnectors(List transportConnectors) {
        this.transportConnectors = transportConnectors;
    }

    public void addConnector(BrokerConnector connector) {
        this.transportConnectors.add(connector);
        this.context.registerConnector(connector.getServerChannel().getUrl(), connector);
    }

    public void removeConnector(BrokerConnector connector) {
        this.transportConnectors.remove(connector);
        this.context.deregisterConnector(connector.getServerChannel().getUrl());
    }

    public void addConnector(String bindAddress) throws JMSException {
        this.addConnector(bindAddress, new DefaultWireFormat());
    }

    public void addConnector(String bindAddress, WireFormat wireFormat) throws JMSException {
        this.addConnector(new BrokerConnectorImpl(this, bindAddress, wireFormat));
    }

    public void addConnector(TransportServerChannel transportConnector) {
        this.addConnector(new BrokerConnectorImpl(this, transportConnector));
    }

    public List getNetworkConnectors() {
        return this.networkConnectors;
    }

    public void setNetworkConnectors(List networkConnectors) {
        this.networkConnectors = networkConnectors;
    }

    public NetworkConnector addNetworkConnector(String uri) {
        NetworkConnector connector = this.addNetworkConnector();
        connector.addNetworkChannel(uri);
        return connector;
    }

    public NetworkConnector addNetworkConnector() {
        NetworkConnector connector = new NetworkConnector(this);
        this.addNetworkConnector(connector);
        return connector;
    }

    public void addNetworkConnector(NetworkConnector connector) {
        this.networkConnectors.add(connector);
    }

    public void removeNetworkConnector(NetworkConnector connector) {
        this.networkConnectors.remove(connector);
    }

    public Broker getBroker() {
        return this.broker;
    }

    public PersistenceAdapter getPersistenceAdapter() {
        return this.broker != null ? this.broker.getPersistenceAdapter() : null;
    }

    public void setPersistenceAdapter(PersistenceAdapter persistenceAdapter) {
        this.checkBrokerSet();
        this.broker.setPersistenceAdapter(persistenceAdapter);
    }

    public DiscoveryAgent getDiscoveryAgent() {
        return this.discoveryAgent;
    }

    public void setDiscoveryAgent(DiscoveryAgent discoveryAgent) {
        this.discoveryAgent = discoveryAgent;
    }

    public SecurityAdapter getSecurityAdapter() {
        return this.broker != null ? this.broker.getSecurityAdapter() : null;
    }

    public void setSecurityAdapter(SecurityAdapter securityAdapter) {
        this.checkBrokerSet();
        this.broker.setSecurityAdapter(securityAdapter);
    }

    public RedeliveryPolicy getRedeliveryPolicy() {
        return this.broker != null ? this.broker.getRedeliveryPolicy() : null;
    }

    public void setRedeliveryPolicy(RedeliveryPolicy redeliveryPolicy) {
        this.checkBrokerSet();
        this.broker.setRedeliveryPolicy(redeliveryPolicy);
    }

    protected void checkBrokerSet() {
        if (this.broker == null) {
            throw new IllegalStateException("Cannot set this property as we don't have a broker yet");
        }
    }

    protected Map createLocalDiscoveryDetails() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("brokerName", this.getLocalBrokerName());
        map.put("connectURL", this.getLocalConnectionURL());
        return map;
    }

    protected String getLocalBrokerName() {
        return this.getBroker().getBrokerName();
    }

    protected String getLocalConnectionURL() {
        StringBuffer buffer = new StringBuffer("reliable:");
        List list = this.getTransportConnectors();
        boolean first = true;
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            BrokerConnector brokerConnector = (BrokerConnector)iter.next();
            TransportServerChannel connector = brokerConnector.getServerChannel();
            String url = connector.getUrl();
            if (first) {
                first = false;
            } else {
                buffer.append(",");
            }
            buffer.append(url);
        }
        return buffer.toString();
    }

    protected void addShutdownHook() {
        if (System.getProperty(DISABLE_CLEAN_SHUTDOWN_PROPERTY, "false").equals("true")) {
            return;
        }
        this.shutdownHook = new Thread("ActiveMQ ShutdownHook"){

            public void run() {
                BrokerContainerImpl.this.containerShutdown();
            }
        };
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
    }

    protected void containerShutdown() {
        try {
            this.stop();
        }
        catch (JMSException e) {
            Exception linkedException = e.getLinkedException();
            if (linkedException != null) {
                System.err.println("Failed to shut down: " + (Object)((Object)e) + ". Reason: " + linkedException);
            } else {
                System.err.println("Failed to shut down: " + (Object)((Object)e));
            }
            e.printStackTrace(System.err);
        }
        catch (Exception e) {
            System.err.println("Failed to shut down: " + e);
            e.printStackTrace(System.err);
        }
    }
}

