/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.filter;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.codehaus.activemq.filter.DestinationMapNode;
import org.codehaus.activemq.message.ActiveMQDestination;

public class DestinationMap {
    private DestinationMapNode rootNode = new DestinationMapNode();
    protected static final String ANY_DESCENDENT = ">";
    protected static final String ANY_CHILD = "*";

    public synchronized Set get(ActiveMQDestination key) {
        if (key.isComposite()) {
            List childDestinations = key.getChildDestinations();
            HashSet<Set> answer = new HashSet<Set>(childDestinations.size());
            Iterator iter = childDestinations.iterator();
            if (iter.hasNext()) {
                ActiveMQDestination childDestination = (ActiveMQDestination)iter.next();
                Set value = this.get(childDestination);
                if (value instanceof Set) {
                    answer.addAll(value);
                } else if (value != null) {
                    answer.add(value);
                }
                return answer;
            }
        }
        return this.findWildcardMatches(key);
    }

    public synchronized void put(ActiveMQDestination key, Object value) {
        if (key.isComposite()) {
            List childDestinations = key.getChildDestinations();
            Iterator iter = childDestinations.iterator();
            while (iter.hasNext()) {
                ActiveMQDestination childDestination = (ActiveMQDestination)iter.next();
                this.put(childDestination, value);
            }
            return;
        }
        String[] paths = key.getDestinationPaths();
        this.rootNode.add(paths, 0, value);
    }

    public synchronized void remove(ActiveMQDestination key, Object value) {
        if (key.isComposite()) {
            List childDestinations = key.getChildDestinations();
            Iterator iter = childDestinations.iterator();
            while (iter.hasNext()) {
                ActiveMQDestination childDestination = (ActiveMQDestination)iter.next();
                this.remove(childDestination, value);
            }
            return;
        }
        String[] paths = key.getDestinationPaths();
        this.rootNode.remove(paths, 0, value);
    }

    protected Set findWildcardMatches(ActiveMQDestination key) {
        String[] paths = key.getDestinationPaths();
        HashSet answer = new HashSet();
        this.rootNode.appendMatchingValues(answer, paths, 0);
        return answer;
    }

    public void removeAll(ActiveMQDestination key) {
        if (key.isComposite()) {
            List childDestinations = key.getChildDestinations();
            Iterator iter = childDestinations.iterator();
            while (iter.hasNext()) {
                ActiveMQDestination childDestination = (ActiveMQDestination)iter.next();
                this.removeAll(childDestination);
            }
            return;
        }
        String[] paths = key.getDestinationPaths();
        this.rootNode.removeAll(paths, 0);
    }
}

