/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.message;

import java.io.IOException;
import java.io.Serializable;
import javax.jms.JMSException;
import org.codehaus.activemq.message.Receipt;
import org.codehaus.activemq.util.SerializationHelper;

public class ResponseReceipt
extends Receipt {
    private Serializable result;
    private byte[] resultBytes;

    public int getPacketType() {
        return 25;
    }

    public Serializable getResult() throws JMSException {
        if (this.result == null) {
            if (this.resultBytes == null) {
                return null;
            }
            try {
                this.result = (Serializable)SerializationHelper.readObject(this.resultBytes);
            }
            catch (Exception e) {
                throw (JMSException)new JMSException("Invalid network mesage received.").initCause((Throwable)e);
            }
        }
        return this.result;
    }

    public void setResult(Serializable result) {
        this.result = result;
        this.resultBytes = null;
    }

    public void setResultBytes(byte[] resultBytes) {
        this.resultBytes = resultBytes;
        this.result = null;
    }

    public byte[] getResultBytes() throws IOException {
        if (this.resultBytes == null) {
            if (this.result == null) {
                return null;
            }
            this.resultBytes = SerializationHelper.writeObject(this.result);
        }
        return this.resultBytes;
    }

    public String toString() {
        return super.toString() + " ResponseReceipt{ " + "result = " + this.result + ", resultBytes = " + this.resultBytes + " }";
    }
}

