/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.transport.activeio;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.jms.JMSException;
import org.activeio.AsynchChannel;
import org.activeio.ChannelFactory;
import org.codehaus.activemq.io.WireFormat;
import org.codehaus.activemq.transport.TransportChannel;
import org.codehaus.activemq.transport.TransportChannelFactorySupport;
import org.codehaus.activemq.transport.activeio.ActiveIOTransportChannel;
import org.codehaus.activemq.transport.activeio.URIConverter;
import org.codehaus.activemq.util.JMSExceptionHelper;

public class ActiveIOTransportChannelFactory
extends TransportChannelFactorySupport {
    public TransportChannel create(WireFormat wireFormat, URI remoteLocation) throws JMSException {
        AsynchChannel asynchChannel = this.createAsynchChannel(remoteLocation);
        ActiveIOTransportChannel channel = new ActiveIOTransportChannel(wireFormat, asynchChannel);
        return this.populateProperties(channel, remoteLocation);
    }

    public TransportChannel create(WireFormat wireFormat, URI remoteLocation, URI localLocation) throws JMSException {
        AsynchChannel asynchChannel = this.createAsynchChannel(remoteLocation);
        ActiveIOTransportChannel channel = new ActiveIOTransportChannel(wireFormat, asynchChannel);
        return this.populateProperties(channel, remoteLocation);
    }

    public boolean requiresEmbeddedBroker() {
        return false;
    }

    private AsynchChannel createAsynchChannel(URI remoteLocation) throws JMSException {
        try {
            remoteLocation = URIConverter.convert(remoteLocation);
            AsynchChannel channel = new ChannelFactory().openAsynchChannel(remoteLocation);
            return channel;
        }
        catch (IOException e) {
            throw JMSExceptionHelper.newJMSException(e.getMessage(), e);
        }
        catch (URISyntaxException e) {
            throw JMSExceptionHelper.newJMSException(e.getMessage(), e);
        }
    }
}

