/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.transport.tcp;

import EDU.oswego.cs.dl.util.concurrent.BoundedBuffer;
import EDU.oswego.cs.dl.util.concurrent.BoundedChannel;
import EDU.oswego.cs.dl.util.concurrent.BoundedLinkedQueue;
import EDU.oswego.cs.dl.util.concurrent.Channel;
import EDU.oswego.cs.dl.util.concurrent.Executor;
import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.UnknownHostException;
import javax.jms.JMSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.activemq.io.WireFormat;
import org.codehaus.activemq.io.WireFormatLoader;
import org.codehaus.activemq.message.Packet;
import org.codehaus.activemq.transport.TransportChannelSupport;
import org.codehaus.activemq.transport.TransportStatusEvent;
import org.codehaus.activemq.transport.tcp.TcpBufferedOutputStream;
import org.codehaus.activemq.util.JMSExceptionHelper;

public class TcpTransportChannel
extends TransportChannelSupport
implements Runnable {
    private static final int SOCKET_BUFFER_SIZE = 65536;
    private static final Log log = LogFactory.getLog((Class)TcpTransportChannel.class);
    protected Socket socket;
    private WireFormatLoader wireFormatLoader;
    private DataOutputStream dataOut;
    private DataInputStream dataIn;
    private SynchronizedBoolean closed;
    private SynchronizedBoolean started;
    private Object outboundLock;
    private Executor executor;
    private Thread thread;
    private boolean useAsyncSend = false;
    private boolean changeTimeout = false;
    private int soTimeout = 10000;
    private BoundedChannel exceptionsList;

    protected TcpTransportChannel(WireFormat wireFormat) {
        super(wireFormat);
        this.wireFormatLoader = new WireFormatLoader(wireFormat);
        this.closed = new SynchronizedBoolean(false);
        this.started = new SynchronizedBoolean(false);
        this.exceptionsList = new BoundedLinkedQueue(10);
        this.outboundLock = new Object();
        if (this.useAsyncSend) {
            this.executor = new PooledExecutor((Channel)new BoundedBuffer(1000), 1);
        }
        super.setCachingEnabled(true);
    }

    public TcpTransportChannel(WireFormat wireFormat, URI remoteLocation) throws JMSException {
        this(wireFormat);
        try {
            this.socket = this.createSocket(remoteLocation);
            this.initialiseSocket();
        }
        catch (Exception ioe) {
            throw JMSExceptionHelper.newJMSException("Initialization of TcpTransportChannel failed. URI was: " + remoteLocation + " Reason: " + ioe, ioe);
        }
    }

    public TcpTransportChannel(WireFormat wireFormat, URI remoteLocation, URI localLocation) throws JMSException {
        this(wireFormat);
        try {
            this.socket = this.createSocket(remoteLocation, localLocation);
            this.initialiseSocket();
        }
        catch (Exception ioe) {
            throw JMSExceptionHelper.newJMSException("Initialization of TcpTransportChannel failed: " + ioe, ioe);
        }
    }

    public TcpTransportChannel(WireFormat wireFormat, Socket socket, Executor executor) throws JMSException {
        this(wireFormat);
        this.socket = socket;
        this.executor = executor;
        this.setServerSide(true);
        try {
            this.initialiseSocket();
        }
        catch (IOException ioe) {
            throw JMSExceptionHelper.newJMSException("Initialization of TcpTransportChannel failed: " + ioe, ioe);
        }
    }

    public void start() throws JMSException {
        if (this.started.commit(false, true)) {
            this.thread = new Thread((Runnable)this, this.toString());
            try {
                if (this.isServerSide()) {
                    this.thread.setDaemon(true);
                    WireFormat wf = this.wireFormatLoader.getWireFormat(this.dataIn);
                    if (wf != null) {
                        this.setWireFormat(wf);
                    }
                    this.getWireFormat().registerTransportStreams(this.dataOut, this.dataIn);
                    this.getWireFormat().initiateServerSideProtocol();
                } else {
                    this.getWireFormat().registerTransportStreams(this.dataOut, this.dataIn);
                    this.thread.setPriority(7);
                }
                this.currentWireFormat.setCachingEnabled(this.isCachingEnabled());
                this.thread.start();
                if (!this.isServerSide()) {
                    this.getWireFormat().initiateClientSideProtocol();
                }
            }
            catch (EOFException e) {
                this.doClose(e);
            }
            catch (IOException e) {
                JMSException jmsEx = new JMSException("start failed: " + e.getMessage());
                jmsEx.setLinkedException((Exception)e);
                throw jmsEx;
            }
        }
    }

    public void stop() {
        if (this.closed.commit(false, true)) {
            super.stop();
            try {
                this.stopExecutor(this.executor);
                this.dataOut.close();
                this.dataIn.close();
                this.socket.close();
            }
            catch (Exception e) {
                log.warn((Object)("Caught while closing: " + e + ". Now Closed"), (Throwable)e);
            }
        }
        this.closed.set(true);
    }

    public void forceDisconnect() {
        log.debug((Object)"Forcing disconnect");
        if (this.socket != null && this.socket.isConnected()) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void asyncSend(final Packet packet) throws JMSException {
        if (this.executor != null) {
            try {
                this.executor.execute(new Runnable(){

                    public void run() {
                        try {
                            if (!TcpTransportChannel.this.closed.get()) {
                                TcpTransportChannel.this.doAsyncSend(packet);
                            }
                        }
                        catch (JMSException e) {
                            try {
                                TcpTransportChannel.this.exceptionsList.put((Object)e);
                            }
                            catch (InterruptedException e1) {
                                log.warn((Object)("Failed to add element to exception list: " + e1));
                            }
                        }
                    }
                });
            }
            catch (InterruptedException e) {
                log.info((Object)("Caught: " + e), (Throwable)e);
            }
            try {
                JMSException e = (JMSException)((Object)this.exceptionsList.poll(0L));
                if (e != null) {
                    throw e;
                }
            }
            catch (InterruptedException e1) {
                log.warn((Object)("Failed to remove element to exception list: " + e1));
            }
        } else {
            this.doAsyncSend(packet);
        }
    }

    public boolean isMulticast() {
        return false;
    }

    public void run() {
        log.trace((Object)"TCP consumer thread starting");
        int count = 0;
        while (!this.closed.get()) {
            if (this.isServerSide() && ++count > 500) {
                count = 0;
                Thread.yield();
            }
            boolean type = false;
            try {
                Packet packet;
                if (this.changeTimeout) {
                    this.socket.setSoTimeout(this.soTimeout);
                }
                if (this.changeTimeout) {
                    this.socket.setSoTimeout(0);
                }
                if ((packet = this.getWireFormat().readPacket(this.dataIn)) == null) continue;
                this.doConsumePacket(packet);
            }
            catch (SocketTimeoutException e) {
            }
            catch (InterruptedIOException e) {
            }
            catch (IOException e) {
                this.doClose(e);
            }
        }
    }

    public String toString() {
        return "TcpTransportChannel: " + this.socket;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public boolean canProcessWireFormatVersion(int version) {
        return this.getWireFormat().canProcessWireFormatVersion(version);
    }

    public int getCurrentWireFormatVersion() {
        return this.getWireFormat().getCurrentWireFormatVersion();
    }

    public boolean isChangeTimeout() {
        return this.changeTimeout;
    }

    public void setChangeTimeout(boolean changeTimeout) {
        this.changeTimeout = changeTimeout;
    }

    public boolean isUseAsyncSend() {
        return this.useAsyncSend;
    }

    public void setUseAsyncSend(boolean useAsyncSend) {
        this.useAsyncSend = useAsyncSend;
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public void setSoTimeout(int soTimeout) {
        this.soTimeout = soTimeout;
        this.changeTimeout = true;
    }

    public void setNoDelay(boolean noDelay) {
        super.setNoDelay(noDelay);
        if (this.socket != null) {
            try {
                this.socket.setTcpNoDelay(noDelay);
            }
            catch (SocketException e) {
                log.warn((Object)"failed to set noDelay on the socket");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Packet doAsyncSend(Packet packet) throws JMSException {
        Packet response = null;
        try {
            Object object = this.outboundLock;
            synchronized (object) {
                response = this.getWireFormat().writePacket(packet, this.dataOut);
                this.dataOut.flush();
            }
        }
        catch (IOException e) {
            if (this.closed.get()) {
                log.trace((Object)("Caught exception while closed: " + e), (Throwable)e);
            }
            JMSException exception = JMSExceptionHelper.newJMSException("asyncSend failed: " + e, e);
            this.onAsyncException(exception);
            throw exception;
        }
        catch (JMSException e) {
            if (this.closed.get()) {
                log.trace((Object)("Caught exception while closed: " + (Object)((Object)e)), (Throwable)e);
            }
            throw e;
        }
        return response;
    }

    private void doClose(Exception ex) {
        if (!this.closed.get()) {
            if (!this.pendingStop) {
                this.setPendingStop(true);
                if (ex instanceof EOFException && !this.isServerSide()) {
                    log.warn((Object)"Peer closed connection", (Throwable)ex);
                } else {
                    this.onAsyncException(JMSExceptionHelper.newJMSException("Error reading socket: " + ex, ex));
                }
                this.fireStatusEvent(new TransportStatusEvent(this, 2));
            }
            this.stop();
        }
    }

    protected void initialiseSocket() throws IOException {
        this.socket.setReceiveBufferSize(65536);
        this.socket.setSendBufferSize(65536);
        this.socket.setSoTimeout(this.soTimeout);
        this.socket.setTcpNoDelay(this.isNoDelay());
        BufferedInputStream buffIn = new BufferedInputStream(this.socket.getInputStream());
        this.dataIn = new DataInputStream(buffIn);
        TcpBufferedOutputStream buffOut = new TcpBufferedOutputStream(this.socket.getOutputStream());
        this.dataOut = new DataOutputStream(buffOut);
        this.fireStatusEvent(new TransportStatusEvent(this, 1));
    }

    protected Socket createSocket(URI remoteLocation) throws UnknownHostException, IOException {
        return new Socket(remoteLocation.getHost(), remoteLocation.getPort());
    }

    protected Socket createSocket(URI remoteLocation, URI localLocation) throws IOException, UnknownHostException {
        return new Socket(remoteLocation.getHost(), remoteLocation.getPort(), InetAddress.getByName(localLocation.getHost()), localLocation.getPort());
    }
}

