/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;

public class SerializationHelper {
    public static byte[] writeObject(Object object) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(buffer);
        out.writeObject(object);
        out.close();
        return buffer.toByteArray();
    }

    public static Object readObject(byte[] data) throws IOException, ClassNotFoundException {
        ByteArrayInputStream buffer = new ByteArrayInputStream(data);
        ObjectInputStreamExt in = new ObjectInputStreamExt(buffer);
        Object answer = in.readObject();
        in.close();
        return answer;
    }

    public static Object readObject(InputStream in) throws IOException, ClassNotFoundException {
        ObjectInputStreamExt objIn = new ObjectInputStreamExt(in);
        Object result = objIn.readObject();
        return result;
    }

    public static void writeObject(OutputStream out, Object obj) throws IOException {
        ObjectOutputStream objOut = new ObjectOutputStream(out);
        objOut.writeObject(obj);
        objOut.flush();
    }

    static class ObjectInputStreamExt
    extends ObjectInputStream {
        ObjectInputStreamExt(InputStream in) throws IOException {
            super(in);
        }

        protected Class resolveClass(ObjectStreamClass v) throws ClassNotFoundException {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl != null) {
                return cl.loadClass(v.getName());
            }
            return Class.forName(v.getName());
        }
    }
}

