/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.io.impl;

import java.io.DataOutput;
import java.io.IOException;
import org.codehaus.activemq.io.impl.AbstractPacketWriter;
import org.codehaus.activemq.io.impl.DefaultWireFormat;
import org.codehaus.activemq.message.ActiveMQDestination;
import org.codehaus.activemq.message.ActiveMQXid;
import org.codehaus.activemq.message.MessageAck;
import org.codehaus.activemq.message.Packet;
import org.codehaus.activemq.util.BitArray;

public class MessageAckWriter
extends AbstractPacketWriter {
    private DefaultWireFormat wireFormat;

    MessageAckWriter(DefaultWireFormat wf) {
        this.wireFormat = wf;
    }

    MessageAckWriter() {
    }

    public int getPacketType() {
        return 15;
    }

    public void writePacket(Packet packet, DataOutput dataOut) throws IOException {
        MessageAck ack = (MessageAck)packet;
        boolean cachingEnabled = this.wireFormat != null ? this.wireFormat.isCachingEnabled() : false;
        boolean longSequence = ack.getSequenceNumber() > Integer.MAX_VALUE;
        Object[] visited = ack.getBrokersVisited();
        boolean writeVisited = visited != null && visited.length > 0;
        BitArray ba = ack.getBitArray();
        ba.reset();
        ba.set(0, ack.isReceiptRequired());
        ba.set(1, writeVisited);
        ba.set(2, ack.isMessageRead());
        ba.set(6, ack.isPartOfTransaction());
        ba.set(3, ack.isXaTransacted());
        ba.set(4, ack.isPersistent());
        ba.set(5, ack.isExpired());
        ba.set(7, ack.isExternalMessageId());
        ba.set(8, cachingEnabled);
        ba.set(9, longSequence);
        ba.writeToStream(dataOut);
        if (ack.isReceiptRequired()) {
            dataOut.writeShort(ack.getId());
        }
        if (ack.isExternalMessageId()) {
            this.writeUTF(ack.getMessageID(), dataOut);
        } else {
            if (cachingEnabled) {
                dataOut.writeShort(this.wireFormat.getWriteCachedKey(ack.getProducerKey()));
            } else {
                this.writeUTF(ack.getProducerKey(), dataOut);
            }
            if (longSequence) {
                dataOut.writeLong(ack.getSequenceNumber());
            } else {
                dataOut.writeInt((int)ack.getSequenceNumber());
            }
        }
        if (writeVisited) {
            dataOut.writeShort(visited.length);
            for (int i = 0; i < visited.length; ++i) {
                String brokerName = visited[i].toString();
                if (brokerName == null) continue;
                dataOut.writeUTF(brokerName);
            }
        }
        if (ack.isPartOfTransaction()) {
            if (cachingEnabled) {
                dataOut.writeShort(this.wireFormat.getWriteCachedKey(ack.getTransactionId()));
            } else if (ack.isXaTransacted()) {
                ActiveMQXid xid = (ActiveMQXid)ack.getTransactionId();
                xid.write(dataOut);
            } else {
                super.writeUTF((String)ack.getTransactionId(), dataOut);
            }
        }
        if (cachingEnabled) {
            dataOut.writeShort(this.wireFormat.getWriteCachedKey(ack.getConsumerId()));
            dataOut.writeShort(this.wireFormat.getWriteCachedKey(ack.getDestination()));
        } else {
            super.writeUTF(ack.getConsumerId(), dataOut);
            ActiveMQDestination.writeToStream(ack.getDestination(), dataOut);
        }
    }
}

