/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.message;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotWriteableException;
import org.codehaus.activemq.message.AbstractPacket;
import org.codehaus.activemq.message.ActiveMQDestination;
import org.codehaus.activemq.message.ActiveMQXid;
import org.codehaus.activemq.message.MessageAcknowledge;
import org.codehaus.activemq.message.util.ByteArray;
import org.codehaus.activemq.message.util.ByteArrayCompression;
import org.codehaus.activemq.service.MessageIdentity;
import org.codehaus.activemq.util.IdGenerator;

public class ActiveMQMessage
extends AbstractPacket
implements Message,
Comparable {
    static final int DEFAULT_DELIVERY_MODE = 2;
    static final int DEFAULT_PRIORITY = 4;
    static final long DEFAULT_TIME_TO_LIVE = 0L;
    static final byte EOF = 2;
    static final byte BYTES = 3;
    static final byte STRING = 4;
    static final byte BOOLEAN = 5;
    static final byte CHAR = 6;
    static final byte BYTE = 7;
    static final byte SHORT = 8;
    static final byte INT = 9;
    static final byte LONG = 10;
    static final byte FLOAT = 11;
    static final byte DOUBLE = 12;
    static final byte NULL = 13;
    public static final int CORRELATION_INDEX = 2;
    public static final int TYPE_INDEX = 3;
    public static final int BROKER_NAME_INDEX = 4;
    public static final int CLUSTER_NAME_INDEX = 5;
    public static final int TRANSACTION_ID_INDEX = 6;
    public static final int REPLY_TO_INDEX = 7;
    public static final int TIMESTAMP_INDEX = 8;
    public static final int EXPIRATION_INDEX = 9;
    public static final int REDELIVERED_INDEX = 10;
    public static final int XA_TRANS_INDEX = 11;
    public static final int CID_INDEX = 12;
    public static final int PROPERTIES_INDEX = 13;
    public static final int DISPATCHED_FROM_DLQ_INDEX = 14;
    public static final int PAYLOAD_INDEX = 15;
    public static final int EXTERNAL_MESSAGE_ID_INDEX = 16;
    public static final int MESSAGE_PART_INDEX = 17;
    public static final int CACHED_VALUES_INDEX = 18;
    public static final int CACHED_DESTINATION_INDEX = 19;
    public static final int LONG_SEQUENCE_INDEX = 20;
    private static final String DELIVERY_COUNT_NAME = "JMSXDeliveryCount";
    protected boolean readOnlyMessage;
    private String jmsMessageID;
    private String jmsClientID;
    private String jmsCorrelationID;
    private String producerKey;
    private ActiveMQDestination jmsDestination;
    private ActiveMQDestination jmsReplyTo;
    private int jmsDeliveryMode = 2;
    private boolean jmsRedelivered;
    private String jmsType;
    private long jmsExpiration;
    private int jmsPriority = 4;
    private long jmsTimestamp;
    private HashMap properties;
    private boolean readOnlyProperties;
    private String entryBrokerName;
    private String entryClusterName;
    private int[] consumerNos;
    private Object transactionId;
    private boolean xaTransacted;
    private String consumerIdentifier;
    private boolean messageConsumed;
    private boolean transientConsumed;
    private long sequenceNumber;
    private int deliveryCount = 1;
    private boolean dispatchedFromDLQ;
    private MessageAcknowledge messageAcknowledge;
    private ByteArray bodyAsBytes;
    private MessageIdentity jmsMessageIdentity;
    private short messsageHandle;
    private boolean externalMessageId;
    private boolean messagePart;
    private short numberOfParts;
    private short partNumber;
    private String parentMessageID;

    public boolean isJMSMessage() {
        return true;
    }

    public String toString() {
        return super.toString() + " ActiveMQMessage{ " + ", jmsMessageID = " + this.jmsMessageID + ", bodyAsBytes = " + this.bodyAsBytes + ", readOnlyMessage = " + this.readOnlyMessage + ", jmsClientID = '" + this.jmsClientID + "' " + ", jmsCorrelationID = '" + this.jmsCorrelationID + "' " + ", jmsDestination = " + this.jmsDestination + ", jmsReplyTo = " + this.jmsReplyTo + ", jmsDeliveryMode = " + this.jmsDeliveryMode + ", jmsRedelivered = " + this.jmsRedelivered + ", jmsType = '" + this.jmsType + "' " + ", jmsExpiration = " + this.jmsExpiration + ", jmsPriority = " + this.jmsPriority + ", jmsTimestamp = " + this.jmsTimestamp + ", properties = " + this.properties + ", readOnlyProperties = " + this.readOnlyProperties + ", entryBrokerName = '" + this.entryBrokerName + "' " + ", entryClusterName = '" + this.entryClusterName + "' " + ", consumerNos = " + this.consumerNos + ", transactionId = '" + this.transactionId + "' " + ", xaTransacted = " + this.xaTransacted + ", consumerIdentifer = '" + this.consumerIdentifier + "' " + ", messageConsumed = " + this.messageConsumed + ", transientConsumed = " + this.transientConsumed + ", sequenceNumber = " + this.sequenceNumber + ", deliveryCount = " + this.deliveryCount + ", dispatchedFromDLQ = " + this.dispatchedFromDLQ + ", messageAcknowledge = " + this.messageAcknowledge + ", jmsMessageIdentity = " + this.jmsMessageIdentity + ", producerKey = " + this.producerKey + " }";
    }

    public MessageAcknowledge getMessageAcknowledge() {
        return this.messageAcknowledge;
    }

    public void setMessageAcknowledge(MessageAcknowledge messageAcknowledge) {
        this.messageAcknowledge = messageAcknowledge;
    }

    public int getPacketType() {
        return 6;
    }

    public void setReadOnly(boolean value) {
        this.readOnlyProperties = value;
        this.readOnlyMessage = value;
    }

    public boolean isConsumerTarget(int consumerNumber) {
        if (this.consumerNos != null) {
            for (int i = 0; i < this.consumerNos.length; ++i) {
                if (this.consumerNos[i] != consumerNumber) continue;
                return true;
            }
        }
        return false;
    }

    public String getConsumerNosAsString() {
        String result = "";
        if (this.consumerNos != null) {
            for (int i = 0; i < this.consumerNos.length; ++i) {
                result = result + this.consumerNos[i] + ",";
            }
        }
        return result;
    }

    public boolean isTemporary() {
        return this.jmsDeliveryMode == 1 || this.jmsDestination != null && this.jmsDestination.isTemporary();
    }

    public int hashCode() {
        return this.getJMSMessageID() != null ? this.getJMSMessageID().hashCode() : super.hashCode();
    }

    public boolean equals(Object obj) {
        boolean result;
        boolean bl = result = obj == this;
        if (!result && obj != null && obj instanceof ActiveMQMessage) {
            ActiveMQMessage other = (ActiveMQMessage)obj;
            boolean bl2 = result = this.getJMSMessageID() == other.getJMSMessageID();
            if (!result) {
                if (this.jmsMessageID != null && this.jmsMessageID.length() > 0 || other.jmsMessageID != null && other.jmsMessageID.length() > 0) {
                    if (this.jmsMessageID != null && other.jmsMessageID != null) {
                        result = this.jmsMessageID.equals(other.jmsMessageID);
                    }
                } else {
                    result = this.getId() == other.getId();
                }
            }
        }
        return result;
    }

    public int compareTo(Object o) {
        if (o instanceof ActiveMQMessage) {
            return this.compareTo((ActiveMQMessage)o);
        }
        return -1;
    }

    public int compareTo(ActiveMQMessage that) {
        int answer = 1;
        if (that != null && this.jmsDestination != null && that.jmsDestination != null && (answer = this.jmsDestination.compareTo(that.jmsDestination)) == 0) {
            answer = this.jmsMessageID != null && that.jmsMessageID != null ? IdGenerator.compare(this.jmsMessageID, that.jmsMessageID) : 1;
        }
        return answer;
    }

    public ActiveMQMessage shallowCopy() throws JMSException {
        ActiveMQMessage other = new ActiveMQMessage();
        this.initializeOther(other);
        return other;
    }

    public ActiveMQMessage deepCopy() throws JMSException {
        return this.shallowCopy();
    }

    public boolean isExpired(long currentTime) {
        boolean result = false;
        long expiration = this.jmsExpiration;
        if (this.jmsExpiration > 0L && this.jmsExpiration < currentTime) {
            result = true;
        }
        return result;
    }

    public boolean isExpired() {
        return !this.dispatchedFromDLQ && this.jmsExpiration > 0L && this.isExpired(System.currentTimeMillis());
    }

    public boolean isAdvisory() {
        return this.jmsDestination != null && this.jmsDestination.isAdvisory();
    }

    protected void initializeOther(ActiveMQMessage other) {
        super.initializeOther(other);
        other.jmsMessageID = this.jmsMessageID;
        other.jmsClientID = this.jmsClientID;
        other.jmsCorrelationID = this.jmsCorrelationID;
        other.jmsDestination = this.jmsDestination;
        other.jmsReplyTo = this.jmsReplyTo;
        other.jmsDeliveryMode = this.jmsDeliveryMode;
        other.jmsRedelivered = this.jmsRedelivered;
        other.jmsType = this.jmsType;
        other.jmsExpiration = this.jmsExpiration;
        other.jmsPriority = this.jmsPriority;
        other.jmsTimestamp = this.jmsTimestamp;
        other.properties = this.properties != null ? new HashMap(this.properties) : null;
        other.readOnlyProperties = this.readOnlyProperties;
        other.readOnlyMessage = this.readOnlyMessage;
        other.entryBrokerName = this.entryBrokerName;
        other.entryClusterName = this.entryClusterName;
        other.consumerNos = this.consumerNos;
        other.transactionId = this.transactionId;
        other.xaTransacted = this.xaTransacted;
        other.bodyAsBytes = this.bodyAsBytes;
        other.messageAcknowledge = this.messageAcknowledge;
        other.jmsMessageIdentity = this.jmsMessageIdentity;
        other.sequenceNumber = this.sequenceNumber;
        other.deliveryCount = this.deliveryCount;
        other.dispatchedFromDLQ = this.dispatchedFromDLQ;
        other.messsageHandle = this.messsageHandle;
        other.consumerIdentifier = this.consumerIdentifier;
        other.externalMessageId = this.externalMessageId;
        other.producerKey = this.producerKey;
        other.messagePart = this.messagePart;
        other.numberOfParts = this.numberOfParts;
        other.partNumber = this.partNumber;
        other.parentMessageID = this.parentMessageID;
    }

    public String getJMSMessageID() {
        if (this.jmsMessageID == null && this.producerKey != null) {
            this.jmsMessageID = this.producerKey + this.sequenceNumber;
        }
        return this.jmsMessageID;
    }

    public void setJMSMessageID(String id) {
        this.jmsMessageID = id;
        this.jmsMessageIdentity = null;
    }

    public long getJMSTimestamp() {
        return this.jmsTimestamp;
    }

    public void setJMSTimestamp(long timestamp) {
        this.jmsTimestamp = timestamp;
    }

    public byte[] getJMSCorrelationIDAsBytes() {
        return this.jmsCorrelationID != null ? this.jmsCorrelationID.getBytes() : null;
    }

    public void setJMSCorrelationIDAsBytes(byte[] correlationID) {
        this.jmsCorrelationID = correlationID == null ? null : new String(correlationID);
    }

    public void setJMSCorrelationID(String correlationID) {
        this.jmsCorrelationID = correlationID;
    }

    public String getJMSCorrelationID() {
        return this.jmsCorrelationID;
    }

    public Destination getJMSReplyTo() {
        return this.jmsReplyTo;
    }

    public void setJMSReplyTo(Destination replyTo) {
        this.jmsReplyTo = (ActiveMQDestination)replyTo;
    }

    public Destination getJMSDestination() {
        return this.jmsDestination;
    }

    public void setJMSDestination(Destination destination) {
        this.jmsDestination = (ActiveMQDestination)destination;
    }

    public int getJMSDeliveryMode() {
        return this.jmsDeliveryMode;
    }

    public void setJMSDeliveryMode(int deliveryMode) {
        this.jmsDeliveryMode = deliveryMode;
    }

    public boolean getJMSRedelivered() {
        return this.jmsRedelivered;
    }

    public void setJMSRedelivered(boolean redelivered) {
        this.jmsRedelivered = redelivered;
    }

    public String getJMSType() {
        return this.jmsType;
    }

    public void setJMSType(String type) {
        this.jmsType = type;
    }

    public long getJMSExpiration() {
        return this.jmsExpiration;
    }

    public void setJMSExpiration(long expiration) {
        this.jmsExpiration = expiration;
    }

    public int getJMSPriority() {
        return this.jmsPriority;
    }

    public void setJMSPriority(int priority) {
        this.jmsPriority = priority;
    }

    public synchronized void clearProperties() {
        if (this.properties != null) {
            this.properties.clear();
        }
        this.readOnlyProperties = false;
    }

    public boolean propertyExists(String name) {
        return this.properties != null ? this.properties.containsKey(name) : false;
    }

    public boolean getBooleanProperty(String name) throws JMSException {
        return this.vanillaToBoolean(this.properties, name);
    }

    public byte getByteProperty(String name) throws JMSException {
        return this.vanillaToByte(this.properties, name);
    }

    public short getShortProperty(String name) throws JMSException {
        return this.vanillaToShort(this.properties, name);
    }

    public int getIntProperty(String name) throws JMSException {
        return this.vanillaToInt(this.properties, name);
    }

    public long getLongProperty(String name) throws JMSException {
        return this.vanillaToLong(this.properties, name);
    }

    public float getFloatProperty(String name) throws JMSException {
        return this.vanillaToFloat(this.properties, name);
    }

    public double getDoubleProperty(String name) throws JMSException {
        return this.vanillaToDouble(this.properties, name);
    }

    public String getStringProperty(String name) throws JMSException {
        return this.vanillaToString(this.properties, name);
    }

    public Object getObjectProperty(String name) {
        return this.properties != null ? this.properties.get(name) : null;
    }

    public Enumeration getPropertyNames() {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        return Collections.enumeration(this.properties.keySet());
    }

    public HashMap getProperties() {
        return this.properties;
    }

    public void setProperties(HashMap newProperties) {
        this.properties = newProperties;
    }

    public void setBooleanProperty(String name, boolean value) throws JMSException {
        this.prepareProperty(name);
        this.properties.put(name, value ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setByteProperty(String name, byte value) throws JMSException {
        this.prepareProperty(name);
        this.properties.put(name, new Byte(value));
    }

    public void setShortProperty(String name, short value) throws JMSException {
        this.prepareProperty(name);
        this.properties.put(name, new Short(value));
    }

    public void setIntProperty(String name, int value) throws JMSException {
        this.prepareProperty(name);
        this.properties.put(name, new Integer(value));
    }

    public void setLongProperty(String name, long value) throws JMSException {
        this.prepareProperty(name);
        this.properties.put(name, new Long(value));
    }

    public void setFloatProperty(String name, float value) throws JMSException {
        this.prepareProperty(name);
        this.properties.put(name, new Float(value));
    }

    public void setDoubleProperty(String name, double value) throws JMSException {
        this.prepareProperty(name);
        this.properties.put(name, new Double(value));
    }

    public void setStringProperty(String name, String value) throws JMSException {
        this.prepareProperty(name);
        if (value == null) {
            this.properties.remove(name);
        } else {
            this.properties.put(name, value);
        }
    }

    public void setObjectProperty(String name, Object value) throws JMSException {
        this.prepareProperty(name);
        if (value == null) {
            this.properties.remove(name);
        } else if (value instanceof Number || value instanceof Character || value instanceof Boolean || value instanceof String) {
            this.properties.put(name, value);
        } else {
            throw new MessageFormatException("Cannot set property to type: " + value.getClass().getName());
        }
    }

    public void acknowledge() throws JMSException {
        if (this.messageAcknowledge != null) {
            this.messageAcknowledge.acknowledge(this);
        }
    }

    public void clearBody() throws JMSException {
        this.readOnlyMessage = false;
        this.bodyAsBytes = null;
    }

    boolean vanillaToBoolean(HashMap table, String name) throws JMSException {
        boolean result = false;
        Object value = this.getVanillaProperty(table, name);
        if (value != null) {
            if (value instanceof Boolean) {
                result = (Boolean)value;
            } else if (value instanceof String) {
                result = Boolean.valueOf((String)value);
            } else {
                throw new MessageFormatException(name + " not a Boolean type");
            }
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    byte vanillaToByte(HashMap table, String name) throws JMSException {
        byte result = 0;
        Object value = this.getVanillaProperty(table, name);
        if (value == null) throw new NumberFormatException("Cannot interpret null as a Byte");
        if (value instanceof Byte) {
            return (Byte)value;
        }
        if (!(value instanceof String)) throw new MessageFormatException(name + " not a Byte type");
        return Byte.valueOf((String)value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    short vanillaToShort(HashMap table, String name) throws JMSException {
        short result = 0;
        Object value = this.getVanillaProperty(table, name);
        if (value == null) throw new NumberFormatException(name + " is null");
        if (value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof String) {
            return Short.valueOf((String)value);
        }
        if (!(value instanceof Byte)) throw new MessageFormatException(name + " not a Short type");
        return ((Byte)value).byteValue();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    int vanillaToInt(HashMap table, String name) throws JMSException {
        int result = 0;
        Object value = this.getVanillaProperty(table, name);
        if (value == null) throw new NumberFormatException(name + " is null");
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            return Integer.valueOf((String)value);
        }
        if (value instanceof Byte) {
            return ((Byte)value).intValue();
        }
        if (!(value instanceof Short)) throw new MessageFormatException(name + " not an Integer type");
        return ((Short)value).intValue();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    long vanillaToLong(HashMap table, String name) throws JMSException {
        long result = 0L;
        Object value = this.getVanillaProperty(table, name);
        if (value == null) throw new NumberFormatException(name + " is null");
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof String) {
            return Long.valueOf((String)value);
        }
        if (value instanceof Byte) {
            return ((Byte)value).byteValue();
        }
        if (value instanceof Short) {
            return ((Short)value).shortValue();
        }
        if (!(value instanceof Integer)) throw new MessageFormatException(name + " not a Long type");
        return ((Integer)value).intValue();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    float vanillaToFloat(HashMap table, String name) throws JMSException {
        float result = 0.0f;
        Object value = this.getVanillaProperty(table, name);
        if (value == null) throw new NullPointerException(name + " is null");
        if (value instanceof Float) {
            return ((Float)value).floatValue();
        }
        if (!(value instanceof String)) throw new MessageFormatException(name + " not a Float type: " + value.getClass());
        return Float.valueOf((String)value).floatValue();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    double vanillaToDouble(HashMap table, String name) throws JMSException {
        double result = 0.0;
        Object value = this.getVanillaProperty(table, name);
        if (value == null) throw new NullPointerException(name + " is null");
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof String) {
            return Double.valueOf((String)value);
        }
        if (!(value instanceof Float)) throw new MessageFormatException(name + " not a Double type");
        return ((Float)value).floatValue();
    }

    Object getVanillaProperty(HashMap table, String name) {
        Object result = null;
        if (name == null) {
            throw new NullPointerException("name supplied is null");
        }
        result = this.getReservedProperty(name);
        if (result == null && table != null) {
            result = table.get(name);
        }
        return result;
    }

    Object getReservedProperty(String name) {
        Integer result = null;
        if (name != null && name.equals(DELIVERY_COUNT_NAME)) {
            result = new Integer(this.deliveryCount);
        }
        return result;
    }

    String vanillaToString(HashMap table, String name) throws JMSException {
        Object value;
        String result = null;
        if (table != null && (value = table.get(name)) != null) {
            if (value instanceof String || value instanceof Number || value instanceof Boolean) {
                result = value.toString();
            } else {
                throw new MessageFormatException(name + " not a String type");
            }
        }
        return result;
    }

    private void prepareProperty(String name) throws JMSException {
        if (name == null) {
            throw new IllegalArgumentException("Invalid property name: cannot be null");
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("Invalid property name: cannot be empty");
        }
        if (this.readOnlyProperties) {
            throw new MessageNotWriteableException("Properties are read-only");
        }
        if (this.properties == null) {
            this.properties = new HashMap();
        }
    }

    public String getEntryBrokerName() {
        return this.entryBrokerName;
    }

    public void setEntryBrokerName(String newEntryBrokerName) {
        this.entryBrokerName = newEntryBrokerName;
    }

    public String getEntryClusterName() {
        return this.entryClusterName;
    }

    public void setEntryClusterName(String newEntryClusterName) {
        this.entryClusterName = newEntryClusterName;
    }

    public int[] getConsumerNos() {
        return this.consumerNos;
    }

    public void setConsumerNos(int[] newConsumerNos) {
        this.consumerNos = newConsumerNos;
    }

    public String getJMSClientID() {
        return this.jmsClientID;
    }

    public void setJMSClientID(String newJmsClientID) {
        this.jmsClientID = newJmsClientID;
    }

    public boolean isPartOfTransaction() {
        return this.transactionId != null;
    }

    public Object getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(Object newTransactionId) {
        this.transactionId = newTransactionId;
        this.xaTransacted = newTransactionId != null && newTransactionId.getClass() == ActiveMQXid.class;
    }

    public String getConsumerIdentifer() {
        return this.consumerIdentifier;
    }

    public void setConsumerIdentifer(String consId) {
        this.consumerIdentifier = consId;
    }

    public boolean isMessageConsumed() {
        return this.messageConsumed;
    }

    public void setMessageConsumed(boolean messageConsumed) {
        this.messageConsumed = messageConsumed;
    }

    public void prepareMessageBody() throws JMSException {
    }

    public final void convertBodyToBytes() throws IOException {
        if (this.bodyAsBytes == null) {
            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
            DataOutputStream dataOut = new DataOutputStream(bytesOut);
            this.writeBody(dataOut);
            dataOut.flush();
            this.bodyAsBytes = new ByteArray(bytesOut.toByteArray());
            dataOut.close();
        }
    }

    public final void buildBodyFromBytes() throws IOException {
        if (this.bodyAsBytes != null) {
            if (ByteArrayCompression.isCompressed(this.bodyAsBytes)) {
                ByteArrayCompression compression = new ByteArrayCompression();
                this.bodyAsBytes = compression.inflate(this.bodyAsBytes);
            }
            ByteArrayInputStream bytesIn = new ByteArrayInputStream(this.bodyAsBytes.getBuf(), this.bodyAsBytes.getOffset(), this.bodyAsBytes.getLength());
            DataInputStream dataIn = new DataInputStream(bytesIn);
            this.readBody(dataIn);
            dataIn.close();
        }
    }

    public void writeBody(DataOutput dataOut) throws IOException {
    }

    public void readBody(DataInput dataIn) throws IOException {
    }

    public ByteArray getBodyAsBytes() throws IOException {
        if (this.bodyAsBytes == null) {
            this.convertBodyToBytes();
        }
        return this.bodyAsBytes;
    }

    public ByteArray getBodyAsBytes(ByteArrayCompression compression) throws IOException {
        this.bodyAsBytes = compression.deflate(this.getBodyAsBytes());
        return this.bodyAsBytes;
    }

    public boolean isBodyConvertedToBytes() {
        return this.bodyAsBytes != null;
    }

    public void setBodyAsBytes(byte[] data, int offset, int length) {
        this.bodyAsBytes = new ByteArray(data);
    }

    public void setBodyAsBytes(ByteArray ba) {
        this.bodyAsBytes = ba;
    }

    public void writeMapProperties(HashMap table, DataOutput dataOut) throws IOException {
        if (table != null) {
            dataOut.writeShort(table.size());
            Iterator iter = table.keySet().iterator();
            while (iter.hasNext()) {
                Serializable v;
                String key = iter.next().toString();
                dataOut.writeUTF(key);
                Object value = table.get(key);
                if (value == null) {
                    dataOut.write(13);
                    continue;
                }
                if (value instanceof byte[]) {
                    byte[] data = (byte[])value;
                    dataOut.write(3);
                    if (data != null) {
                        dataOut.writeInt(data.length);
                        dataOut.write(data);
                        continue;
                    }
                    dataOut.writeInt(-1);
                    continue;
                }
                if (value instanceof Byte) {
                    dataOut.write(7);
                    v = (Byte)value;
                    dataOut.writeByte(((Byte)v).byteValue());
                    continue;
                }
                if (value instanceof Boolean) {
                    dataOut.write(5);
                    v = (Boolean)value;
                    dataOut.writeBoolean((Boolean)v);
                    continue;
                }
                if (value instanceof String) {
                    dataOut.write(4);
                    dataOut.writeUTF(value.toString());
                    continue;
                }
                if (value instanceof Character) {
                    dataOut.write(6);
                    v = (Character)value;
                    dataOut.writeChar(((Character)v).charValue());
                    continue;
                }
                if (value instanceof Number) {
                    v = (Number)value;
                    if (value instanceof Long) {
                        dataOut.write(10);
                        dataOut.writeLong(((Number)v).longValue());
                        continue;
                    }
                    if (value instanceof Integer) {
                        dataOut.write(9);
                        dataOut.writeInt(((Number)v).intValue());
                        continue;
                    }
                    if (value instanceof Short) {
                        dataOut.write(8);
                        dataOut.writeShort(((Number)v).shortValue());
                        continue;
                    }
                    if (value instanceof Float) {
                        dataOut.write(11);
                        dataOut.writeFloat(((Number)v).floatValue());
                        continue;
                    }
                    if (!(value instanceof Double)) continue;
                    dataOut.write(12);
                    dataOut.writeDouble(((Number)v).doubleValue());
                    continue;
                }
                throw new RuntimeException("Do not know how to parse value of type: " + value.getClass());
            }
        } else {
            dataOut.writeShort(-1);
        }
    }

    public HashMap readMapProperties(DataInput dataIn) throws IOException {
        HashMap<String, Byte> result = null;
        int size = dataIn.readShort();
        if (size > -1) {
            result = new HashMap<String, Byte>();
            for (int i = 0; i < size; ++i) {
                String key = dataIn.readUTF();
                Object value = null;
                byte type = dataIn.readByte();
                if (type == 13) {
                    value = null;
                } else if (type == 3) {
                    byte[] data = null;
                    int dataSize = dataIn.readInt();
                    if (dataSize > -1) {
                        data = new byte[dataSize];
                        dataIn.readFully(data);
                    }
                    value = data;
                } else if (type == 7) {
                    value = new Byte(dataIn.readByte());
                } else if (type == 5) {
                    value = dataIn.readBoolean() ? Boolean.TRUE : Boolean.FALSE;
                } else if (type == 4) {
                    value = dataIn.readUTF();
                } else if (type == 6) {
                    value = new Character(dataIn.readChar());
                } else if (type == 10) {
                    value = new Long(dataIn.readLong());
                } else if (type == 9) {
                    value = new Integer(dataIn.readInt());
                } else if (type == 8) {
                    value = new Short(dataIn.readShort());
                } else if (type == 11) {
                    value = new Float(dataIn.readFloat());
                } else if (type == 12) {
                    value = new Double(dataIn.readDouble());
                } else {
                    throw new RuntimeException("Do not know how to parse type: " + type);
                }
                result.put(key, (Byte)value);
            }
        }
        return result;
    }

    public boolean isXaTransacted() {
        return this.xaTransacted;
    }

    public ActiveMQDestination getJMSActiveMQDestination() {
        return this.jmsDestination;
    }

    public MessageIdentity getJMSMessageIdentity() {
        if (this.jmsMessageIdentity == null) {
            this.jmsMessageIdentity = new MessageIdentity(this.getJMSMessageID());
        }
        return this.jmsMessageIdentity;
    }

    public void setJMSMessageIdentity(MessageIdentity messageIdentity) {
        this.jmsMessageIdentity = messageIdentity;
    }

    public boolean isEntryBroker(String brokerName) {
        boolean result = this.entryBrokerName != null && brokerName != null && this.entryBrokerName.equals(brokerName);
        return result;
    }

    public boolean isEntryCluster(String clusterName) {
        boolean result = this.entryClusterName != null && clusterName != null && this.entryClusterName.equals(clusterName);
        return result;
    }

    public boolean isTransientConsumed() {
        return this.transientConsumed;
    }

    public void setTransientConsumed(boolean transientConsumed) {
        this.transientConsumed = transientConsumed;
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(long sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public int getDeliveryCount() {
        return this.deliveryCount;
    }

    public void setDeliveryCount(int deliveryCount) {
        this.deliveryCount = deliveryCount;
    }

    public int incrementDeliveryCount() {
        return ++this.deliveryCount;
    }

    public boolean isPersistent() {
        return this.jmsDeliveryMode == 2;
    }

    public boolean isDispatchedFromDLQ() {
        return this.dispatchedFromDLQ;
    }

    public void setDispatchedFromDLQ(boolean dispatchedFromDLQ) {
        this.dispatchedFromDLQ = dispatchedFromDLQ;
    }

    public short getMesssageHandle() {
        return this.messsageHandle;
    }

    public void setMesssageHandle(short messsageHandle) {
        this.messsageHandle = messsageHandle;
    }

    public boolean isExternalMessageId() {
        return this.externalMessageId;
    }

    public void setExternalMessageId(boolean externalMessageId) {
        this.externalMessageId = externalMessageId;
    }

    public String getProducerKey() {
        return this.producerKey;
    }

    public void setProducerKey(String producerKey) {
        this.producerKey = producerKey;
    }

    public void resetMessagePart() {
        this.messagePart = false;
        this.partNumber = 0;
        this.parentMessageID = null;
    }

    public boolean isMessagePart() {
        return this.messagePart;
    }

    public boolean isLastMessagePart() {
        return this.numberOfParts - 1 == this.partNumber;
    }

    public void setMessagePart(boolean messagePart) {
        this.messagePart = messagePart;
    }

    public short getNumberOfParts() {
        return this.numberOfParts;
    }

    public void setNumberOfParts(short numberOfParts) {
        this.numberOfParts = numberOfParts;
    }

    public short getPartNumber() {
        return this.partNumber;
    }

    public void setPartNumber(short partNumber) {
        this.partNumber = partNumber;
    }

    public String getParentMessageID() {
        return this.parentMessageID;
    }

    public void setParentMessageID(String parentMessageId) {
        this.parentMessageID = parentMessageId;
    }
}

