/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.message;

import org.codehaus.activemq.message.AbstractPacket;
import org.codehaus.activemq.message.ActiveMQDestination;
import org.codehaus.activemq.message.ActiveMQXid;
import org.codehaus.activemq.service.MessageIdentity;

public class MessageAck
extends AbstractPacket {
    public static final int MESSAGE_READ_INDEX = 2;
    public static final int XA_TRANS_INDEX = 3;
    public static final int PERSISTENT_INDEX = 4;
    public static final int EXPIRED_INDEX = 5;
    public static final int TRANSACTION_ID_INDEX = 6;
    public static final int EXTERNAL_MESSAGE_ID_INDEX = 7;
    public static final int CACHED_VALUES_INDEX = 8;
    public static final int LONG_SEQUENCE_INDEX = 9;
    private String consumerId;
    private String messageID;
    private ActiveMQDestination destination;
    private Object transactionId;
    private boolean messageRead;
    private boolean xaTransacted;
    private boolean persistent;
    private boolean expired;
    private short sessionId;
    private long sequenceNumber;
    private String producerKey;
    private boolean externalMessageId;
    private transient MessageIdentity messageIdentity;

    public int getPacketType() {
        return 15;
    }

    public String toString() {
        return super.toString() + " MessageAck{ " + "consumerId = '" + this.consumerId + "' " + ", messageID = '" + this.messageID + "' " + ", destination = " + this.destination + ", transactionId = '" + this.transactionId + "' " + ", messageRead = " + this.messageRead + ", xaTransacted = " + this.xaTransacted + ", persistent = " + this.persistent + ", expired = " + this.expired + ", messageIdentity = " + this.messageIdentity + " }";
    }

    public Object getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(Object newTransactionId) {
        this.transactionId = newTransactionId;
        this.xaTransacted = newTransactionId != null && newTransactionId.getClass() == ActiveMQXid.class;
    }

    public boolean isPartOfTransaction() {
        return this.transactionId != null;
    }

    public String getMessageID() {
        if (this.messageID == null && this.producerKey != null) {
            this.messageID = this.producerKey + this.sequenceNumber;
        }
        return this.messageID;
    }

    public void setMessageID(String messageID) {
        this.messageID = messageID;
        this.messageIdentity = null;
    }

    public boolean isMessageRead() {
        return this.messageRead;
    }

    public void setMessageRead(boolean messageRead) {
        this.messageRead = messageRead;
    }

    public String getConsumerId() {
        return this.consumerId;
    }

    public void setConsumerId(String consumerId) {
        this.consumerId = consumerId;
    }

    public boolean isXaTransacted() {
        return this.xaTransacted;
    }

    public MessageIdentity getMessageIdentity() {
        if (this.messageIdentity == null) {
            this.messageIdentity = new MessageIdentity(this.getMessageID());
        }
        return this.messageIdentity;
    }

    public ActiveMQDestination getDestination() {
        return this.destination;
    }

    public void setDestination(ActiveMQDestination destination) {
        this.destination = destination;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    public boolean isTemporary() {
        return !this.persistent || this.destination != null && this.destination.isTemporary();
    }

    public boolean isExpired() {
        return this.expired;
    }

    public void setExpired(boolean expired) {
        this.expired = expired;
    }

    public String getProducerKey() {
        return this.producerKey;
    }

    public void setProducerKey(String producerKey) {
        this.producerKey = producerKey;
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(long messageSequence) {
        this.sequenceNumber = messageSequence;
    }

    public short getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(short sessionId) {
        this.sessionId = sessionId;
    }

    public boolean isExternalMessageId() {
        return this.externalMessageId;
    }

    public void setExternalMessageId(boolean externalMessageId) {
        this.externalMessageId = externalMessageId;
    }
}

