/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.store.vm;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.jms.JMSException;
import org.codehaus.activemq.message.ActiveMQMessage;
import org.codehaus.activemq.message.ConsumerInfo;
import org.codehaus.activemq.service.MessageContainer;
import org.codehaus.activemq.service.MessageIdentity;
import org.codehaus.activemq.service.SubscriberEntry;
import org.codehaus.activemq.service.Subscription;
import org.codehaus.activemq.store.TopicMessageStore;
import org.codehaus.activemq.store.vm.VMMessageStore;

public class VMTopicMessageStore
extends VMMessageStore
implements TopicMessageStore {
    private static final Integer ONE = new Integer(1);
    private Map ackDatabase;
    private Map messageCounts;
    private Map subscriberDatabase;
    private MessageContainer container;

    public VMTopicMessageStore() {
        this(new LinkedHashMap(), VMTopicMessageStore.makeMap(), VMTopicMessageStore.makeMap(), VMTopicMessageStore.makeMap());
    }

    public VMTopicMessageStore(LinkedHashMap messageTable, Map subscriberDatabase, Map ackDatabase, Map messageCounts) {
        super(messageTable);
        this.subscriberDatabase = subscriberDatabase;
        this.ackDatabase = ackDatabase;
        this.messageCounts = messageCounts;
    }

    public void setMessageContainer(MessageContainer container) {
        this.container = container;
    }

    public synchronized void incrementMessageCount(MessageIdentity messageId) throws JMSException {
        Integer number = (Integer)this.messageCounts.get(messageId.getMessageID());
        number = number == null ? ONE : new Integer(number + 1);
        this.messageCounts.put(messageId.getMessageID(), number);
    }

    public synchronized void decrementMessageCountAndMaybeDelete(MessageIdentity msgId) throws JMSException {
        Integer number = (Integer)this.messageCounts.get(msgId.getMessageID());
        if (number == null || number <= 1) {
            this.removeMessage(msgId);
            if (number != null) {
                this.messageCounts.remove(msgId.getMessageID());
            }
        } else {
            this.messageCounts.put(msgId.getMessageID(), new Integer(number - 1));
            number = ONE;
        }
    }

    public void setLastAcknowledgedMessageIdentity(String subscription, MessageIdentity messageIdentity) throws JMSException {
        this.ackDatabase.put(subscription, messageIdentity);
    }

    public synchronized void recoverSubscription(Subscription subscription, MessageIdentity lastDispatchedMessage) throws JMSException {
        HashMap map = new HashMap(this.messageTable);
        boolean alreadyAcked = true;
        MessageIdentity lastAcked = (MessageIdentity)this.ackDatabase.get(subscription.getPersistentKey());
        Iterator i = map.values().iterator();
        while (i.hasNext()) {
            ActiveMQMessage msg = (ActiveMQMessage)i.next();
            if (lastAcked == null || !alreadyAcked) {
                subscription.addMessage(this.container, msg);
            }
            if (lastAcked == null || !lastAcked.getMessageID().equals(msg.getJMSMessageID())) continue;
            alreadyAcked = false;
        }
    }

    public MessageIdentity getLastestMessageIdentity() throws JMSException {
        return this.lastMessageIdentity;
    }

    public SubscriberEntry getSubscriberEntry(ConsumerInfo info) throws JMSException {
        String key = info.getConsumerKey();
        return (SubscriberEntry)this.subscriberDatabase.get(key);
    }

    public void setSubscriberEntry(ConsumerInfo info, SubscriberEntry subscriberEntry) throws JMSException {
        this.subscriberDatabase.put(info.getConsumerKey(), subscriberEntry);
    }

    public void stop() throws JMSException {
    }

    protected static Map makeMap() {
        return Collections.synchronizedMap(new HashMap());
    }

    public void deleteSubscription(String sub) {
        this.ackDatabase.remove(sub);
    }
}

