/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.store.journal;

import java.util.HashMap;
import java.util.Iterator;
import javax.jms.JMSException;
import org.activeio.journal.RecordLocation;
import org.activemq.message.ConsumerInfo;
import org.activemq.service.MessageContainer;
import org.activemq.service.MessageIdentity;
import org.activemq.service.SubscriberEntry;
import org.activemq.store.RecoveryListener;
import org.activemq.store.TopicMessageStore;
import org.activemq.store.journal.JournalMessageStore;
import org.activemq.store.journal.JournalPersistenceAdapter;
import org.activemq.util.Callback;

public class JournalTopicMessageStore
extends JournalMessageStore
implements TopicMessageStore {
    private MessageContainer messageContainer;
    private TopicMessageStore longTermStore;
    private HashMap ackedLastAckLocations = new HashMap();
    private RecordLocation nextMark;

    public JournalTopicMessageStore(JournalPersistenceAdapter adapter, TopicMessageStore checkpointStore, String destinationName) {
        super(adapter, checkpointStore, destinationName);
        this.longTermStore = checkpointStore;
    }

    public void recoverSubscription(String subscriptionId, MessageIdentity lastDispatchedMessage, RecoveryListener listener) throws JMSException {
        this.longTermStore.recoverSubscription(subscriptionId, lastDispatchedMessage, listener);
    }

    public SubscriberEntry getSubscriberEntry(ConsumerInfo info) throws JMSException {
        return this.longTermStore.getSubscriberEntry(info);
    }

    public void setSubscriberEntry(ConsumerInfo info, SubscriberEntry subscriberEntry) throws JMSException {
        this.longTermStore.setSubscriberEntry(info, subscriberEntry);
    }

    public MessageIdentity getLastestMessageIdentity() throws JMSException {
        return this.longTermStore.getLastestMessageIdentity();
    }

    public void incrementMessageCount(MessageIdentity messageId) throws JMSException {
        this.longTermStore.incrementMessageCount(messageId);
    }

    public void decrementMessageCountAndMaybeDelete(MessageIdentity messageId) throws JMSException {
        this.longTermStore.decrementMessageCountAndMaybeDelete(messageId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLastAcknowledgedMessageIdentity(String subscription, MessageIdentity messageIdentity) throws JMSException {
        RecordLocation location = this.peristenceAdapter.writePacket(this.destinationName, subscription, messageIdentity, false);
        JournalTopicMessageStore journalTopicMessageStore = this;
        synchronized (journalTopicMessageStore) {
            this.nextMark = location;
            this.ackedLastAckLocations.put(subscription, messageIdentity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordLocation checkpoint() throws JMSException {
        HashMap cpAckedLastAckLocations;
        RecordLocation rc = super.checkpoint();
        JournalTopicMessageStore journalTopicMessageStore = this;
        synchronized (journalTopicMessageStore) {
            if (rc == null || this.nextMark != null && rc.compareTo((Object)this.nextMark) < 0) {
                rc = this.nextMark;
            }
            cpAckedLastAckLocations = this.ackedLastAckLocations;
            this.nextMark = null;
            this.ackedLastAckLocations = new HashMap();
        }
        this.transactionTemplate.run(new Callback(){

            public void execute() throws Throwable {
                Iterator iterator = cpAckedLastAckLocations.keySet().iterator();
                while (iterator.hasNext()) {
                    String subscription = (String)iterator.next();
                    MessageIdentity identity = (MessageIdentity)cpAckedLastAckLocations.get(subscription);
                    JournalTopicMessageStore.this.longTermStore.setLastAcknowledgedMessageIdentity(subscription, identity);
                }
            }
        });
        return rc;
    }

    public TopicMessageStore getLongTermTopicMessageStore() {
        return this.longTermStore;
    }

    public void deleteSubscription(String subscription) throws JMSException {
        this.longTermStore.deleteSubscription(subscription);
    }
}

