/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.transport.tcp;

import EDU.oswego.cs.dl.util.concurrent.Executor;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URI;
import javax.jms.JMSException;
import javax.net.SocketFactory;
import org.activemq.io.WireFormat;
import org.activemq.transport.TransportChannel;
import org.activemq.transport.tcp.TcpTransportChannel;
import org.activemq.transport.tcp.TcpTransportChannelFactory;

public class SfTransportChannelFactory
extends TcpTransportChannelFactory {
    private SocketFactory socketFactory;
    private Executor executor;

    public SfTransportChannelFactory(SocketFactory socketFactory) {
        this.socketFactory = socketFactory;
    }

    public TransportChannel create(WireFormat wireFormat, URI remoteLocation) throws JMSException {
        Socket socket = null;
        try {
            socket = this.createSocket(remoteLocation);
        }
        catch (IOException e) {
            JMSException jmsEx = new JMSException("Creation of Socket failed: " + e);
            jmsEx.setLinkedException((Exception)e);
            throw jmsEx;
        }
        return this.populateProperties((TransportChannel)new TcpTransportChannel(wireFormat, socket, this.executor), remoteLocation);
    }

    public TransportChannel create(WireFormat wireFormat, URI remoteLocation, URI localLocation) throws JMSException {
        Socket socket = null;
        try {
            socket = this.createSocket(remoteLocation, localLocation);
        }
        catch (IOException e) {
            JMSException jmsEx = new JMSException("Creation of Socket failed: " + e);
            jmsEx.setLinkedException((Exception)e);
            throw jmsEx;
        }
        return this.populateProperties((TransportChannel)new TcpTransportChannel(wireFormat, socket, this.executor), remoteLocation);
    }

    protected Socket createSocket(URI remoteLocation) throws IOException {
        return this.socketFactory.createSocket(remoteLocation.getHost(), remoteLocation.getPort());
    }

    protected Socket createSocket(URI remoteLocation, URI localLocation) throws IOException {
        return this.socketFactory.createSocket(remoteLocation.getHost(), remoteLocation.getPort(), InetAddress.getByName(localLocation.getHost()), localLocation.getPort());
    }
}

