/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.transport.tcp;

import EDU.oswego.cs.dl.util.concurrent.BoundedBuffer;
import EDU.oswego.cs.dl.util.concurrent.Channel;
import EDU.oswego.cs.dl.util.concurrent.Executor;
import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import javax.jms.JMSException;
import org.activemq.io.WireFormat;
import org.activemq.transport.TransportServerChannelSupport;
import org.activemq.transport.tcp.TcpTransportChannel;
import org.activemq.util.JMSExceptionHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TcpTransportServerChannel
extends TransportServerChannelSupport
implements Runnable {
    private static final Log log = LogFactory.getLog((Class)TcpTransportServerChannel.class);
    protected static final int DEFAULT_BACKLOG = 500;
    private WireFormat wireFormat;
    private Thread serverSocketThread;
    private ServerSocket serverSocket;
    private SynchronizedBoolean closed;
    private SynchronizedBoolean started;
    private boolean useAsyncSend = false;
    private int maxOutstandingMessages = 10;
    private int backlog = 500;

    public TcpTransportServerChannel(WireFormat wireFormat, URI bindAddr) throws JMSException {
        super(bindAddr);
        this.wireFormat = wireFormat;
        this.closed = new SynchronizedBoolean(false);
        this.started = new SynchronizedBoolean(false);
        try {
            this.serverSocket = this.createServerSocket(bindAddr);
            this.serverSocket.setSoTimeout(2000);
            this.updatePhysicalUri(bindAddr);
        }
        catch (Exception se) {
            System.out.println(se);
            se.printStackTrace();
            throw JMSExceptionHelper.newJMSException("Bind to " + bindAddr + " failed: " + se.getMessage(), se);
        }
    }

    public TcpTransportServerChannel(WireFormat wireFormat, ServerSocket serverSocket) throws JMSException {
        super(serverSocket.getInetAddress().toString());
        this.wireFormat = wireFormat;
        this.serverSocket = serverSocket;
        this.closed = new SynchronizedBoolean(false);
        this.started = new SynchronizedBoolean(false);
        InetAddress address = serverSocket.getInetAddress();
        try {
            this.updatePhysicalUri(new URI("tcp", "", address.getHostName(), 0, "", "", ""));
        }
        catch (URISyntaxException e) {
            throw JMSExceptionHelper.newJMSException("Failed to extract URI: : " + e.getMessage(), e);
        }
    }

    public void start() throws JMSException {
        super.start();
        if (this.started.commit(false, true)) {
            log.info((Object)("Listening for connections at: " + this.getUrl()));
            this.serverSocketThread = new Thread((Runnable)this, this.toString());
            this.serverSocketThread.setDaemon(true);
            this.serverSocketThread.start();
        }
    }

    public void stop() throws JMSException {
        if (this.closed.commit(false, true)) {
            super.stop();
            try {
                if (this.serverSocket != null) {
                    this.serverSocket.close();
                    this.serverSocketThread.join();
                    this.serverSocketThread = null;
                }
            }
            catch (Throwable e) {
                throw JMSExceptionHelper.newJMSException("Failed to stop: " + e, e);
            }
        }
    }

    public String toString() {
        return "TcpTransportServerChannel@" + this.getUrl();
    }

    public void run() {
        while (!this.closed.get()) {
            Socket socket = null;
            try {
                socket = this.serverSocket.accept();
                if (socket == null) continue;
                if (this.closed.get()) {
                    socket.close();
                    continue;
                }
                PooledExecutor executor = null;
                if (this.useAsyncSend) {
                    executor = new PooledExecutor((Channel)new BoundedBuffer(this.maxOutstandingMessages), 1);
                    executor.setKeepAliveTime(1000L);
                }
                TcpTransportChannel channel = new TcpTransportChannel(this, this.wireFormat.copy(), socket, (Executor)executor);
                this.addClient(channel);
            }
            catch (SocketTimeoutException ste) {
            }
            catch (Throwable e) {
                if (this.closed.get()) continue;
                log.warn((Object)"run()", e);
            }
        }
    }

    public boolean isUseAsyncSend() {
        return this.useAsyncSend;
    }

    public void setUseAsyncSend(boolean useAsyncSend) {
        this.useAsyncSend = useAsyncSend;
    }

    public int getMaxOutstandingMessages() {
        return this.maxOutstandingMessages;
    }

    public void setMaxOutstandingMessages(int maxOutstandingMessages) {
        this.maxOutstandingMessages = maxOutstandingMessages;
    }

    public int getBacklog() {
        return this.backlog;
    }

    public void setBacklog(int backlog) {
        this.backlog = backlog;
    }

    public WireFormat getWireFormat() {
        return this.wireFormat;
    }

    public void setWireFormat(WireFormat wireFormat) {
        this.wireFormat = wireFormat;
    }

    protected void updatePhysicalUri(URI bindAddr) throws URISyntaxException {
        URI newURI = new URI(bindAddr.getScheme(), bindAddr.getUserInfo(), this.resolveHostName(bindAddr.getHost()), this.serverSocket.getLocalPort(), bindAddr.getPath(), bindAddr.getQuery(), bindAddr.getFragment());
        this.setUrl(newURI.toString());
    }

    protected ServerSocket createServerSocket(URI bind) throws UnknownHostException, IOException {
        ServerSocket answer = null;
        String host = bind.getHost();
        host = host == null || host.length() == 0 ? "localhost" : host;
        InetAddress addr = InetAddress.getByName(host);
        answer = host.trim().equals("localhost") || addr.equals(InetAddress.getLocalHost()) ? new ServerSocket(bind.getPort(), this.backlog) : new ServerSocket(bind.getPort(), this.backlog, addr);
        return answer;
    }
}

