/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.lang.reflect.Proxy;
import org.activemq.util.ClassLoading;

public class SerializationHelper {
    private static final ClassLoader ACTIVEMQ_CLASSLOADER = SerializationHelper.class.getClassLoader();

    public static byte[] writeObject(Object object) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(buffer);
        out.writeObject(object);
        out.close();
        return buffer.toByteArray();
    }

    public static Object readObject(byte[] data) throws IOException, ClassNotFoundException {
        ByteArrayInputStream buffer = new ByteArrayInputStream(data);
        ObjectInputStreamExt in = new ObjectInputStreamExt(buffer);
        Object answer = in.readObject();
        in.close();
        return answer;
    }

    public static Object readObject(InputStream in) throws IOException, ClassNotFoundException {
        ObjectInputStreamExt objIn = new ObjectInputStreamExt(in);
        Object result = objIn.readObject();
        return result;
    }

    public static void writeObject(OutputStream out, Object obj) throws IOException {
        ObjectOutputStream objOut = new ObjectOutputStream(out);
        objOut.writeObject(obj);
        objOut.flush();
    }

    public static class ObjectInputStreamExt
    extends ObjectInputStream {
        public ObjectInputStreamExt(InputStream in) throws IOException {
            super(in);
        }

        protected Class resolveClass(ObjectStreamClass classDesc) throws IOException, ClassNotFoundException {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            return this.load(classDesc.getName(), cl);
        }

        protected Class resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Class[] cinterfaces = new Class[interfaces.length];
            for (int i = 0; i < interfaces.length; ++i) {
                cinterfaces[i] = this.load(interfaces[i], cl);
            }
            try {
                return Proxy.getProxyClass(cinterfaces[0].getClassLoader(), cinterfaces);
            }
            catch (IllegalArgumentException e) {
                throw new ClassNotFoundException(null, e);
            }
        }

        private Class load(String className, ClassLoader cl) throws ClassNotFoundException {
            try {
                return ClassLoading.loadClass(className, cl);
            }
            catch (ClassNotFoundException e) {
                return ClassLoading.loadClass(className, ACTIVEMQ_CLASSLOADER);
            }
        }
    }
}

