/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.message;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;
import org.activemq.io.util.ByteArray;
import org.activemq.io.util.ByteArrayCompression;
import org.activemq.message.ActiveMQMessage;

public class ActiveMQBytesMessage
extends ActiveMQMessage
implements BytesMessage {
    private DataOutputStream dataOut;
    private ByteArrayOutputStream bytesOut;
    private DataInputStream dataIn;

    public int getPacketType() {
        return 9;
    }

    public ActiveMQMessage shallowCopy() throws JMSException {
        ActiveMQBytesMessage other = new ActiveMQBytesMessage();
        this.initializeOther(other);
        try {
            other.setBodyAsBytes(this.getBodyAsBytes());
        }
        catch (IOException e) {
            JMSException jmsEx = new JMSException("setBodyAsBytes() failed");
            jmsEx.setLinkedException((Exception)e);
            throw jmsEx;
        }
        return other;
    }

    public ActiveMQMessage deepCopy() throws JMSException {
        ActiveMQBytesMessage other = new ActiveMQBytesMessage();
        this.initializeOther(other);
        try {
            if (this.getBodyAsBytes() != null) {
                ByteArray data = this.getBodyAsBytes().copy();
                other.setBodyAsBytes(data);
            }
        }
        catch (IOException e) {
            JMSException jmsEx = new JMSException("setBodyAsBytes() failed");
            jmsEx.setLinkedException((Exception)e);
            throw jmsEx;
        }
        return other;
    }

    public void setBodyAsBytes(byte[] bodyAsBytes, int offset, int length) {
        super.setBodyAsBytes(bodyAsBytes, offset, length);
        this.dataOut = null;
        this.dataIn = null;
    }

    public ByteArray getBodyAsBytes() throws IOException {
        if (this.dataOut != null) {
            this.dataOut.flush();
            byte[] data = this.bytesOut.toByteArray();
            super.setBodyAsBytes(data, 0, data.length);
            this.dataOut.close();
            this.dataOut = null;
        }
        return super.getBodyAsBytes();
    }

    public void clearBody() throws JMSException {
        super.clearBody();
        this.dataOut = null;
        this.dataIn = null;
        this.bytesOut = null;
    }

    public long getBodyLength() throws JMSException {
        if (!this.readOnlyMessage) {
            throw new MessageNotReadableException("This message is in write-only mode");
        }
        long length = 0L;
        try {
            if (super.getBodyAsBytes() != null) {
                length = super.getBodyAsBytes().getLength();
            }
        }
        catch (IOException e) {
            JMSException jmsEx = new JMSException("getBodyAsBytes() failed");
            jmsEx.setLinkedException((Exception)e);
            throw jmsEx;
        }
        return length;
    }

    public boolean readBoolean() throws JMSException {
        this.initializeReading();
        try {
            return this.dataIn.readBoolean();
        }
        catch (EOFException eof) {
            MessageEOFException jmsEx = new MessageEOFException(eof.getMessage());
            jmsEx.setLinkedException((Exception)eof);
            throw jmsEx;
        }
        catch (IOException ioe) {
            JMSException jmsEx = new JMSException("Format error occured" + ioe.getMessage());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public byte readByte() throws JMSException {
        this.initializeReading();
        try {
            return this.dataIn.readByte();
        }
        catch (EOFException eof) {
            MessageEOFException jmsEx = new MessageEOFException(eof.getMessage());
            jmsEx.setLinkedException((Exception)eof);
            throw jmsEx;
        }
        catch (IOException ioe) {
            JMSException jmsEx = new JMSException("Format error occured" + ioe.getMessage());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public int readUnsignedByte() throws JMSException {
        this.initializeReading();
        try {
            return this.dataIn.readUnsignedByte();
        }
        catch (EOFException eof) {
            MessageEOFException jmsEx = new MessageEOFException(eof.getMessage());
            jmsEx.setLinkedException((Exception)eof);
            throw jmsEx;
        }
        catch (IOException ioe) {
            JMSException jmsEx = new JMSException("Format error occured" + ioe.getMessage());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public short readShort() throws JMSException {
        this.initializeReading();
        try {
            return this.dataIn.readShort();
        }
        catch (EOFException eof) {
            MessageEOFException jmsEx = new MessageEOFException(eof.getMessage());
            jmsEx.setLinkedException((Exception)eof);
            throw jmsEx;
        }
        catch (IOException ioe) {
            JMSException jmsEx = new JMSException("Format error occured" + ioe.getMessage());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public int readUnsignedShort() throws JMSException {
        this.initializeReading();
        try {
            return this.dataIn.readUnsignedShort();
        }
        catch (EOFException eof) {
            MessageEOFException jmsEx = new MessageEOFException(eof.getMessage());
            jmsEx.setLinkedException((Exception)eof);
            throw jmsEx;
        }
        catch (IOException ioe) {
            JMSException jmsEx = new JMSException("Format error occured" + ioe.getMessage());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public char readChar() throws JMSException {
        this.initializeReading();
        try {
            return this.dataIn.readChar();
        }
        catch (EOFException eof) {
            MessageEOFException jmsEx = new MessageEOFException(eof.getMessage());
            jmsEx.setLinkedException((Exception)eof);
            throw jmsEx;
        }
        catch (IOException ioe) {
            JMSException jmsEx = new JMSException("Format error occured" + ioe.getMessage());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public int readInt() throws JMSException {
        this.initializeReading();
        try {
            return this.dataIn.readInt();
        }
        catch (EOFException eof) {
            MessageEOFException jmsEx = new MessageEOFException(eof.getMessage());
            jmsEx.setLinkedException((Exception)eof);
            throw jmsEx;
        }
        catch (IOException ioe) {
            JMSException jmsEx = new JMSException("Format error occured" + ioe.getMessage());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public long readLong() throws JMSException {
        this.initializeReading();
        try {
            return this.dataIn.readLong();
        }
        catch (EOFException eof) {
            MessageEOFException jmsEx = new MessageEOFException(eof.getMessage());
            jmsEx.setLinkedException((Exception)eof);
            throw jmsEx;
        }
        catch (IOException ioe) {
            JMSException jmsEx = new JMSException("Format error occured" + ioe.getMessage());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public float readFloat() throws JMSException {
        this.initializeReading();
        try {
            return this.dataIn.readFloat();
        }
        catch (EOFException eof) {
            MessageEOFException jmsEx = new MessageEOFException(eof.getMessage());
            jmsEx.setLinkedException((Exception)eof);
            throw jmsEx;
        }
        catch (IOException ioe) {
            JMSException jmsEx = new JMSException("Format error occured" + ioe.getMessage());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public double readDouble() throws JMSException {
        this.initializeReading();
        try {
            return this.dataIn.readDouble();
        }
        catch (EOFException eof) {
            MessageEOFException jmsEx = new MessageEOFException(eof.getMessage());
            jmsEx.setLinkedException((Exception)eof);
            throw jmsEx;
        }
        catch (IOException ioe) {
            JMSException jmsEx = new JMSException("Format error occured" + ioe.getMessage());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public String readUTF() throws JMSException {
        this.initializeReading();
        try {
            return this.dataIn.readUTF();
        }
        catch (EOFException eof) {
            MessageEOFException jmsEx = new MessageEOFException(eof.getMessage());
            jmsEx.setLinkedException((Exception)eof);
            throw jmsEx;
        }
        catch (IOException ioe) {
            JMSException jmsEx = new JMSException("Format error occured" + ioe.getMessage());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public int readBytes(byte[] value) throws JMSException {
        return this.readBytes(value, value.length);
    }

    public int readBytes(byte[] value, int length) throws JMSException {
        this.initializeReading();
        try {
            int n;
            int count;
            for (n = 0; n < length && (count = this.dataIn.read(value, n, length - n)) >= 0; n += count) {
            }
            if (n == 0 && length > 0) {
                n = -1;
            }
            return n;
        }
        catch (EOFException eof) {
            MessageEOFException jmsEx = new MessageEOFException(eof.getMessage());
            jmsEx.setLinkedException((Exception)eof);
            throw jmsEx;
        }
        catch (IOException ioe) {
            JMSException jmsEx = new JMSException("Format error occured" + ioe.getMessage());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public void writeBoolean(boolean value) throws JMSException {
        this.initializeWriting();
        try {
            this.dataOut.writeBoolean(value);
        }
        catch (IOException ioe) {
            JMSException jmsEx = new JMSException("Could not write data:" + ioe.getMessage());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public void writeByte(byte value) throws JMSException {
        this.initializeWriting();
        try {
            this.dataOut.writeByte(value);
        }
        catch (IOException ioe) {
            JMSException jmsEx = new JMSException("Could not write data:" + ioe.getMessage());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public void writeShort(short value) throws JMSException {
        this.initializeWriting();
        try {
            this.dataOut.writeShort(value);
        }
        catch (IOException ioe) {
            JMSException jmsEx = new JMSException("Could not write data:" + ioe.getMessage());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public void writeChar(char value) throws JMSException {
        this.initializeWriting();
        try {
            this.dataOut.writeChar(value);
        }
        catch (IOException ioe) {
            JMSException jmsEx = new JMSException("Could not write data:" + ioe.getMessage());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public void writeInt(int value) throws JMSException {
        this.initializeWriting();
        try {
            this.dataOut.writeInt(value);
        }
        catch (IOException ioe) {
            JMSException jmsEx = new JMSException("Could not write data:" + ioe.getMessage());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public void writeLong(long value) throws JMSException {
        this.initializeWriting();
        try {
            this.dataOut.writeLong(value);
        }
        catch (IOException ioe) {
            JMSException jmsEx = new JMSException("Could not write data:" + ioe.getMessage());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public void writeFloat(float value) throws JMSException {
        this.initializeWriting();
        try {
            this.dataOut.writeFloat(value);
        }
        catch (IOException ioe) {
            JMSException jmsEx = new JMSException("Could not write data:" + ioe.getMessage());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public void writeDouble(double value) throws JMSException {
        this.initializeWriting();
        try {
            this.dataOut.writeDouble(value);
        }
        catch (IOException ioe) {
            JMSException jmsEx = new JMSException("Could not write data:" + ioe.getMessage());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public void writeUTF(String value) throws JMSException {
        this.initializeWriting();
        try {
            this.dataOut.writeUTF(value);
        }
        catch (IOException ioe) {
            JMSException jmsEx = new JMSException("Could not write data:" + ioe.getMessage());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public void writeBytes(byte[] value) throws JMSException {
        this.initializeWriting();
        try {
            this.dataOut.write(value);
        }
        catch (IOException ioe) {
            JMSException jmsEx = new JMSException("Could not write data:" + ioe.getMessage());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public void writeBytes(byte[] value, int offset, int length) throws JMSException {
        this.initializeWriting();
        try {
            this.dataOut.write(value, offset, length);
        }
        catch (IOException ioe) {
            JMSException jmsEx = new JMSException("Could not write data:" + ioe.getMessage());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public void writeObject(Object value) throws JMSException {
        if (value == null) {
            throw new NullPointerException();
        }
        this.initializeWriting();
        if (value instanceof Boolean) {
            this.writeBoolean((Boolean)value);
        } else if (value instanceof Character) {
            this.writeChar(((Character)value).charValue());
        } else if (value instanceof Byte) {
            this.writeByte((Byte)value);
        } else if (value instanceof Short) {
            this.writeShort((Short)value);
        } else if (value instanceof Integer) {
            this.writeInt((Integer)value);
        } else if (value instanceof Double) {
            this.writeDouble((Double)value);
        } else if (value instanceof Long) {
            this.writeLong((Long)value);
        } else if (value instanceof Float) {
            this.writeFloat(((Float)value).floatValue());
        } else if (value instanceof Double) {
            this.writeDouble((Double)value);
        } else if (value instanceof String) {
            this.writeUTF(value.toString());
        } else if (value instanceof byte[]) {
            this.writeBytes((byte[])value);
        } else {
            throw new MessageFormatException("Cannot write non-primitive type:" + value.getClass());
        }
    }

    public void reset() throws JMSException {
        this.readOnlyMessage = true;
        if (this.dataOut != null) {
            try {
                this.dataOut.flush();
                byte[] data = this.bytesOut.toByteArray();
                super.setBodyAsBytes(data, 0, data.length);
                this.dataOut.close();
            }
            catch (IOException ioe) {
                JMSException jmsEx = new JMSException("reset failed: " + ioe.getMessage());
                jmsEx.setLinkedException((Exception)ioe);
                throw jmsEx;
            }
        }
        this.bytesOut = null;
        this.dataIn = null;
        this.dataOut = null;
    }

    private void initializeWriting() throws MessageNotWriteableException {
        if (this.readOnlyMessage) {
            throw new MessageNotWriteableException("This message is in read-only mode");
        }
        if (this.dataOut == null) {
            this.bytesOut = new ByteArrayOutputStream();
            this.dataOut = new DataOutputStream(this.bytesOut);
        }
    }

    private void initializeReading() throws MessageNotReadableException {
        if (!this.readOnlyMessage) {
            throw new MessageNotReadableException("This message is in write-only mode");
        }
        try {
            ByteArray data = super.getBodyAsBytes();
            if (this.dataIn == null && data != null) {
                if (ByteArrayCompression.isCompressed(data)) {
                    ByteArrayCompression compression = new ByteArrayCompression();
                    data = compression.inflate(data);
                }
                ByteArrayInputStream bytesIn = new ByteArrayInputStream(data.getBuf(), data.getOffset(), data.getLength());
                this.dataIn = new DataInputStream(bytesIn);
            }
        }
        catch (IOException e) {
            MessageNotReadableException mnr = new MessageNotReadableException("getBodyAsBytes failed");
            mnr.setLinkedException((Exception)e);
            throw mnr;
        }
    }

    public String toString() {
        return super.toString() + " ActiveMQBytesMessage{ " + "bytesOut = " + this.bytesOut + ", dataOut = " + this.dataOut + ", dataIn = " + this.dataIn + " }";
    }
}

